"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .languagecode_parameter import LanguageCodeParameter
from .retrieverequest import RetrieveRequest, RetrieveRequestTypedDict
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


RETRIEVE_CHUNKS_OP_SERVERS = [
    # aiservices
    "https://${API_DOMAIN}/core/aiservices/v4",
]


class RetrieveChunksRequestTypedDict(TypedDict):
    q: str
    r"""The search query string. The string must be escaped as required by the URL syntax rules."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    filter_user_profile_id: NotRequired[str]
    language: NotRequired[LanguageCodeParameter]
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used."""
    filter_tags: NotRequired[Dict[str, List[str]]]
    r"""An object where each key is a **Category Tag ID** (numeric string),
    and each value is an array of **Tag IDs** for that category.

    """
    filter_topic_ids: NotRequired[List[str]]
    r"""An array of topic IDs. It is used to restrict search results to specific topics."""
    retrieve_request: NotRequired[RetrieveRequestTypedDict]


class RetrieveChunksRequest(BaseModel):
    q: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The search query string. The string must be escaped as required by the URL syntax rules."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    filter_user_profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="$filter[userProfileID]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    language: Annotated[
        Optional[LanguageCodeParameter],
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used."""

    filter_tags: Annotated[
        Optional[Dict[str, List[str]]],
        pydantic.Field(alias="$filter[tags]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An object where each key is a **Category Tag ID** (numeric string),
    and each value is an array of **Tag IDs** for that category.

    """

    filter_topic_ids: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="$filter[topicIds]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An array of topic IDs. It is used to restrict search results to specific topics."""

    retrieve_request: Annotated[
        Optional[RetrieveRequest],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
