"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .mandatorylanguagequeryparameter import MandatoryLanguageQueryParameter
from .startescalationrequest import (
    StartEscalationRequest,
    StartEscalationRequestTypedDict,
)
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Dict, List
from typing_extensions import Annotated, TypedDict


class StartCustomerEscalationRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    language: MandatoryLanguageQueryParameter
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""
    start_escalation_request: StartEscalationRequestTypedDict


class StartCustomerEscalationRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    language: Annotated[
        MandatoryLanguageQueryParameter,
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""

    start_escalation_request: Annotated[
        StartEscalationRequest,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class StartCustomerEscalationResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]


class StartCustomerEscalationResponse(BaseModel):
    headers: Dict[str, List[str]]
