"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createdby import CreatedBy, CreatedByTypedDict
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CaseListResultTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The numerical ID of the case."""
    short_name: NotRequired[str]
    r"""short name of the case."""
    title: NotRequired[str]
    r"""title of the case"""
    profile_id: NotRequired[str]
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """
    release_id: NotRequired[str]
    r"""The numerical ID of the Casebase Release in which case in created"""
    cluster_id: NotRequired[str]
    r"""ID of the cluster in which case is created"""
    created_date: NotRequired[str]
    r"""The date on which the Case was created."""
    created_by: NotRequired[CreatedByTypedDict]
    modified_by: NotRequired[ModifiedByTypedDict]
    modified_date: NotRequired[str]
    r"""The date on which the Case was last modified."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class CaseListResult(BaseModel):
    id: Optional[str] = None
    r"""The numerical ID of the case."""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""short name of the case."""

    title: Optional[str] = None
    r"""title of the case"""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """

    release_id: Annotated[Optional[str], pydantic.Field(alias="releaseId")] = None
    r"""The numerical ID of the Casebase Release in which case in created"""

    cluster_id: Annotated[Optional[str], pydantic.Field(alias="clusterId")] = None
    r"""ID of the cluster in which case is created"""

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None
    r"""The date on which the Case was created."""

    created_by: Annotated[Optional[CreatedBy], pydantic.Field(alias="createdBy")] = None

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the Case was last modified."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
