"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .order import Order
from .sortidname import SortIDName
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


FilterStatus = Literal[
    "suggested",
    "pending",
    "declined",
    "approved",
]
r"""The search filter applied to the list of suggestions by a user."""


class SearchSuggestionRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    filter_status: FilterStatus
    r"""The search filter applied to the list of suggestions by a user."""
    sort: NotRequired[SortIDName]
    r"""Objects returned in server response are sorted based on the attribute supplied under $sort."""
    order: NotRequired[Order]
    r"""Common query parameter $order."""
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""


class SearchSuggestionRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    filter_status: Annotated[
        FilterStatus,
        pydantic.Field(alias="filter[status]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The search filter applied to the list of suggestions by a user."""

    sort: Annotated[
        Optional[SortIDName],
        pydantic.Field(alias="$sort"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Objects returned in server response are sorted based on the attribute supplied under $sort."""

    order: Annotated[
        Optional[Order],
        pydantic.Field(alias="$order"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Common query parameter $order."""

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 25
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""
