"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .actionsearch import ActionSearch, ActionSearchTypedDict
from .answeredquestion import AnsweredQuestion, AnsweredQuestionTypedDict
from .casebase import Casebase, CasebaseTypedDict
from .casesearch import CaseSearch, CaseSearchTypedDict
from .clusterid import ClusterID, ClusterIDTypedDict
from .dynamicsearch import DynamicSearch, DynamicSearchTypedDict
from .question import Question, QuestionTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GHSearchResultTypedDict(TypedDict):
    r"""Success"""

    casebase: NotRequired[CasebaseTypedDict]
    action_search: NotRequired[List[ActionSearchTypedDict]]
    r"""actions in the search"""
    answered_question: NotRequired[List[AnsweredQuestionTypedDict]]
    r"""questions answered in the search"""
    case_search: NotRequired[List[CaseSearchTypedDict]]
    r"""cases in the search"""
    dynamic_search: NotRequired[List[DynamicSearchTypedDict]]
    r"""dynamic cases in the search"""
    unanswered_question: NotRequired[List[QuestionTypedDict]]
    r"""unanswered questions in the search"""
    startup_question: NotRequired[List[QuestionTypedDict]]
    r"""startup questions in the search"""
    target_clusters: NotRequired[List[ClusterIDTypedDict]]
    r"""active clusters in the search"""


class GHSearchResult(BaseModel):
    r"""Success"""

    casebase: Optional[Casebase] = None

    action_search: Annotated[
        Optional[List[ActionSearch]], pydantic.Field(alias="actionSearch")
    ] = None
    r"""actions in the search"""

    answered_question: Annotated[
        Optional[List[AnsweredQuestion]], pydantic.Field(alias="answeredQuestion")
    ] = None
    r"""questions answered in the search"""

    case_search: Annotated[
        Optional[List[CaseSearch]], pydantic.Field(alias="caseSearch")
    ] = None
    r"""cases in the search"""

    dynamic_search: Annotated[
        Optional[List[DynamicSearch]], pydantic.Field(alias="dynamicSearch")
    ] = None
    r"""dynamic cases in the search"""

    unanswered_question: Annotated[
        Optional[List[Question]], pydantic.Field(alias="unansweredQuestion")
    ] = None
    r"""unanswered questions in the search"""

    startup_question: Annotated[
        Optional[List[Question]], pydantic.Field(alias="startupQuestion")
    ] = None
    r"""startup questions in the search"""

    target_clusters: Annotated[
        Optional[List[ClusterID]], pydantic.Field(alias="targetClusters")
    ] = None
    r"""active clusters in the search"""
