"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .configurableattributes import (
    ConfigurableAttributes,
    ConfigurableAttributesTypedDict,
)
from .searchfilterattribute import SearchFilterAttribute, SearchFilterAttributeTypedDict
from .tagcategoriesforinterest import (
    TagCategoriesForInterest,
    TagCategoriesForInterestTypedDict,
)
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


SearchLearningLevel = Literal[
    0,
    1,
    2,
    3,
    4,
]
r"""Affects the influence of learning on search rankings. 0 = off, 1 = low, 2 = medium, 3 = high, 4 = custom."""


class PortalSettingsTypedDict(TypedDict):
    r"""The settings for this portal."""

    is_annoucements_enabled: NotRequired[bool]
    r"""Whether the announcements section is enabled on this portal."""
    is_article_feedback_enabled: NotRequired[bool]
    r"""Whether article feedback is allowed."""
    is_article_feedback_comments_enabled: NotRequired[bool]
    r"""Whether comments should be included in the feedback."""
    is_article_feedback_summary_enabled: NotRequired[bool]
    r"""Whether a summary of feedback ratings should be displayed."""
    is_related_articles_in_same_topic_enabled: NotRequired[bool]
    r"""Whether all articles in the same topic are automatically treated as related articles."""
    is_related_articles_enabled: NotRequired[bool]
    r"""Whether the related articles section is shown."""
    is_authentication_required: NotRequired[bool]
    r"""Whether the portal requires authentication for access."""
    is_agents_sso_enabled: NotRequired[bool]
    r"""Whether SSO is enabled for agents"""
    is_agents_delegated_authentication_enabled: NotRequired[bool]
    r"""Whether delegated authentication is enabled for agents"""
    customer_profile_attributes: NotRequired[ConfigurableAttributesTypedDict]
    is_popular_articles_list_enabled: NotRequired[bool]
    r"""Whether the popular articles list is displayed. Maximum of 50 popular articles will be dislpayed."""
    popular_articles_list_influence_weight: NotRequired[float]
    r"""The weight assigned to the influence of related articles on the ranking of popular articles in the ranking formula."""
    popular_articles_list_influence_period: NotRequired[int]
    r"""The timeframe in days that related articles affect the ranking of popular articles in the ranking formula."""
    append_session_journey_to_email: NotRequired[bool]
    r"""Whether the session transcript should be appended to the email message."""
    is_article_suggestions_before_escalation_enabled: NotRequired[bool]
    r"""Whether a user is  shown suggested articles before escalating."""
    is_escalation_to_email_enabled: NotRequired[bool]
    r"""Whether the user can ask a question via email if Guided Help doesn’t provide an answer, triggering a search before escalation."""
    number_of_suggested_articles_before_escalation: NotRequired[int]
    r"""The number of articles to show to a customer before escalation."""
    is_gh_enabled: NotRequired[bool]
    r"""Whether guided help is enabled."""
    is_gh_in_search_results_enabled: NotRequired[bool]
    r"""Whether to show guided help results in search results."""
    is_gh_startup_questions_before_unanswered_questions_enabled: NotRequired[bool]
    r"""Whether startup questions should be presented before unanswered questions in Guided Help."""
    is_gh_details_for_search_enabled: NotRequired[bool]
    r"""Whether additional information should be shown in search results."""
    is_gh_short_name_in_search_enabled: NotRequired[bool]
    r"""When enabled it shows the short names in results."""
    is_gh_cluster_scope_diagnostics_enabled: NotRequired[bool]
    r"""Whether to show Cluster scope diagnostics during execution."""
    is_gh_results_shown_on_successful_search: NotRequired[bool]
    r"""Whether to automatically display results on search success."""
    is_gh_control_action_diagnostics_enabled: NotRequired[bool]
    r"""isGHControlActionDiagnosticsEnabled"""
    gh_failure_success_threshold: NotRequired[float]
    r"""A value from range that indicates the failure-success score"""
    max_gh_answered_questions: NotRequired[int]
    r"""A value indicating the maximum number of answered questions."""
    max_gh_unanswered_questions: NotRequired[int]
    r"""A value indicating the maximum number of unanswered questions."""
    max_gh_search_results: NotRequired[int]
    r"""Maximum number of guided help results to return."""
    is_search_autocomplete_enabled: NotRequired[bool]
    r"""Whether the autocomplete interface should be enabled."""
    is_web_search_enabled: NotRequired[bool]
    r"""Whether web searches should be performed as part of multi-search."""
    max_web_search_results: NotRequired[int]
    r"""The maximum number of results from the web search to return."""
    web_search_domain: NotRequired[str]
    r"""Use this to restrict web search results to a specific domain."""
    is_intranet_search_enabled: NotRequired[bool]
    r"""Whether intranet results should be returned as part of multi-search."""
    max_intranet_search_results: NotRequired[int]
    r"""The maximum number of results from an intranet search to return."""
    intranet_search_url: NotRequired[str]
    r"""The URL for the Intranet Search."""
    is_spellcheck_enabled: NotRequired[bool]
    r"""Whether spell-correction should be performed on search queries. The corrected query is returned with the results, but is not automatically used."""
    question_matching_engine_url: NotRequired[str]
    r"""The URL for the question matching engine."""
    is_custom_attributes_filtering_enabled: NotRequired[bool]
    r"""Whether search results should be filtered by custom attribute values."""
    custom_attributes_for_search_filter: NotRequired[
        List[SearchFilterAttributeTypedDict]
    ]
    search_learning_inclusion_threshold: NotRequired[int]
    r"""The minimum number of accepts and rejects of an article before article ranking is affected."""
    search_learning_influence: NotRequired[int]
    r"""A ranking multiplier for learned scoring."""
    search_learning_level: NotRequired[SearchLearningLevel]
    r"""Affects the influence of learning on search rankings. 0 = off, 1 = low, 2 = medium, 3 = high, 4 = custom."""
    search_learning_max_influence: NotRequired[int]
    r"""The maximum influence allowed for learned scoring."""
    search_related_term_weight: NotRequired[float]
    r"""The weight assigned to related terms during search."""
    search_related_terms_min_results_threshold: NotRequired[int]
    r"""If the number of search results is less than or equal to this value, a search with related terms will be used to fill in results."""
    is_article_suggestions_enabled: NotRequired[bool]
    r"""Whether users can make suggestions on an article."""
    is_my_suggestions_enabled: NotRequired[bool]
    r"""Whether a user can view their suggestions."""
    is_captcha_enabled: NotRequired[bool]
    r"""Whether CAPTCHA is enabled or not in the portal."""
    captcha_site_key: NotRequired[str]
    r"""The configured CAPTCHA site key."""
    is_article_sharing_enabled: NotRequired[bool]
    r"""Whether the article sharing is enabled."""
    tag_categories_for_search_filter: NotRequired[TagCategoriesForInterestTypedDict]


class PortalSettings(BaseModel):
    r"""The settings for this portal."""

    is_annoucements_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isAnnoucementsEnabled")
    ] = None
    r"""Whether the announcements section is enabled on this portal."""

    is_article_feedback_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isArticleFeedbackEnabled")
    ] = None
    r"""Whether article feedback is allowed."""

    is_article_feedback_comments_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isArticleFeedbackCommentsEnabled")
    ] = None
    r"""Whether comments should be included in the feedback."""

    is_article_feedback_summary_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isArticleFeedbackSummaryEnabled")
    ] = None
    r"""Whether a summary of feedback ratings should be displayed."""

    is_related_articles_in_same_topic_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isRelatedArticlesInSameTopicEnabled")
    ] = None
    r"""Whether all articles in the same topic are automatically treated as related articles."""

    is_related_articles_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isRelatedArticlesEnabled")
    ] = None
    r"""Whether the related articles section is shown."""

    is_authentication_required: Annotated[
        Optional[bool], pydantic.Field(alias="isAuthenticationRequired")
    ] = None
    r"""Whether the portal requires authentication for access."""

    is_agents_sso_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isAgentsSSOEnabled")
    ] = None
    r"""Whether SSO is enabled for agents"""

    is_agents_delegated_authentication_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isAgentsDelegatedAuthenticationEnabled")
    ] = None
    r"""Whether delegated authentication is enabled for agents"""

    customer_profile_attributes: Annotated[
        Optional[ConfigurableAttributes],
        pydantic.Field(alias="customerProfileAttributes"),
    ] = None

    is_popular_articles_list_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isPopularArticlesListEnabled")
    ] = None
    r"""Whether the popular articles list is displayed. Maximum of 50 popular articles will be dislpayed."""

    popular_articles_list_influence_weight: Annotated[
        Optional[float], pydantic.Field(alias="popularArticlesListInfluenceWeight")
    ] = None
    r"""The weight assigned to the influence of related articles on the ranking of popular articles in the ranking formula."""

    popular_articles_list_influence_period: Annotated[
        Optional[int], pydantic.Field(alias="popularArticlesListInfluencePeriod")
    ] = None
    r"""The timeframe in days that related articles affect the ranking of popular articles in the ranking formula."""

    append_session_journey_to_email: Annotated[
        Optional[bool], pydantic.Field(alias="appendSessionJourneyToEmail")
    ] = None
    r"""Whether the session transcript should be appended to the email message."""

    is_article_suggestions_before_escalation_enabled: Annotated[
        Optional[bool],
        pydantic.Field(alias="isArticleSuggestionsBeforeEscalationEnabled"),
    ] = None
    r"""Whether a user is  shown suggested articles before escalating."""

    is_escalation_to_email_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isEscalationToEmailEnabled")
    ] = None
    r"""Whether the user can ask a question via email if Guided Help doesn’t provide an answer, triggering a search before escalation."""

    number_of_suggested_articles_before_escalation: Annotated[
        Optional[int], pydantic.Field(alias="numberOfSuggestedArticlesBeforeEscalation")
    ] = None
    r"""The number of articles to show to a customer before escalation."""

    is_gh_enabled: Annotated[Optional[bool], pydantic.Field(alias="isGHEnabled")] = None
    r"""Whether guided help is enabled."""

    is_gh_in_search_results_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isGHInSearchResultsEnabled")
    ] = None
    r"""Whether to show guided help results in search results."""

    is_gh_startup_questions_before_unanswered_questions_enabled: Annotated[
        Optional[bool],
        pydantic.Field(alias="isGHStartupQuestionsBeforeUnansweredQuestionsEnabled"),
    ] = None
    r"""Whether startup questions should be presented before unanswered questions in Guided Help."""

    is_gh_details_for_search_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isGHDetailsForSearchEnabled")
    ] = None
    r"""Whether additional information should be shown in search results."""

    is_gh_short_name_in_search_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isGHShortNameInSearchEnabled")
    ] = None
    r"""When enabled it shows the short names in results."""

    is_gh_cluster_scope_diagnostics_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isGHClusterScopeDiagnosticsEnabled")
    ] = None
    r"""Whether to show Cluster scope diagnostics during execution."""

    is_gh_results_shown_on_successful_search: Annotated[
        Optional[bool], pydantic.Field(alias="isGHResultsShownOnSuccessfulSearch")
    ] = None
    r"""Whether to automatically display results on search success."""

    is_gh_control_action_diagnostics_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isGHControlActionDiagnosticsEnabled")
    ] = None
    r"""isGHControlActionDiagnosticsEnabled"""

    gh_failure_success_threshold: Annotated[
        Optional[float], pydantic.Field(alias="GHFailureSuccessThreshold")
    ] = None
    r"""A value from range that indicates the failure-success score"""

    max_gh_answered_questions: Annotated[
        Optional[int], pydantic.Field(alias="maxGHAnsweredQuestions")
    ] = None
    r"""A value indicating the maximum number of answered questions."""

    max_gh_unanswered_questions: Annotated[
        Optional[int], pydantic.Field(alias="maxGHUnansweredQuestions")
    ] = None
    r"""A value indicating the maximum number of unanswered questions."""

    max_gh_search_results: Annotated[
        Optional[int], pydantic.Field(alias="maxGHSearchResults")
    ] = None
    r"""Maximum number of guided help results to return."""

    is_search_autocomplete_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isSearchAutocompleteEnabled")
    ] = None
    r"""Whether the autocomplete interface should be enabled."""

    is_web_search_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isWebSearchEnabled")
    ] = None
    r"""Whether web searches should be performed as part of multi-search."""

    max_web_search_results: Annotated[
        Optional[int], pydantic.Field(alias="maxWebSearchResults")
    ] = None
    r"""The maximum number of results from the web search to return."""

    web_search_domain: Annotated[
        Optional[str], pydantic.Field(alias="webSearchDomain")
    ] = None
    r"""Use this to restrict web search results to a specific domain."""

    is_intranet_search_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isIntranetSearchEnabled")
    ] = None
    r"""Whether intranet results should be returned as part of multi-search."""

    max_intranet_search_results: Annotated[
        Optional[int], pydantic.Field(alias="maxIntranetSearchResults")
    ] = None
    r"""The maximum number of results from an intranet search to return."""

    intranet_search_url: Annotated[
        Optional[str], pydantic.Field(alias="intranetSearchURL")
    ] = None
    r"""The URL for the Intranet Search."""

    is_spellcheck_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isSpellcheckEnabled")
    ] = None
    r"""Whether spell-correction should be performed on search queries. The corrected query is returned with the results, but is not automatically used."""

    question_matching_engine_url: Annotated[
        Optional[str], pydantic.Field(alias="questionMatchingEngineURL")
    ] = None
    r"""The URL for the question matching engine."""

    is_custom_attributes_filtering_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isCustomAttributesFilteringEnabled")
    ] = None
    r"""Whether search results should be filtered by custom attribute values."""

    custom_attributes_for_search_filter: Annotated[
        Optional[List[SearchFilterAttribute]],
        pydantic.Field(alias="customAttributesForSearchFilter"),
    ] = None

    search_learning_inclusion_threshold: Annotated[
        Optional[int], pydantic.Field(alias="searchLearningInclusionThreshold")
    ] = None
    r"""The minimum number of accepts and rejects of an article before article ranking is affected."""

    search_learning_influence: Annotated[
        Optional[int], pydantic.Field(alias="searchLearningInfluence")
    ] = None
    r"""A ranking multiplier for learned scoring."""

    search_learning_level: Annotated[
        Optional[SearchLearningLevel], pydantic.Field(alias="searchLearningLevel")
    ] = None
    r"""Affects the influence of learning on search rankings. 0 = off, 1 = low, 2 = medium, 3 = high, 4 = custom."""

    search_learning_max_influence: Annotated[
        Optional[int], pydantic.Field(alias="searchLearningMaxInfluence")
    ] = None
    r"""The maximum influence allowed for learned scoring."""

    search_related_term_weight: Annotated[
        Optional[float], pydantic.Field(alias="searchRelatedTermWeight")
    ] = None
    r"""The weight assigned to related terms during search."""

    search_related_terms_min_results_threshold: Annotated[
        Optional[int], pydantic.Field(alias="searchRelatedTermsMinResultsThreshold")
    ] = None
    r"""If the number of search results is less than or equal to this value, a search with related terms will be used to fill in results."""

    is_article_suggestions_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isArticleSuggestionsEnabled")
    ] = None
    r"""Whether users can make suggestions on an article."""

    is_my_suggestions_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isMySuggestionsEnabled")
    ] = None
    r"""Whether a user can view their suggestions."""

    is_captcha_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isCaptchaEnabled")
    ] = None
    r"""Whether CAPTCHA is enabled or not in the portal."""

    captcha_site_key: Annotated[
        Optional[str], pydantic.Field(alias="captchaSiteKey")
    ] = None
    r"""The configured CAPTCHA site key."""

    is_article_sharing_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isArticleSharingEnabled")
    ] = None
    r"""Whether the article sharing is enabled."""

    tag_categories_for_search_filter: Annotated[
        Optional[TagCategoriesForInterest],
        pydantic.Field(alias="tagCategoriesForSearchFilter"),
    ] = None
