"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .topicbreadcrumb import TopicBreadcrumb, TopicBreadcrumbTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


SearchResultDocType = Literal[
    "HTML",
    "Doc",
    "Pdf",
]
r"""Format of the source document (HTML, Doc, or PDF)."""


SearchResultSource = Literal[
    "eGain Article",
    "eGain Attachment",
]
r"""The repository or system where the content originated (e.g., eGain Article, eGain Attachment)."""


SnippetType = Literal[
    "chunks",
    "articleContent",
]


class SearchResultTypedDict(TypedDict):
    r"""Represents a single document or snippet returned by search, along with its metadata and relevance score."""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the Article or source content."""
    doc_type: SearchResultDocType
    r"""Format of the source document (HTML, Doc, or PDF)."""
    source: SearchResultSource
    r"""The repository or system where the content originated (e.g., eGain Article, eGain Attachment)."""
    snippet: str
    r"""Retrieved text returned for the query. This may be a **chunk of an article** or the **entire article content** if the content is small enough."""
    relevance_score: float
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""
    doc_name: NotRequired[str]
    r"""Name of the attachment, if an attachment was used as the source content."""
    snippet_type: NotRequired[SnippetType]
    topic_bread_crumb: NotRequired[TopicBreadcrumbTypedDict]
    r"""This schema contains one or more TopicSummary instances."""


class SearchResult(BaseModel):
    r"""Represents a single document or snippet returned by search, along with its metadata and relevance score."""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the Article or source content."""

    doc_type: Annotated[SearchResultDocType, pydantic.Field(alias="docType")]
    r"""Format of the source document (HTML, Doc, or PDF)."""

    source: SearchResultSource
    r"""The repository or system where the content originated (e.g., eGain Article, eGain Attachment)."""

    snippet: str
    r"""Retrieved text returned for the query. This may be a **chunk of an article** or the **entire article content** if the content is small enough."""

    relevance_score: Annotated[float, pydantic.Field(alias="relevanceScore")]
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""

    doc_name: Annotated[Optional[str], pydantic.Field(alias="docName")] = None
    r"""Name of the attachment, if an attachment was used as the source content."""

    snippet_type: Annotated[
        Optional[SnippetType], pydantic.Field(alias="snippetType")
    ] = None

    topic_bread_crumb: Annotated[
        Optional[TopicBreadcrumb], pydantic.Field(alias="topicBreadCrumb")
    ] = None
    r"""This schema contains one or more TopicSummary instances."""
