"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class PortalSuggestion(BaseSDK):
    def make_suggestion(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        name: str,
        content: str,
        language: Union[
            models.CreateSuggestionLanguage, models.CreateSuggestionLanguageTypedDict
        ],
        description: Optional[str] = None,
        feedback_article: Optional[
            Union[
                models.RelatedArticleForCreateUpdateDeleteSuggestion,
                models.RelatedArticleForCreateUpdateDeleteSuggestionTypedDict,
            ]
        ] = None,
        attachments: Optional[
            Union[
                models.CreateSuggestionAttachments,
                models.CreateSuggestionAttachmentsTypedDict,
            ]
        ] = None,
        custom_attributes: Optional[
            Union[List[models.CustomAttribute], List[models.CustomAttributeTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Make a Suggestion

        ## Overview
        The Make a Suggestion API allows users to create an Article Suggestion from within a knowledge portal.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a Customer, enable the setting \"Allow Customer Access\" for the portal.
        * If you want to add an attachment to a Suggestion, first call the Generate Signed URL to Upload API to add an attachment using the provided returned altID in attachment request.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param name: The name of the Suggestion.
        :param content: The content of the Suggestion.
        :param language: The knowledge base language in which the Suggestion is created.
        :param description: The description of the Suggestion.
        :param feedback_article: The Article that the Suggestion was created for.
        :param attachments: Details of Attachments for the Suggestion.
        :param custom_attributes: The Custom Attributes of the Suggestion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MakeSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_suggestion=models.CreateSuggestion(
                name=name,
                description=description,
                content=content,
                feedback_article=utils.get_pydantic_model(
                    feedback_article,
                    Optional[models.RelatedArticleForCreateUpdateDeleteSuggestion],
                ),
                attachments=utils.get_pydantic_model(
                    attachments, Optional[models.CreateSuggestionAttachments]
                ),
                language=utils.get_pydantic_model(
                    language, models.CreateSuggestionLanguage
                ),
                custom_attributes=utils.get_pydantic_model(
                    custom_attributes, Optional[List[models.CustomAttribute]]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_suggestion,
                False,
                True,
                "json",
                Optional[models.CreateSuggestion],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="makeSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def make_suggestion_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        name: str,
        content: str,
        language: Union[
            models.CreateSuggestionLanguage, models.CreateSuggestionLanguageTypedDict
        ],
        description: Optional[str] = None,
        feedback_article: Optional[
            Union[
                models.RelatedArticleForCreateUpdateDeleteSuggestion,
                models.RelatedArticleForCreateUpdateDeleteSuggestionTypedDict,
            ]
        ] = None,
        attachments: Optional[
            Union[
                models.CreateSuggestionAttachments,
                models.CreateSuggestionAttachmentsTypedDict,
            ]
        ] = None,
        custom_attributes: Optional[
            Union[List[models.CustomAttribute], List[models.CustomAttributeTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Make a Suggestion

        ## Overview
        The Make a Suggestion API allows users to create an Article Suggestion from within a knowledge portal.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a Customer, enable the setting \"Allow Customer Access\" for the portal.
        * If you want to add an attachment to a Suggestion, first call the Generate Signed URL to Upload API to add an attachment using the provided returned altID in attachment request.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param name: The name of the Suggestion.
        :param content: The content of the Suggestion.
        :param language: The knowledge base language in which the Suggestion is created.
        :param description: The description of the Suggestion.
        :param feedback_article: The Article that the Suggestion was created for.
        :param attachments: Details of Attachments for the Suggestion.
        :param custom_attributes: The Custom Attributes of the Suggestion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MakeSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_suggestion=models.CreateSuggestion(
                name=name,
                description=description,
                content=content,
                feedback_article=utils.get_pydantic_model(
                    feedback_article,
                    Optional[models.RelatedArticleForCreateUpdateDeleteSuggestion],
                ),
                attachments=utils.get_pydantic_model(
                    attachments, Optional[models.CreateSuggestionAttachments]
                ),
                language=utils.get_pydantic_model(
                    language, models.CreateSuggestionLanguage
                ),
                custom_attributes=utils.get_pydantic_model(
                    custom_attributes, Optional[List[models.CustomAttribute]]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_suggestion,
                False,
                True,
                "json",
                Optional[models.CreateSuggestion],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="makeSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def modify_suggestions(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        id: str,
        modified_date: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        content: Optional[str] = None,
        attachments: Optional[
            Union[
                models.ModifySuggestionAttachments,
                models.ModifySuggestionAttachmentsTypedDict,
            ]
        ] = None,
        custom_attributes: Optional[
            Union[List[models.CustomAttribute], List[models.CustomAttributeTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Modify Suggestion

        ## Overview
        The Modify Suggestion API allows authenticated users to modify their own Suggestion.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a Customer, enable the setting \"Allow Customer Access\" for the portal.
        * The \"Suggestion ID\" specified in the request body must exist and belong to the user.
        * The status of this Suggestion as returned by the Get Suggestion by ID API must be \"pending\".
        * At least one of the optional request body attributes must be provided.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param id: The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param modified_date: The date on which the Suggestion was last modified.
        :param name: The name of the Suggestion.
        :param description: The description of the Suggestion.
        :param content: The content of the Suggestion.
        :param attachments: Details of Attachments for the Suggestion.
        :param custom_attributes: Custom Attributes of the Suggestion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ModifySuggestionsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            modify_suggestion=models.ModifySuggestion(
                id=id,
                name=name,
                description=description,
                content=content,
                modified_date=modified_date,
                attachments=utils.get_pydantic_model(
                    attachments, Optional[models.ModifySuggestionAttachments]
                ),
                custom_attributes=utils.get_pydantic_model(
                    custom_attributes, Optional[List[models.CustomAttribute]]
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.modify_suggestion,
                False,
                True,
                "json",
                Optional[models.ModifySuggestion],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="modifySuggestions",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def modify_suggestions_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        id: str,
        modified_date: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        content: Optional[str] = None,
        attachments: Optional[
            Union[
                models.ModifySuggestionAttachments,
                models.ModifySuggestionAttachmentsTypedDict,
            ]
        ] = None,
        custom_attributes: Optional[
            Union[List[models.CustomAttribute], List[models.CustomAttributeTypedDict]]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Modify Suggestion

        ## Overview
        The Modify Suggestion API allows authenticated users to modify their own Suggestion.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a Customer, enable the setting \"Allow Customer Access\" for the portal.
        * The \"Suggestion ID\" specified in the request body must exist and belong to the user.
        * The status of this Suggestion as returned by the Get Suggestion by ID API must be \"pending\".
        * At least one of the optional request body attributes must be provided.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param id: The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param modified_date: The date on which the Suggestion was last modified.
        :param name: The name of the Suggestion.
        :param description: The description of the Suggestion.
        :param content: The content of the Suggestion.
        :param attachments: Details of Attachments for the Suggestion.
        :param custom_attributes: Custom Attributes of the Suggestion.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ModifySuggestionsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            modify_suggestion=models.ModifySuggestion(
                id=id,
                name=name,
                description=description,
                content=content,
                modified_date=modified_date,
                attachments=utils.get_pydantic_model(
                    attachments, Optional[models.ModifySuggestionAttachments]
                ),
                custom_attributes=utils.get_pydantic_model(
                    custom_attributes, Optional[List[models.CustomAttribute]]
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.modify_suggestion,
                False,
                True,
                "json",
                Optional[models.ModifySuggestion],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="modifySuggestions",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def search_suggestion(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        filter_status: models.FilterStatus,
        sort: Optional[models.SortIDName] = None,
        order: Optional[models.Order] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 25,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Suggestions]:
        r"""Get Suggestion by Status

        ## Overview
        The Get Suggestion by Status API allows authenticated users to retrieve their own suggestions based on Suggestion status.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_status: The search filter applied to the list of suggestions by a user.
        :param sort: Objects returned in server response are sorted based on the attribute supplied under $sort.
        :param order: Common query parameter $order.
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            filter_status=filter_status,
            sort=sort,
            order=order,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="searchSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Suggestions, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def search_suggestion_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        filter_status: models.FilterStatus,
        sort: Optional[models.SortIDName] = None,
        order: Optional[models.Order] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 25,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Suggestions]:
        r"""Get Suggestion by Status

        ## Overview
        The Get Suggestion by Status API allows authenticated users to retrieve their own suggestions based on Suggestion status.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_status: The search filter applied to the list of suggestions by a user.
        :param sort: Objects returned in server response are sorted based on the attribute supplied under $sort.
        :param order: Common query parameter $order.
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            filter_status=filter_status,
            sort=sort,
            order=order,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="searchSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Suggestions, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_suggestion(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        suggestion_additional_attributes: Optional[
            List[models.SuggestionAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Suggestion]:
        r"""Get Suggestion by ID

        ## Overview
        The Get Suggestion by ID API allows authenticated users to retrieve their own suggestions.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The \"Suggestion for the ID\" specified in the URL must belong to the user.



        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_additional_attributes: The attributes of a Suggestion to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These Suggestion attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Suggestion. | name  | The name of the Suggestion. | status | The status of the Suggestion. | description | The description of the Suggestion. | language | Details about the language of the Suggestion. | modifiedBy.id | The ID of the user that last modified the Suggestion.  | modifiedBy.firstName | The Suggestion's last modified user's first name. | modifiedBy.middleName | The Suggestion's last modified user's middle name. | modifiedBy.lastName | The Suggestion's last modified user's last name. | modifiedDate | The Suggestion's last modified date <u>and</u> information about the user that last modified the Suggestion. | link | The link object, used to retrieve the details of the Suggestion. | hasComments | The Suggestion has one or more comments | hasAttachments | The Suggestion has one or more attachments | hasRelatedArticles | The Suggestion has related articles
        :param custom_additional_attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
            suggestion_additional_attributes=suggestion_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Suggestion, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_suggestion_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        suggestion_additional_attributes: Optional[
            List[models.SuggestionAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Suggestion]:
        r"""Get Suggestion by ID

        ## Overview
        The Get Suggestion by ID API allows authenticated users to retrieve their own suggestions.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The \"Suggestion for the ID\" specified in the URL must belong to the user.



        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_additional_attributes: The attributes of a Suggestion to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These Suggestion attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Suggestion. | name  | The name of the Suggestion. | status | The status of the Suggestion. | description | The description of the Suggestion. | language | Details about the language of the Suggestion. | modifiedBy.id | The ID of the user that last modified the Suggestion.  | modifiedBy.firstName | The Suggestion's last modified user's first name. | modifiedBy.middleName | The Suggestion's last modified user's middle name. | modifiedBy.lastName | The Suggestion's last modified user's last name. | modifiedDate | The Suggestion's last modified date <u>and</u> information about the user that last modified the Suggestion. | link | The link object, used to retrieve the details of the Suggestion. | hasComments | The Suggestion has one or more comments | hasAttachments | The Suggestion has one or more attachments | hasRelatedArticles | The Suggestion has related articles
        :param custom_additional_attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
            suggestion_additional_attributes=suggestion_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Suggestion, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def delete_suggestion(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Suggestion

        ## Overview
        The Delete a Suggestion API allows authenticated users to delete their own Suggestion.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion must belong to the user.
        * The status of the Suggestion must not be \"approved\".


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/portals/{portalID}/suggestions/{suggestionID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["400", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def delete_suggestion_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a Suggestion

        ## Overview
        The Delete a Suggestion API allows authenticated users to delete their own Suggestion.

        ## Prerequisites
        * Enable the setting \"Manage a Suggestion\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion must belong to the user.
        * The status of the Suggestion must not be \"approved\".


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteSuggestionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/portals/{portalID}/suggestions/{suggestionID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["400", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_related_articles_for_suggestion(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.FeedbackArticleForSuggestion]:
        r"""Get Related Articles for Suggestion

        ## Overview
        The Get Related Articles for Suggestion API allows authenticated users to retrieve related articles for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRelatedArticlesForSuggestionRequest(
            accept_language=accept_language,
            article_result_additional_attributes=article_result_additional_attributes,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/relatedArticles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRelatedArticlesForSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.FeedbackArticleForSuggestion, http_res
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_related_articles_for_suggestion_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.FeedbackArticleForSuggestion]:
        r"""Get Related Articles for Suggestion

        ## Overview
        The Get Related Articles for Suggestion API allows authenticated users to retrieve related articles for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRelatedArticlesForSuggestionRequest(
            accept_language=accept_language,
            article_result_additional_attributes=article_result_additional_attributes,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/relatedArticles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRelatedArticlesForSuggestion",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.FeedbackArticleForSuggestion, http_res
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_suggestion_comments(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Comments]:
        r"""Get Suggestion Comments

        ## Overview
        The Get Suggestion Comments API allows authenticated users to retrieve all comments for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionCommentsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/comments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionComments",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Comments, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_suggestion_comments_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Comments]:
        r"""Get Suggestion Comments

        ## Overview
        The Get Suggestion Comments API allows authenticated users to retrieve all comments for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL.
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionCommentsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/comments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionComments",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Comments, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_suggestion_attachments(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Attachments]:
        r"""Get Suggestion Attachments

        ## Overview
        The Get Suggestion Attachments API allows authenticated users to retrieve attachments for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionAttachmentsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/attachments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionAttachments",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Attachments, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_suggestion_attachments_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        suggestion_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Attachments]:
        r"""Get Suggestion Attachments

        ## Overview
        The Get Suggestion Attachments API allows authenticated users to retrieve attachments for a Suggestion.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param suggestion_id: The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionAttachmentsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            suggestion_id=suggestion_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions/{suggestionID}/attachments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionAttachments",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Attachments, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_suggestion_attachment_by_id(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        attachment_id: str,
        attachment_additional_attributes: Optional[
            List[models.AttachmentAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.SuggestionAttachment]:
        r"""Get Suggestion Attachment by ID

        ## Overview
        The Get Suggestion Attachment by ID API allows authenticated users to get the details of an attachment that belongs to their own Suggestion. It also allows the download of attachment content.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_additional_attributes: The attributes of an attachment to be returned, along with the default attachment details.  | Attribute    | Description                        | |--------------|------------------------------------| | id         | Unique identifier for the attachment | | fileName   | Name of the file                   | | contentType| Content type of the file              | | size       | Size of the file in bytes          | | link       | Link to the attachment             |
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionAttachmentByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            attachment_id=attachment_id,
            attachment_additional_attributes=attachment_additional_attributes,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/suggestions/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionAttachmentById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SuggestionAttachment, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_suggestion_attachment_by_id_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        attachment_id: str,
        attachment_additional_attributes: Optional[
            List[models.AttachmentAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.SuggestionAttachment]:
        r"""Get Suggestion Attachment by ID

        ## Overview
        The Get Suggestion Attachment by ID API allows authenticated users to get the details of an attachment that belongs to their own Suggestion. It also allows the download of attachment content.

        ## Prerequisites
        * Enable the setting \"My Suggestions\" for the portal specified in the URL
        * If the user is a customer, enable the setting \"Allow Customer Access\" for the portal.
        * The Suggestion specified in the URL must belong to the user.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_additional_attributes: The attributes of an attachment to be returned, along with the default attachment details.  | Attribute    | Description                        | |--------------|------------------------------------| | id         | Unique identifier for the attachment | | fileName   | Name of the file                   | | contentType| Content type of the file              | | size       | Size of the file in bytes          | | link       | Link to the attachment             |
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSuggestionAttachmentByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            attachment_id=attachment_id,
            attachment_additional_attributes=attachment_additional_attributes,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/suggestions/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getSuggestionAttachmentById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SuggestionAttachment, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
