"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createdby import CreatedBy, CreatedByTypedDict
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Any, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TopicTypedDict(TypedDict):
    r"""This schema contains general information about the topic."""

    id: str
    r"""The alphanumeric ID of the topic.<br><br>A topic ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""
    name: Any
    r"""The name of the topic."""
    description: NotRequired[str]
    r"""A description of the topic."""
    article_count_in_topic: NotRequired[int]
    r"""Number of articles in this topic."""
    article_count_in_topic_tree: NotRequired[int]
    r"""Number of articles in this topic and all sub-topics."""
    created_by: NotRequired[CreatedByTypedDict]
    created_date: NotRequired[str]
    department_id: NotRequired[str]
    r"""ID of the topic's department."""
    image_url: NotRequired[str]
    r"""The URL of an image to be associated with the topic."""
    modified_by: NotRequired[ModifiedByTypedDict]
    modified_date: NotRequired[str]
    r"""The date on which the topic was last modified."""
    child_count: NotRequired[int]
    r"""Number of sub-topics below this topic."""
    sub_topic_ids: NotRequired[List[str]]
    r"""Array with the list of sub-topics. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    parent_topic_id: NotRequired[str]
    r"""ID of the parent topic. -1 if it is the root topic. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""Custom attributes for the Topic."""
    topic_home_article_id: NotRequired[str]
    r"""The ID of the article used as the home page of this topic. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class Topic(BaseModel):
    r"""This schema contains general information about the topic."""

    id: str
    r"""The alphanumeric ID of the topic.<br><br>A topic ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""

    name: Any
    r"""The name of the topic."""

    description: Optional[str] = None
    r"""A description of the topic."""

    article_count_in_topic: Annotated[
        Optional[int], pydantic.Field(alias="articleCountInTopic")
    ] = None
    r"""Number of articles in this topic."""

    article_count_in_topic_tree: Annotated[
        Optional[int], pydantic.Field(alias="articleCountInTopicTree")
    ] = None
    r"""Number of articles in this topic and all sub-topics."""

    created_by: Annotated[Optional[CreatedBy], pydantic.Field(alias="createdBy")] = None

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None

    department_id: Annotated[Optional[str], pydantic.Field(alias="departmentId")] = None
    r"""ID of the topic's department."""

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""The URL of an image to be associated with the topic."""

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the topic was last modified."""

    child_count: Annotated[Optional[int], pydantic.Field(alias="childCount")] = None
    r"""Number of sub-topics below this topic."""

    sub_topic_ids: Annotated[
        Optional[List[str]], pydantic.Field(alias="subTopicIds")
    ] = None
    r"""Array with the list of sub-topics. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    parent_topic_id: Annotated[Optional[str], pydantic.Field(alias="parentTopicId")] = (
        None
    )
    r"""ID of the parent topic. -1 if it is the root topic. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""Custom attributes for the Topic."""

    topic_home_article_id: Annotated[
        Optional[str], pydantic.Field(alias="topicHomeArticleId")
    ] = None
    r"""The ID of the article used as the home page of this topic. <br><br>Valid IDs are composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
