"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .referenceresponse import ReferenceResponse, ReferenceResponseTypedDict
from .searchresult import SearchResult, SearchResultTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AnswersResponseAnswerType = Literal[
    "certified",
    "generative",
]
r"""Indicates whether the answer was extracted directly from documents or generated by the LLM."""


class AnswersResponseAnswerTypedDict(TypedDict):
    answer_value: str
    r"""The main response text. May be a certified answer or a generative answer produced by the LLM."""
    references: List[ReferenceResponseTypedDict]
    r"""Supporting sources that were used to produce the answer."""
    answer_type: AnswersResponseAnswerType
    r"""Indicates whether the answer was extracted directly from documents or generated by the LLM."""
    relevance_score: float
    r"""Confidence score (0.0-1.0) reflecting how well the answer matches the query."""


class AnswersResponseAnswer(BaseModel):
    answer_value: Annotated[str, pydantic.Field(alias="answerValue")]
    r"""The main response text. May be a certified answer or a generative answer produced by the LLM."""

    references: List[ReferenceResponse]
    r"""Supporting sources that were used to produce the answer."""

    answer_type: Annotated[
        AnswersResponseAnswerType, pydantic.Field(alias="answerType")
    ]
    r"""Indicates whether the answer was extracted directly from documents or generated by the LLM."""

    relevance_score: Annotated[float, pydantic.Field(alias="relevanceScore")]
    r"""Confidence score (0.0-1.0) reflecting how well the answer matches the query."""


AnswersResponseType = Literal[
    "portal",
    "custom",
]
r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""


class AnswersResponseChannelTypedDict(TypedDict):
    type: AnswersResponseType
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""
    name: NotRequired[str]
    r"""The channel name."""


class AnswersResponseChannel(BaseModel):
    type: AnswersResponseType
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""

    name: Optional[str] = None
    r"""The channel name."""


class AnswersResponseTypedDict(TypedDict):
    answer: AnswersResponseAnswerTypedDict
    search_results: List[SearchResultTypedDict]
    r"""List of top search results used to support the answer. Includes snippets, metadata, and relevance scores."""
    session_id: str
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""
    channel: NotRequired[AnswersResponseChannelTypedDict]
    event_id: NotRequired[str]
    r"""Unique ID for this specific API call or event."""


class AnswersResponse(BaseModel):
    answer: AnswersResponseAnswer

    search_results: Annotated[List[SearchResult], pydantic.Field(alias="searchResults")]
    r"""List of top search results used to support the answer. Includes snippets, metadata, and relevance scores."""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""

    channel: Optional[AnswersResponseChannel] = None

    event_id: Annotated[Optional[str], pydantic.Field(alias="eventId")] = None
    r"""Unique ID for this specific API call or event."""
