"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional


class PortalTopic(BaseSDK):
    def get_topic_breadcrumb_for_article(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TopicBreadcrumb:
        r"""Get Topic Breadcrumb for Article

        ## Overview
        * Use this API to retrieve the topic breadcrumb for an article in a portal. A breadcrumb shows the hierarchical path from the root topic to the article's primary topic.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetTopicBreadcrumbForArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/breadcrumb",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getTopicBreadcrumbForArticle",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicBreadcrumb, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_topic_breadcrumb_for_article_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TopicBreadcrumb:
        r"""Get Topic Breadcrumb for Article

        ## Overview
        * Use this API to retrieve the topic breadcrumb for an article in a portal. A breadcrumb shows the hierarchical path from the root topic to the article's primary topic.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetTopicBreadcrumbForArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/breadcrumb",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getTopicBreadcrumbForArticle",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicBreadcrumb, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def getchildtopics(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        topic_id: str,
        search_profile_id: Optional[str] = None,
        level: Optional[int] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicTreeResult]:
        r"""Get Immediate Child Topics

        ## Overview
        The Get Immediate Child Topics API retrieves details about a topic and it's immediate child topics. The <code>$level</code> attribute determines how deep the topic hierarchy should go, or how many child topics of a topic are returned in the response.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param topic_id: The ID of a topic.<br><br>A topic ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param search_profile_id: Search Profile ID
        :param level: Depth of the topic hierarchy to be returned in the response.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetchildtopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            search_profile_id=search_profile_id,
            topic_id=topic_id,
            level=level,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/topics/{topicID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getchildtopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicTreeResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def getchildtopics_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        topic_id: str,
        search_profile_id: Optional[str] = None,
        level: Optional[int] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicTreeResult]:
        r"""Get Immediate Child Topics

        ## Overview
        The Get Immediate Child Topics API retrieves details about a topic and it's immediate child topics. The <code>$level</code> attribute determines how deep the topic hierarchy should go, or how many child topics of a topic are returned in the response.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param topic_id: The ID of a topic.<br><br>A topic ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param search_profile_id: Search Profile ID
        :param level: Depth of the topic hierarchy to be returned in the response.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetchildtopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            search_profile_id=search_profile_id,
            topic_id=topic_id,
            level=level,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/topics/{topicID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getchildtopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicTreeResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def getancestortopics(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        topic_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicResult]:
        r"""Get All Ancestor Topics

        ## Overview
        The Get All Ancestor Topics API retrieves the hierarchy from the root topic down to the given topic.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param topic_id: The ID of a topic.<br><br>A topic ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetancestortopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            topic_id=topic_id,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/topics/{topicID}/parents",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getancestortopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def getancestortopics_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        topic_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicResult]:
        r"""Get All Ancestor Topics

        ## Overview
        The Get All Ancestor Topics API retrieves the hierarchy from the root topic down to the given topic.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param topic_id: The ID of a topic.<br><br>A topic ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetancestortopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            topic_id=topic_id,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/topics/{topicID}/parents",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getancestortopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def getalltopics(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        level: Optional[int] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicTreeResult]:
        r"""Get All Topics

        ## Overview
        The Get All Topics API retrieves the topic tree for a portal. The <code>$level</code> attribute determines how deep the topic hierarchy should go, or how many child topics of a topic are returned in the response.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param level: Depth of the topic hierarchy to be returned in the response.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetalltopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            level=level,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/topics",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getalltopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicTreeResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def getalltopics_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        level: Optional[int] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        topic_additional_attributes: Optional[
            List[models.TopicAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.TopicTreeResult]:
        r"""Get All Topics

        ## Overview
        The Get All Topics API retrieves the topic tree for a portal. The <code>$level</code> attribute determines how deep the topic hierarchy should go, or how many child topics of a topic are returned in the response.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param level: Depth of the topic hierarchy to be returned in the response.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param topic_additional_attributes: The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.  #### Default Attributes These topic attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the topic. | name  | The name of the topic. | articleCountInTopic | Number of articles in this topic. | articleCountInTopicTree  | Number of articles in this topic and all sub-topics. | createdBy.id | The ID of the user that created the topic.  | createdDate | The date when the topic was created. | departmentId | ID of the department for which this topic belongs to.  | topicHomeArticleId | The ID of the article used as the home page of this topic. | modifiedBy.id | The ID of the user that last modified the topic.  | modifiedDate | The date when the topic was last modified on. | childCount | Total number of children sub-topis below the current topic | subTopicIds | Array with the list of sub-topics | parentTopicId | ID of the parent topic. -1 if it is the root topic.
        :param custom_additional_attributes:
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetalltopicsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            level=level,
            language=language,
            topic_additional_attributes=topic_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/topics",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getalltopics",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TopicTreeResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
