"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from egain_api_python.errors import EgainError
from egain_api_python.models import (
    schemas_wserrorcommon as models_schemas_wserrorcommon,
)
from egain_api_python.types import BaseModel
import httpx
import pydantic
from typing import List, Optional
from typing_extensions import Annotated


class SchemasWSErrorCommonData(BaseModel):
    code: str
    r"""String that follow the pattern {integer}-{integer}.
    * The first part is http status code.  The code is unique as a whole. Nothing common between 400-101 and 404-101

    """

    developer_message: Annotated[str, pydantic.Field(alias="developerMessage")]
    r"""Response explaining what happened"""

    details: Optional[List[models_schemas_wserrorcommon.SchemasWSErrorCommonDetail]] = (
        None
    )

    user_message: Annotated[Optional[str], pydantic.Field(alias="userMessage")] = None
    r"""UI friendly message only supported by some API.
    * Client must request explicitly by passing X-egain-error-message=yes header

    """


@dataclass(unsafe_hash=True)
class SchemasWSErrorCommon(EgainError):
    r"""Preconditions failed"""

    data: SchemasWSErrorCommonData = field(hash=False)

    def __init__(
        self,
        data: SchemasWSErrorCommonData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
