"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional


class Health(BaseSDK):
    def get_health(
        self,
        *,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetHealthResponse:
        r"""Check service health status

        # Service Health Check

        ## Overview
        This API provides comprehensive health status information for the Import Content service. It's designed for infrastructure monitoring, load balancer health checks, and operational monitoring to ensure service availability and performance.

        ## Health Check Features
        - **Service Status**: Overall service health (healthy/unhealthy)
        - **Version Information**: Current API version and build details

        ## Monitoring Use Cases
        - **Load Balancers**: Automatic health checks for traffic routing
        - **Alerting Systems**: Automated notifications for service issues

        ## Health Status Values
        - **Healthy**: Service is operating normally
        - **Unhealthy**: Service is experiencing critical issues
        - **Maintenance**: Service is under planned maintenance

        ## Response Components
        - **Status**: Current health state
        - **Timestamp**: When health check was performed
        - **Version**: API version information
        - **Uptime**: Service uptime since last restart

        ## Monitoring Best Practices
        - **Check Frequency**: Monitor every 1-2 minutes for production
        - **Response Time**: Track health check response times

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | System |<ul><li>No authentication required for basic health checks.</li><li>This endpoint is designed for infrastructure monitoring.</li><li>Rate limiting applies to prevent abuse.</li></ul>|


        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_HEALTH_OP_SERVERS[0]
        req = self._build_request(
            method="GET",
            path="/import/content/health",
            base_url=base_url,
            url_variables=url_variables,
            request=None,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getHealth",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetHealthResponse, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_health_async(
        self,
        *,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetHealthResponse:
        r"""Check service health status

        # Service Health Check

        ## Overview
        This API provides comprehensive health status information for the Import Content service. It's designed for infrastructure monitoring, load balancer health checks, and operational monitoring to ensure service availability and performance.

        ## Health Check Features
        - **Service Status**: Overall service health (healthy/unhealthy)
        - **Version Information**: Current API version and build details

        ## Monitoring Use Cases
        - **Load Balancers**: Automatic health checks for traffic routing
        - **Alerting Systems**: Automated notifications for service issues

        ## Health Status Values
        - **Healthy**: Service is operating normally
        - **Unhealthy**: Service is experiencing critical issues
        - **Maintenance**: Service is under planned maintenance

        ## Response Components
        - **Status**: Current health state
        - **Timestamp**: When health check was performed
        - **Version**: API version information
        - **Uptime**: Service uptime since last restart

        ## Monitoring Best Practices
        - **Check Frequency**: Monitor every 1-2 minutes for production
        - **Response Time**: Track health check response times

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | System |<ul><li>No authentication required for basic health checks.</li><li>This endpoint is designed for infrastructure monitoring.</li><li>Rate limiting applies to prevent abuse.</li></ul>|


        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_HEALTH_OP_SERVERS[0]
        req = self._build_request_async(
            method="GET",
            path="/import/content/health",
            base_url=base_url,
            url_variables=url_variables,
            request=None,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getHealth",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.GetHealthResponse, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
