"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BookmarkTypedDict(TypedDict):
    resource_id: str
    r"""The ID of the article or topic associated with this bookmark. A case ID or an article ID is composed of a 2-4 letter prefix, followed by a dash and 15 digits."""
    portal_id: NotRequired[str]
    r"""The ID of the portal associated with the bookmark.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 2-4 15 digits."""
    id: NotRequired[str]
    r"""The ID of the bookmark."""
    bookmark_name: NotRequired[str]
    r"""The name of the bookmark."""
    resource_type: NotRequired[int]
    r"""Determines the type of resource:
    <li>1 - Article</li>
    <li>2 - Topic</li>
    <li>3 - External Content</li>
    """
    resource_name: NotRequired[str]
    r"""The name of the resource associated with the bookmark.<br><br>This attribute is only available for article and topic bookmarks."""
    external_content_id: NotRequired[str]
    r"""The ID of the external content.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"3 - External Content\"."""


class Bookmark(BaseModel):
    resource_id: Annotated[str, pydantic.Field(alias="resourceId")]
    r"""The ID of the article or topic associated with this bookmark. A case ID or an article ID is composed of a 2-4 letter prefix, followed by a dash and 15 digits."""

    portal_id: Annotated[Optional[str], pydantic.Field(alias="portalId")] = None
    r"""The ID of the portal associated with the bookmark.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 2-4 15 digits."""

    id: Optional[str] = None
    r"""The ID of the bookmark."""

    bookmark_name: Annotated[Optional[str], pydantic.Field(alias="bookmarkName")] = None
    r"""The name of the bookmark."""

    resource_type: Annotated[Optional[int], pydantic.Field(alias="resourceType")] = None
    r"""Determines the type of resource:
    <li>1 - Article</li>
    <li>2 - Topic</li>
    <li>3 - External Content</li>
    """

    resource_name: Annotated[Optional[str], pydantic.Field(alias="resourceName")] = None
    r"""The name of the resource associated with the bookmark.<br><br>This attribute is only available for article and topic bookmarks."""

    external_content_id: Annotated[
        Optional[str], pydantic.Field(alias="externalContentId")
    ] = None
    r"""The ID of the external content.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"3 - External Content\"."""
