"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .email import Email, EmailTypedDict
from .phone import Phone, PhoneTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ContactPersonTypedDict(TypedDict):
    r"""ContactPerson"""

    first_name: str
    r"""First name of the customer"""
    email: List[EmailTypedDict]
    r"""Email details"""
    middle_name: NotRequired[str]
    r"""Middle name of the customer"""
    last_name: NotRequired[str]
    r"""Last name of the customer"""
    phone: NotRequired[List[PhoneTypedDict]]
    r"""Phone details"""


class ContactPerson(BaseModel):
    r"""ContactPerson"""

    first_name: Annotated[str, pydantic.Field(alias="firstName")]
    r"""First name of the customer"""

    email: List[Email]
    r"""Email details"""

    middle_name: Annotated[Optional[str], pydantic.Field(alias="middleName")] = None
    r"""Middle name of the customer"""

    last_name: Annotated[Optional[str], pydantic.Field(alias="lastName")] = None
    r"""Last name of the customer"""

    phone: Optional[List[Phone]] = None
    r"""Phone details"""
