"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Any, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GET_HEALTH_OP_SERVERS = [
    # Production Server
    "https://api.aidev.egain.cloud/knowledge/contentmgr/v4",
]


ServiceUnavailableStatus = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""**Health Status**

The overall health status of the service. Possible values:
- **healthy**: Service is operating normally
- **degraded**: Service is functional but with performance issues
- **unhealthy**: Service is experiencing critical issues
- **maintenance**: Service is under planned maintenance

"""


Database = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""Health status of database component."""


FileSystem = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""Health status of file system component."""


ExternalServices = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""Health status of external services components."""


ProcessingEngine = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""Health status of processing engine component."""


Storage = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""Health status of storage component."""


class ComponentsTypedDict(TypedDict):
    r"""**Comonents**:

    Health status of import service componenets

    """

    database: NotRequired[Database]
    r"""Health status of database component."""
    file_system: NotRequired[FileSystem]
    r"""Health status of file system component."""
    external_services: NotRequired[ExternalServices]
    r"""Health status of external services components."""
    processing_engine: NotRequired[ProcessingEngine]
    r"""Health status of processing engine component."""
    storage: NotRequired[Storage]
    r"""Health status of storage component."""


class Components(BaseModel):
    r"""**Comonents**:

    Health status of import service componenets

    """

    database: Optional[Database] = None
    r"""Health status of database component."""

    file_system: Annotated[Optional[FileSystem], pydantic.Field(alias="fileSystem")] = (
        None
    )
    r"""Health status of file system component."""

    external_services: Annotated[
        Optional[ExternalServices], pydantic.Field(alias="externalServices")
    ] = None
    r"""Health status of external services components."""

    processing_engine: Annotated[
        Optional[ProcessingEngine], pydantic.Field(alias="processingEngine")
    ] = None
    r"""Health status of processing engine component."""

    storage: Optional[Storage] = None
    r"""Health status of storage component."""


GetHealthStatus = Literal[
    "healthy",
    "degraded",
    "unhealthy",
    "maintenance",
]
r"""**Health Status**

The overall health status of the service. Possible values:
- **healthy**: Service is operating normally
- **degraded**: Service is functional but with performance issues
- **unhealthy**: Service is experiencing critical issues
- **maintenance**: Service is under planned maintenance

"""


class GetHealthResponseTypedDict(TypedDict):
    r"""## Service is Healthy

    The Import Content service is operating normally with all components functioning as expected.

    **Health Status Details:**
    - **Overall Status**: Service is healthy and ready to process requests

    **Response Information:**
    - **Status**: Current health state (healthy, degraded, unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version

    """

    status: NotRequired[GetHealthStatus]
    r"""**Health Status**

    The overall health status of the service. Possible values:
    - **healthy**: Service is operating normally
    - **degraded**: Service is functional but with performance issues
    - **unhealthy**: Service is experiencing critical issues
    - **maintenance**: Service is under planned maintenance

    """
    timestamp: NotRequired[Any]
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This is useful for:
    - Tracking health check frequency
    - Correlating with other system events
    - Monitoring health check response times
    - Historical health trend analysis

    """
    version: NotRequired[str]
    r"""**API Version**

    The current version of the Import Content API. This helps with:
    - Version compatibility checking
    - Feature availability verification
    - Upgrade planning and coordination
    - Support and troubleshooting

    """
    uptime: NotRequired[str]
    r"""**Service Uptime**

    The total time the service has been running since the last restart. This metric is useful for:
    - Service stability monitoring
    - Maintenance scheduling
    - Performance trend analysis
    - Reliability assessment

    """


class GetHealthResponse(BaseModel):
    r"""## Service is Healthy

    The Import Content service is operating normally with all components functioning as expected.

    **Health Status Details:**
    - **Overall Status**: Service is healthy and ready to process requests

    **Response Information:**
    - **Status**: Current health state (healthy, degraded, unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version

    """

    status: Optional[GetHealthStatus] = None
    r"""**Health Status**

    The overall health status of the service. Possible values:
    - **healthy**: Service is operating normally
    - **degraded**: Service is functional but with performance issues
    - **unhealthy**: Service is experiencing critical issues
    - **maintenance**: Service is under planned maintenance

    """

    timestamp: Optional[Any] = None
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This is useful for:
    - Tracking health check frequency
    - Correlating with other system events
    - Monitoring health check response times
    - Historical health trend analysis

    """

    version: Optional[str] = None
    r"""**API Version**

    The current version of the Import Content API. This helps with:
    - Version compatibility checking
    - Feature availability verification
    - Upgrade planning and coordination
    - Support and troubleshooting

    """

    uptime: Optional[str] = None
    r"""**Service Uptime**

    The total time the service has been running since the last restart. This metric is useful for:
    - Service stability monitoring
    - Maintenance scheduling
    - Performance trend analysis
    - Reliability assessment

    """
