"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .mandatorylanguagequeryparameter import MandatoryLanguageQueryParameter
from .order import Order
from .sortidnamedepartment import SortIDNameDepartment
from egain_api_python.types import BaseModel
from egain_api_python.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMyPortalsRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    language: MandatoryLanguageQueryParameter
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""
    department: NotRequired[str]
    r"""The Name of the department for which portals are to be fetched"""
    filter_text: NotRequired[str]
    r"""Portal name starting with a specific character are considered to filter the result."""
    short_url_template: NotRequired[str]
    r"""The Name of the template used while creating Short URL."""
    sort: NotRequired[SortIDNameDepartment]
    r"""Objects returned in server response are sorted based on the attribute supplied under $sort. <br>_Default value_: name."""
    order: NotRequired[Order]
    r"""Common query parameter $order."""
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""


class GetMyPortalsRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    language: Annotated[
        MandatoryLanguageQueryParameter,
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""

    department: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The Name of the department for which portals are to be fetched"""

    filter_text: Annotated[
        Optional[str],
        pydantic.Field(alias="filterText"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Portal name starting with a specific character are considered to filter the result."""

    short_url_template: Annotated[
        Optional[str],
        pydantic.Field(alias="shortUrlTemplate"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The Name of the template used while creating Short URL."""

    sort: Annotated[
        Optional[SortIDNameDepartment],
        pydantic.Field(alias="$sort"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Objects returned in server response are sorted based on the attribute supplied under $sort. <br>_Default value_: name."""

    order: Annotated[
        Optional[Order],
        pydantic.Field(alias="$order"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Common query parameter $order."""

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 25
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""
