"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .attachmentadditionalattributes import AttachmentAdditionalAttributes
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSuggestionAttachmentByIDRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    attachment_id: str
    r"""The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    attachment_additional_attributes: NotRequired[List[AttachmentAdditionalAttributes]]
    r"""The attributes of an attachment to be returned, along with the default attachment details.

    | Attribute    | Description                        |
    |--------------|------------------------------------|
    | id         | Unique identifier for the attachment |
    | fileName   | Name of the file                   |
    | contentType| Content type of the file              |
    | size       | Size of the file in bytes          |
    | link       | Link to the attachment             |

    """


class GetSuggestionAttachmentByIDRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    attachment_id: Annotated[
        str,
        pydantic.Field(alias="attachmentID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    attachment_additional_attributes: Annotated[
        Optional[List[AttachmentAdditionalAttributes]],
        pydantic.Field(alias="attachmentAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The attributes of an attachment to be returned, along with the default attachment details.

    | Attribute    | Description                        |
    |--------------|------------------------------------|
    | id         | Unique identifier for the attachment |
    | fileName   | Name of the file                   |
    | contentType| Content type of the file              |
    | size       | Size of the file in bytes          |
    | link       | Link to the attachment             |

    """
