"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .answerrange import AnswerRange, AnswerRangeTypedDict
from .metadata import Metadata, MetadataTypedDict
from .schemas_answer import SchemasAnswer, SchemasAnswerTypedDict
from .schemas_customattribute import (
    SchemasCustomAttribute,
    SchemasCustomAttributeTypedDict,
)
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


QuestionType = Literal[
    "numeric",
    "enumerated",
    "list",
    "text",
]
r"""type of the question"""


QuestionFormat = Literal[
    "radioButton",
    "dropdown",
    "checkbox",
    "mutliSelect",
    "number",
    "singleLineTextField",
    "multiLineTextField",
]
r"""format of the question"""


class QuestionTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The numerical ID of the question"""
    title: NotRequired[str]
    r"""Title of the question"""
    type: NotRequired[QuestionType]
    r"""type of the question"""
    format_: NotRequired[QuestionFormat]
    r"""format of the question"""
    short_name: NotRequired[str]
    r"""short name"""
    has_additional_info: NotRequired[bool]
    r"""indicates if question has additional information"""
    has_action: NotRequired[bool]
    r"""indicates if question has action"""
    valid_answer: NotRequired[List[SchemasAnswerTypedDict]]
    r"""valid answers for question"""
    valid_answer_range: NotRequired[AnswerRangeTypedDict]
    metadata: NotRequired[List[MetadataTypedDict]]
    r"""Metadata on question"""
    custom_attributes: NotRequired[List[SchemasCustomAttributeTypedDict]]
    r"""Custom attributes of question"""


class Question(BaseModel):
    id: Optional[str] = None
    r"""The numerical ID of the question"""

    title: Optional[str] = None
    r"""Title of the question"""

    type: Optional[QuestionType] = None
    r"""type of the question"""

    format_: Annotated[Optional[QuestionFormat], pydantic.Field(alias="format")] = None
    r"""format of the question"""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""short name"""

    has_additional_info: Annotated[
        Optional[bool], pydantic.Field(alias="hasAdditionalInfo")
    ] = None
    r"""indicates if question has additional information"""

    has_action: Annotated[Optional[bool], pydantic.Field(alias="hasAction")] = None
    r"""indicates if question has action"""

    valid_answer: Annotated[
        Optional[List[SchemasAnswer]], pydantic.Field(alias="validAnswer")
    ] = None
    r"""valid answers for question"""

    valid_answer_range: Annotated[
        Optional[AnswerRange], pydantic.Field(alias="validAnswerRange")
    ] = None

    metadata: Optional[List[Metadata]] = None
    r"""Metadata on question"""

    custom_attributes: Annotated[
        Optional[List[SchemasCustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""Custom attributes of question"""
