"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from egain_api_python.errors import EgainError
from egain_api_python.models import gethealthop as models_gethealthop
from egain_api_python.types import BaseModel
import httpx
from typing import Any, List, Optional


class ServiceUnavailableErrorData(BaseModel):
    status: Optional[models_gethealthop.ServiceUnavailableStatus] = None
    r"""**Health Status**

    The overall health status of the service. Possible values:
    - **healthy**: Service is operating normally
    - **degraded**: Service is functional but with performance issues
    - **unhealthy**: Service is experiencing critical issues
    - **maintenance**: Service is under planned maintenance

    """

    timestamp: Optional[Any] = None
    r"""**Health Check Timestamp**

    The exact date and time when this health check was performed. This is useful for:
    - Tracking health check frequency
    - Correlating with other system events
    - Monitoring health check response times
    - Historical health trend analysis

    """

    version: Optional[str] = None
    r"""**API Version**

    The current version of the Import Content API. This helps with:
    - Version compatibility checking
    - Feature availability verification
    - Upgrade planning and coordination
    - Support and troubleshooting

    """

    issues: Optional[List[str]] = None
    r"""**Issues**:

    List of detected health problems

    """

    components: Optional[models_gethealthop.Components] = None
    r"""**Comonents**:

    Health status of import service componenets

    """


@dataclass(unsafe_hash=True)
class ServiceUnavailableError(EgainError):
    r"""## Service is Unhealthy

    The Import Content service is experiencing critical issues and may not be able to process requests properly.

    **Health Status Details:**
    - **Overall Status**: Service is unhealthy and may not function correctly

    **Response Information:**
    - **Status**: Current health state (unhealthy)
    - **Timestamp**: When health check was performed
    - **Version**: Current API version
    - **Issues**: List of detected health problems

    """

    data: ServiceUnavailableErrorData = field(hash=False)

    def __init__(
        self,
        data: ServiceUnavailableErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
