"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .languagequeryparameter import LanguageQueryParameter
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetClusterByCasebaseReleaseIDRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    casebase_release_id: str
    r"""The numerical ID of the Casebase Release for which details is to be fetched."""
    language: NotRequired[LanguageQueryParameter]
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""


class GetClusterByCasebaseReleaseIDRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    casebase_release_id: Annotated[
        str,
        pydantic.Field(alias="casebaseReleaseID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The numerical ID of the Casebase Release for which details is to be fetched."""

    language: Annotated[
        Optional[LanguageQueryParameter],
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""
