# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from elabapi_python.models.entity import Entity
from elabapi_python.models.experiment import Experiment
from elabapi_python.models.patch_experiment_request import PatchExperimentRequest
from elabapi_python.models.post_experiment_by_id_request import PostExperimentByIdRequest
from elabapi_python.models.post_experiment_request import PostExperimentRequest

from elabapi_python.api_client import ApiClient, RequestSerialized
from elabapi_python.api_response import ApiResponse
from elabapi_python.rest import RESTResponseType


class ExperimentsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_experiment(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete an experiment.

        The experiment gets soft-deleted.

        :param id: ID of the experiment (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_experiment_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_experiment_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete an experiment.

        The experiment gets soft-deleted.

        :param id: ID of the experiment (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_experiment_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_experiment_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an experiment.

        The experiment gets soft-deleted.

        :param id: ID of the experiment (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_experiment_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_experiment_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/experiments/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_experiment(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        format: Annotated[Optional[StrictStr], Field(description="Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". ")] = None,
        var_json: Annotated[Optional[StrictBool], Field(description="Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). ")] = None,
        with_title: Annotated[Optional[StrictBool], Field(description="Include the title in the QR code. Only applicable if format is qrpng. ")] = None,
        size: Annotated[Optional[StrictInt], Field(description="Specify the size of the QR code in pixels. Only applicable if format is qrpng. ")] = None,
        changelog: Annotated[Optional[StrictBool], Field(description="Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Entity:
        """Read an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param format: Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". 
        :type format: str
        :param var_json: Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). 
        :type var_json: bool
        :param with_title: Include the title in the QR code. Only applicable if format is qrpng. 
        :type with_title: bool
        :param size: Specify the size of the QR code in pixels. Only applicable if format is qrpng. 
        :type size: int
        :param changelog: Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. 
        :type changelog: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_experiment_serialize(
            id=id,
            format=format,
            var_json=var_json,
            with_title=with_title,
            size=size,
            changelog=changelog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Entity",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_experiment_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        format: Annotated[Optional[StrictStr], Field(description="Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". ")] = None,
        var_json: Annotated[Optional[StrictBool], Field(description="Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). ")] = None,
        with_title: Annotated[Optional[StrictBool], Field(description="Include the title in the QR code. Only applicable if format is qrpng. ")] = None,
        size: Annotated[Optional[StrictInt], Field(description="Specify the size of the QR code in pixels. Only applicable if format is qrpng. ")] = None,
        changelog: Annotated[Optional[StrictBool], Field(description="Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Entity]:
        """Read an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param format: Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". 
        :type format: str
        :param var_json: Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). 
        :type var_json: bool
        :param with_title: Include the title in the QR code. Only applicable if format is qrpng. 
        :type with_title: bool
        :param size: Specify the size of the QR code in pixels. Only applicable if format is qrpng. 
        :type size: int
        :param changelog: Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. 
        :type changelog: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_experiment_serialize(
            id=id,
            format=format,
            var_json=var_json,
            with_title=with_title,
            size=size,
            changelog=changelog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Entity",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_experiment_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        format: Annotated[Optional[StrictStr], Field(description="Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". ")] = None,
        var_json: Annotated[Optional[StrictBool], Field(description="Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). ")] = None,
        with_title: Annotated[Optional[StrictBool], Field(description="Include the title in the QR code. Only applicable if format is qrpng. ")] = None,
        size: Annotated[Optional[StrictInt], Field(description="Specify the size of the QR code in pixels. Only applicable if format is qrpng. ")] = None,
        changelog: Annotated[Optional[StrictBool], Field(description="Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param format: Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". 
        :type format: str
        :param var_json: Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). 
        :type var_json: bool
        :param with_title: Include the title in the QR code. Only applicable if format is qrpng. 
        :type with_title: bool
        :param size: Specify the size of the QR code in pixels. Only applicable if format is qrpng. 
        :type size: int
        :param changelog: Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. 
        :type changelog: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_experiment_serialize(
            id=id,
            format=format,
            var_json=var_json,
            with_title=with_title,
            size=size,
            changelog=changelog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Entity",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_experiment_serialize(
        self,
        id,
        format,
        var_json,
        with_title,
        size,
        changelog,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if format is not None:
            
            _query_params.append(('format', format))
            
        if var_json is not None:
            
            _query_params.append(('json', var_json))
            
        if with_title is not None:
            
            _query_params.append(('withTitle', with_title))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if changelog is not None:
            
            _query_params.append(('changelog', changelog))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/experiments/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def patch_experiment(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        patch_experiment_request: Annotated[Optional[PatchExperimentRequest], Field(description="Parameters for patching an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Experiment:
        """Modify an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param patch_experiment_request: Parameters for patching an experiment
        :type patch_experiment_request: PatchExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_experiment_serialize(
            id=id,
            patch_experiment_request=patch_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Experiment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def patch_experiment_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        patch_experiment_request: Annotated[Optional[PatchExperimentRequest], Field(description="Parameters for patching an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Experiment]:
        """Modify an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param patch_experiment_request: Parameters for patching an experiment
        :type patch_experiment_request: PatchExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_experiment_serialize(
            id=id,
            patch_experiment_request=patch_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Experiment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def patch_experiment_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="ID of the experiment")],
        patch_experiment_request: Annotated[Optional[PatchExperimentRequest], Field(description="Parameters for patching an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Modify an experiment


        :param id: ID of the experiment (required)
        :type id: int
        :param patch_experiment_request: Parameters for patching an experiment
        :type patch_experiment_request: PatchExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_experiment_serialize(
            id=id,
            patch_experiment_request=patch_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Experiment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _patch_experiment_serialize(
        self,
        id,
        patch_experiment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patch_experiment_request is not None:
            _body_params = patch_experiment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/experiments/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_experiment(
        self,
        post_experiment_request: Annotated[Optional[PostExperimentRequest], Field(description="Parameters for creating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create an experiment


        :param post_experiment_request: Parameters for creating an experiment
        :type post_experiment_request: PostExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_serialize(
            post_experiment_request=post_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_experiment_with_http_info(
        self,
        post_experiment_request: Annotated[Optional[PostExperimentRequest], Field(description="Parameters for creating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create an experiment


        :param post_experiment_request: Parameters for creating an experiment
        :type post_experiment_request: PostExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_serialize(
            post_experiment_request=post_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_experiment_without_preload_content(
        self,
        post_experiment_request: Annotated[Optional[PostExperimentRequest], Field(description="Parameters for creating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create an experiment


        :param post_experiment_request: Parameters for creating an experiment
        :type post_experiment_request: PostExperimentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_serialize(
            post_experiment_request=post_experiment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_experiment_serialize(
        self,
        post_experiment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_experiment_request is not None:
            _body_params = post_experiment_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/experiments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_experiment_by_id(
        self,
        id: Annotated[StrictInt, Field(description="The unique identifier of the experiment to duplicate.")],
        post_experiment_by_id_request: Annotated[Optional[PostExperimentByIdRequest], Field(description="Parameters for duplicating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Duplicate an experiment with its ID


        :param id: The unique identifier of the experiment to duplicate. (required)
        :type id: int
        :param post_experiment_by_id_request: Parameters for duplicating an experiment
        :type post_experiment_by_id_request: PostExperimentByIdRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_by_id_serialize(
            id=id,
            post_experiment_by_id_request=post_experiment_by_id_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_experiment_by_id_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The unique identifier of the experiment to duplicate.")],
        post_experiment_by_id_request: Annotated[Optional[PostExperimentByIdRequest], Field(description="Parameters for duplicating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Duplicate an experiment with its ID


        :param id: The unique identifier of the experiment to duplicate. (required)
        :type id: int
        :param post_experiment_by_id_request: Parameters for duplicating an experiment
        :type post_experiment_by_id_request: PostExperimentByIdRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_by_id_serialize(
            id=id,
            post_experiment_by_id_request=post_experiment_by_id_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_experiment_by_id_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The unique identifier of the experiment to duplicate.")],
        post_experiment_by_id_request: Annotated[Optional[PostExperimentByIdRequest], Field(description="Parameters for duplicating an experiment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Duplicate an experiment with its ID


        :param id: The unique identifier of the experiment to duplicate. (required)
        :type id: int
        :param post_experiment_by_id_request: Parameters for duplicating an experiment
        :type post_experiment_by_id_request: PostExperimentByIdRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_experiment_by_id_serialize(
            id=id,
            post_experiment_by_id_request=post_experiment_by_id_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_experiment_by_id_serialize(
        self,
        id,
        post_experiment_by_id_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_experiment_by_id_request is not None:
            _body_params = post_experiment_by_id_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/experiments/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read_experiments(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Search for a term in title, body or elabid. ")] = None,
        extended: Annotated[Optional[StrictStr], Field(description="Extended search (advanced query). ")] = None,
        related: Annotated[Optional[StrictInt], Field(description="Look only for entries linked to this entry id. ")] = None,
        related_origin: Annotated[Optional[StrictStr], Field(description="When using the \"related\" query parameter, select the type of the related ID (experiments or items) ")] = None,
        cat: Annotated[Optional[StrictStr], Field(description="Add a filter on the Category. Supports comma separated list of numbers, including \"null\". ")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Add a filter on the Status. Supports comma separated list of numbers, including \"null\". ")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="An array of tags for filtering results containing all of these tags. ")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit the number of results. ")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Skip a number of results. Use with limit to work the pagination. ")] = None,
        owner: Annotated[Optional[StrictStr], Field(description="Filter results by author (user id) ")] = None,
        scope: Annotated[Optional[StrictInt], Field(description="Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. ")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Change the ordering of the results. ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Change the sorting of results: ascending or descending. ")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Experiment]:
        """Read all experiments that are accessible


        :param q: Search for a term in title, body or elabid. 
        :type q: str
        :param extended: Extended search (advanced query). 
        :type extended: str
        :param related: Look only for entries linked to this entry id. 
        :type related: int
        :param related_origin: When using the \"related\" query parameter, select the type of the related ID (experiments or items) 
        :type related_origin: str
        :param cat: Add a filter on the Category. Supports comma separated list of numbers, including \"null\". 
        :type cat: str
        :param status: Add a filter on the Status. Supports comma separated list of numbers, including \"null\". 
        :type status: str
        :param tags: An array of tags for filtering results containing all of these tags. 
        :type tags: List[str]
        :param limit: Limit the number of results. 
        :type limit: int
        :param offset: Skip a number of results. Use with limit to work the pagination. 
        :type offset: int
        :param owner: Filter results by author (user id) 
        :type owner: str
        :param scope: Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. 
        :type scope: int
        :param order: Change the ordering of the results. 
        :type order: str
        :param sort: Change the sorting of results: ascending or descending. 
        :type sort: str
        :param state: Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. 
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_experiments_serialize(
            q=q,
            extended=extended,
            related=related,
            related_origin=related_origin,
            cat=cat,
            status=status,
            tags=tags,
            limit=limit,
            offset=offset,
            owner=owner,
            scope=scope,
            order=order,
            sort=sort,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Experiment]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_experiments_with_http_info(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Search for a term in title, body or elabid. ")] = None,
        extended: Annotated[Optional[StrictStr], Field(description="Extended search (advanced query). ")] = None,
        related: Annotated[Optional[StrictInt], Field(description="Look only for entries linked to this entry id. ")] = None,
        related_origin: Annotated[Optional[StrictStr], Field(description="When using the \"related\" query parameter, select the type of the related ID (experiments or items) ")] = None,
        cat: Annotated[Optional[StrictStr], Field(description="Add a filter on the Category. Supports comma separated list of numbers, including \"null\". ")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Add a filter on the Status. Supports comma separated list of numbers, including \"null\". ")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="An array of tags for filtering results containing all of these tags. ")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit the number of results. ")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Skip a number of results. Use with limit to work the pagination. ")] = None,
        owner: Annotated[Optional[StrictStr], Field(description="Filter results by author (user id) ")] = None,
        scope: Annotated[Optional[StrictInt], Field(description="Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. ")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Change the ordering of the results. ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Change the sorting of results: ascending or descending. ")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Experiment]]:
        """Read all experiments that are accessible


        :param q: Search for a term in title, body or elabid. 
        :type q: str
        :param extended: Extended search (advanced query). 
        :type extended: str
        :param related: Look only for entries linked to this entry id. 
        :type related: int
        :param related_origin: When using the \"related\" query parameter, select the type of the related ID (experiments or items) 
        :type related_origin: str
        :param cat: Add a filter on the Category. Supports comma separated list of numbers, including \"null\". 
        :type cat: str
        :param status: Add a filter on the Status. Supports comma separated list of numbers, including \"null\". 
        :type status: str
        :param tags: An array of tags for filtering results containing all of these tags. 
        :type tags: List[str]
        :param limit: Limit the number of results. 
        :type limit: int
        :param offset: Skip a number of results. Use with limit to work the pagination. 
        :type offset: int
        :param owner: Filter results by author (user id) 
        :type owner: str
        :param scope: Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. 
        :type scope: int
        :param order: Change the ordering of the results. 
        :type order: str
        :param sort: Change the sorting of results: ascending or descending. 
        :type sort: str
        :param state: Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. 
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_experiments_serialize(
            q=q,
            extended=extended,
            related=related,
            related_origin=related_origin,
            cat=cat,
            status=status,
            tags=tags,
            limit=limit,
            offset=offset,
            owner=owner,
            scope=scope,
            order=order,
            sort=sort,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Experiment]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_experiments_without_preload_content(
        self,
        q: Annotated[Optional[StrictStr], Field(description="Search for a term in title, body or elabid. ")] = None,
        extended: Annotated[Optional[StrictStr], Field(description="Extended search (advanced query). ")] = None,
        related: Annotated[Optional[StrictInt], Field(description="Look only for entries linked to this entry id. ")] = None,
        related_origin: Annotated[Optional[StrictStr], Field(description="When using the \"related\" query parameter, select the type of the related ID (experiments or items) ")] = None,
        cat: Annotated[Optional[StrictStr], Field(description="Add a filter on the Category. Supports comma separated list of numbers, including \"null\". ")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Add a filter on the Status. Supports comma separated list of numbers, including \"null\". ")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="An array of tags for filtering results containing all of these tags. ")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit the number of results. ")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Skip a number of results. Use with limit to work the pagination. ")] = None,
        owner: Annotated[Optional[StrictStr], Field(description="Filter results by author (user id) ")] = None,
        scope: Annotated[Optional[StrictInt], Field(description="Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. ")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Change the ordering of the results. ")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Change the sorting of results: ascending or descending. ")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read all experiments that are accessible


        :param q: Search for a term in title, body or elabid. 
        :type q: str
        :param extended: Extended search (advanced query). 
        :type extended: str
        :param related: Look only for entries linked to this entry id. 
        :type related: int
        :param related_origin: When using the \"related\" query parameter, select the type of the related ID (experiments or items) 
        :type related_origin: str
        :param cat: Add a filter on the Category. Supports comma separated list of numbers, including \"null\". 
        :type cat: str
        :param status: Add a filter on the Status. Supports comma separated list of numbers, including \"null\". 
        :type status: str
        :param tags: An array of tags for filtering results containing all of these tags. 
        :type tags: List[str]
        :param limit: Limit the number of results. 
        :type limit: int
        :param offset: Skip a number of results. Use with limit to work the pagination. 
        :type offset: int
        :param owner: Filter results by author (user id) 
        :type owner: str
        :param scope: Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. 
        :type scope: int
        :param order: Change the ordering of the results. 
        :type order: str
        :param sort: Change the sorting of results: ascending or descending. 
        :type sort: str
        :param state: Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. 
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_experiments_serialize(
            q=q,
            extended=extended,
            related=related,
            related_origin=related_origin,
            cat=cat,
            status=status,
            tags=tags,
            limit=limit,
            offset=offset,
            owner=owner,
            scope=scope,
            order=order,
            sort=sort,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Experiment]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_experiments_serialize(
        self,
        q,
        extended,
        related,
        related_origin,
        cat,
        status,
        tags,
        limit,
        offset,
        owner,
        scope,
        order,
        sort,
        state,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tags[]': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if q is not None:
            
            _query_params.append(('q', q))
            
        if extended is not None:
            
            _query_params.append(('extended', extended))
            
        if related is not None:
            
            _query_params.append(('related', related))
            
        if related_origin is not None:
            
            _query_params.append(('related_origin', related_origin))
            
        if cat is not None:
            
            _query_params.append(('cat', cat))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if tags is not None:
            
            _query_params.append(('tags[]', tags))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if owner is not None:
            
            _query_params.append(('owner', owner))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/experiments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


