# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CompoundCreateRequest(BaseModel):
    """
    CompoundCreateRequest
    """ # noqa: E501
    action: StrictStr
    name: Optional[StrictStr] = None
    inchi: Optional[StrictStr] = None
    inchi_key: Optional[StrictStr] = None
    smiles: Optional[StrictStr] = None
    molecular_formula: Optional[StrictStr] = None
    cas_number: Optional[StrictStr] = None
    iupac_name: Optional[StrictStr] = None
    pubchem_cid: Optional[StrictInt] = None
    is_corrosive: Optional[StrictBool] = None
    is_serious_health_hazard: Optional[StrictBool] = None
    is_explosive: Optional[StrictBool] = None
    is_flammable: Optional[StrictBool] = None
    is_gas_under_pressure: Optional[StrictBool] = None
    is_hazardous2env: Optional[StrictBool] = None
    is_hazardous2health: Optional[StrictBool] = None
    is_oxidising: Optional[StrictBool] = None
    is_toxic: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["action", "name", "inchi", "inchi_key", "smiles", "molecular_formula", "cas_number", "iupac_name", "pubchem_cid", "is_corrosive", "is_serious_health_hazard", "is_explosive", "is_flammable", "is_gas_under_pressure", "is_hazardous2env", "is_hazardous2health", "is_oxidising", "is_toxic"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['create']):
            raise ValueError("must be one of enum values ('create')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompoundCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompoundCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "name": obj.get("name"),
            "inchi": obj.get("inchi"),
            "inchi_key": obj.get("inchi_key"),
            "smiles": obj.get("smiles"),
            "molecular_formula": obj.get("molecular_formula"),
            "cas_number": obj.get("cas_number"),
            "iupac_name": obj.get("iupac_name"),
            "pubchem_cid": obj.get("pubchem_cid"),
            "is_corrosive": obj.get("is_corrosive"),
            "is_serious_health_hazard": obj.get("is_serious_health_hazard"),
            "is_explosive": obj.get("is_explosive"),
            "is_flammable": obj.get("is_flammable"),
            "is_gas_under_pressure": obj.get("is_gas_under_pressure"),
            "is_hazardous2env": obj.get("is_hazardous2env"),
            "is_hazardous2health": obj.get("is_hazardous2health"),
            "is_oxidising": obj.get("is_oxidising"),
            "is_toxic": obj.get("is_toxic")
        })
        return _obj


