# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Config(BaseModel):
    """
    Config
    """ # noqa: E501
    admins_create_users: Optional[StrictStr] = None
    admins_create_users_remote_dir: Optional[StrictStr] = None
    admin_validate: Optional[StrictStr] = None
    announcement: Optional[StrictStr] = Field(default=None, description="This text will be shown on every page, including login page.")
    anon_users: Optional[StrictStr] = None
    autologout_time: Optional[StrictStr] = None
    blox_anon: Optional[StrictStr] = None
    blox_enabled: Optional[StrictStr] = None
    cookie_validity_time: Optional[StrictInt] = None
    debug: Optional[StrictStr] = None
    email_domain: Optional[StrictStr] = None
    extauth_email: Optional[StrictStr] = None
    extauth_firstname: Optional[StrictStr] = None
    extauth_lastname: Optional[StrictStr] = None
    extauth_remote_user: Optional[StrictStr] = None
    extauth_teams: Optional[StrictStr] = None
    lang: Optional[StrictStr] = None
    ldap_base_dn: Optional[StrictStr] = None
    ldap_search_attr: Optional[StrictStr] = None
    ldap_email: Optional[StrictStr] = None
    ldap_firstname: Optional[StrictStr] = None
    ldap_host: Optional[StrictStr] = None
    ldap_lastname: Optional[StrictStr] = None
    ldap_password: Optional[StrictStr] = None
    ldap_port: Optional[StrictStr] = None
    ldap_team: Optional[StrictStr] = None
    ldap_toggle: Optional[StrictStr] = None
    ldap_use_tls: Optional[StrictStr] = None
    ldap_username: Optional[StrictStr] = None
    local_login: Optional[StrictStr] = None
    local_register: Optional[StrictStr] = None
    login_announcement: Optional[StrictStr] = Field(default=None, description="This text will only be shown on the login page.")
    login_tries: Optional[StrictStr] = None
    logout_url: Optional[StrictStr] = None
    mail_from: Optional[StrictStr] = None
    max_revisions: Optional[StrictStr] = None
    min_days_revisions: Optional[StrictStr] = None
    min_delta_revisions: Optional[StrictStr] = Field(default=None, description="Minimum number of characters changed required to trigger a revision save.")
    onboarding_email_active: Optional[StrictStr] = None
    onboarding_email_admins_body: Optional[StrictStr] = None
    onboarding_email_admins_subject: Optional[StrictStr] = None
    onboarding_email_body: Optional[StrictStr] = None
    onboarding_email_different_for_admins: Optional[StrictStr] = None
    onboarding_email_subject: Optional[StrictStr] = None
    open_science: Optional[StrictStr] = None
    open_team: Optional[StrictStr] = None
    privacy_policy: Optional[StrictStr] = None
    proxy: Optional[StrictStr] = None
    remote_dir_config: Optional[StrictStr] = None
    remote_dir_service: Optional[StrictStr] = None
    s3_bucket_name: Optional[StrictStr] = None
    s3_endpoint: Optional[StrictStr] = None
    s3_path_prefix: Optional[StrictStr] = None
    s3_region: Optional[StrictStr] = None
    s3_verify_cert: Optional[StrictStr] = None
    saml_acs_binding: Optional[StrictStr] = None
    saml_allowrepeatattributename: Optional[StrictStr] = None
    saml_authnrequestssigned: Optional[StrictStr] = None
    saml_baseurl: Optional[StrictStr] = None
    saml_debug: Optional[StrictStr] = None
    saml_entityid: Optional[StrictStr] = None
    saml_logoutrequestsigned: Optional[StrictStr] = None
    saml_logoutresponsesigned: Optional[StrictStr] = None
    saml_lowercaseurlencoding: Optional[StrictStr] = None
    saml_nameidencrypted: Optional[StrictStr] = None
    saml_nameidformat: Optional[StrictStr] = None
    saml_privatekey: Optional[StrictStr] = None
    saml_relaxdestinationvalidation: Optional[StrictStr] = None
    saml_signmetadata: Optional[StrictStr] = None
    saml_slo_binding: Optional[StrictStr] = None
    saml_strict: Optional[StrictStr] = None
    saml_sync_teams: Optional[StrictStr] = None
    saml_team_create: Optional[StrictStr] = None
    saml_team_default: Optional[StrictStr] = None
    saml_toggle: Optional[StrictStr] = None
    saml_user_default: Optional[StrictStr] = None
    saml_wantassertionsencrypted: Optional[StrictStr] = None
    saml_wantassertionssigned: Optional[StrictStr] = None
    saml_wantmessagessigned: Optional[StrictStr] = None
    saml_wantnameid: Optional[StrictStr] = None
    saml_wantnameidencrypted: Optional[StrictStr] = None
    saml_wantxmlvalidation: Optional[StrictStr] = None
    saml_x509: Optional[StrictStr] = None
    saml_x509_new: Optional[StrictStr] = None
    var_schema: Optional[StrictStr] = Field(default=None, alias="schema")
    smtp_address: Optional[StrictStr] = None
    smtp_encryption: Optional[StrictStr] = None
    smtp_password: Optional[StrictStr] = None
    smtp_port: Optional[StrictStr] = None
    smtp_username: Optional[StrictStr] = None
    support_url: Optional[StrictStr] = None
    ts_authority: Optional[StrictStr] = None
    ts_cert: Optional[StrictStr] = None
    ts_hash: Optional[StrictStr] = None
    ts_limit: Optional[StrictStr] = None
    ts_login: Optional[StrictStr] = None
    ts_password: Optional[StrictStr] = None
    ts_url: Optional[StrictStr] = None
    uploads_storage: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["admins_create_users", "admins_create_users_remote_dir", "admin_validate", "announcement", "anon_users", "autologout_time", "blox_anon", "blox_enabled", "cookie_validity_time", "debug", "email_domain", "extauth_email", "extauth_firstname", "extauth_lastname", "extauth_remote_user", "extauth_teams", "lang", "ldap_base_dn", "ldap_search_attr", "ldap_email", "ldap_firstname", "ldap_host", "ldap_lastname", "ldap_password", "ldap_port", "ldap_team", "ldap_toggle", "ldap_use_tls", "ldap_username", "local_login", "local_register", "login_announcement", "login_tries", "logout_url", "mail_from", "max_revisions", "min_days_revisions", "min_delta_revisions", "onboarding_email_active", "onboarding_email_admins_body", "onboarding_email_admins_subject", "onboarding_email_body", "onboarding_email_different_for_admins", "onboarding_email_subject", "open_science", "open_team", "privacy_policy", "proxy", "remote_dir_config", "remote_dir_service", "s3_bucket_name", "s3_endpoint", "s3_path_prefix", "s3_region", "s3_verify_cert", "saml_acs_binding", "saml_allowrepeatattributename", "saml_authnrequestssigned", "saml_baseurl", "saml_debug", "saml_entityid", "saml_logoutrequestsigned", "saml_logoutresponsesigned", "saml_lowercaseurlencoding", "saml_nameidencrypted", "saml_nameidformat", "saml_privatekey", "saml_relaxdestinationvalidation", "saml_signmetadata", "saml_slo_binding", "saml_strict", "saml_sync_teams", "saml_team_create", "saml_team_default", "saml_toggle", "saml_user_default", "saml_wantassertionsencrypted", "saml_wantassertionssigned", "saml_wantmessagessigned", "saml_wantnameid", "saml_wantnameidencrypted", "saml_wantxmlvalidation", "saml_x509", "saml_x509_new", "schema", "smtp_address", "smtp_encryption", "smtp_password", "smtp_port", "smtp_username", "support_url", "ts_authority", "ts_cert", "ts_hash", "ts_limit", "ts_login", "ts_password", "ts_url", "uploads_storage"]

    @field_validator('onboarding_email_active')
    def onboarding_email_active_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0', '1']):
            raise ValueError("must be one of enum values ('0', '1')")
        return value

    @field_validator('onboarding_email_different_for_admins')
    def onboarding_email_different_for_admins_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0', '1']):
            raise ValueError("must be one of enum values ('0', '1')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "admins_create_users": obj.get("admins_create_users"),
            "admins_create_users_remote_dir": obj.get("admins_create_users_remote_dir"),
            "admin_validate": obj.get("admin_validate"),
            "announcement": obj.get("announcement"),
            "anon_users": obj.get("anon_users"),
            "autologout_time": obj.get("autologout_time"),
            "blox_anon": obj.get("blox_anon"),
            "blox_enabled": obj.get("blox_enabled"),
            "cookie_validity_time": obj.get("cookie_validity_time"),
            "debug": obj.get("debug"),
            "email_domain": obj.get("email_domain"),
            "extauth_email": obj.get("extauth_email"),
            "extauth_firstname": obj.get("extauth_firstname"),
            "extauth_lastname": obj.get("extauth_lastname"),
            "extauth_remote_user": obj.get("extauth_remote_user"),
            "extauth_teams": obj.get("extauth_teams"),
            "lang": obj.get("lang"),
            "ldap_base_dn": obj.get("ldap_base_dn"),
            "ldap_search_attr": obj.get("ldap_search_attr"),
            "ldap_email": obj.get("ldap_email"),
            "ldap_firstname": obj.get("ldap_firstname"),
            "ldap_host": obj.get("ldap_host"),
            "ldap_lastname": obj.get("ldap_lastname"),
            "ldap_password": obj.get("ldap_password"),
            "ldap_port": obj.get("ldap_port"),
            "ldap_team": obj.get("ldap_team"),
            "ldap_toggle": obj.get("ldap_toggle"),
            "ldap_use_tls": obj.get("ldap_use_tls"),
            "ldap_username": obj.get("ldap_username"),
            "local_login": obj.get("local_login"),
            "local_register": obj.get("local_register"),
            "login_announcement": obj.get("login_announcement"),
            "login_tries": obj.get("login_tries"),
            "logout_url": obj.get("logout_url"),
            "mail_from": obj.get("mail_from"),
            "max_revisions": obj.get("max_revisions"),
            "min_days_revisions": obj.get("min_days_revisions"),
            "min_delta_revisions": obj.get("min_delta_revisions"),
            "onboarding_email_active": obj.get("onboarding_email_active"),
            "onboarding_email_admins_body": obj.get("onboarding_email_admins_body"),
            "onboarding_email_admins_subject": obj.get("onboarding_email_admins_subject"),
            "onboarding_email_body": obj.get("onboarding_email_body"),
            "onboarding_email_different_for_admins": obj.get("onboarding_email_different_for_admins"),
            "onboarding_email_subject": obj.get("onboarding_email_subject"),
            "open_science": obj.get("open_science"),
            "open_team": obj.get("open_team"),
            "privacy_policy": obj.get("privacy_policy"),
            "proxy": obj.get("proxy"),
            "remote_dir_config": obj.get("remote_dir_config"),
            "remote_dir_service": obj.get("remote_dir_service"),
            "s3_bucket_name": obj.get("s3_bucket_name"),
            "s3_endpoint": obj.get("s3_endpoint"),
            "s3_path_prefix": obj.get("s3_path_prefix"),
            "s3_region": obj.get("s3_region"),
            "s3_verify_cert": obj.get("s3_verify_cert"),
            "saml_acs_binding": obj.get("saml_acs_binding"),
            "saml_allowrepeatattributename": obj.get("saml_allowrepeatattributename"),
            "saml_authnrequestssigned": obj.get("saml_authnrequestssigned"),
            "saml_baseurl": obj.get("saml_baseurl"),
            "saml_debug": obj.get("saml_debug"),
            "saml_entityid": obj.get("saml_entityid"),
            "saml_logoutrequestsigned": obj.get("saml_logoutrequestsigned"),
            "saml_logoutresponsesigned": obj.get("saml_logoutresponsesigned"),
            "saml_lowercaseurlencoding": obj.get("saml_lowercaseurlencoding"),
            "saml_nameidencrypted": obj.get("saml_nameidencrypted"),
            "saml_nameidformat": obj.get("saml_nameidformat"),
            "saml_privatekey": obj.get("saml_privatekey"),
            "saml_relaxdestinationvalidation": obj.get("saml_relaxdestinationvalidation"),
            "saml_signmetadata": obj.get("saml_signmetadata"),
            "saml_slo_binding": obj.get("saml_slo_binding"),
            "saml_strict": obj.get("saml_strict"),
            "saml_sync_teams": obj.get("saml_sync_teams"),
            "saml_team_create": obj.get("saml_team_create"),
            "saml_team_default": obj.get("saml_team_default"),
            "saml_toggle": obj.get("saml_toggle"),
            "saml_user_default": obj.get("saml_user_default"),
            "saml_wantassertionsencrypted": obj.get("saml_wantassertionsencrypted"),
            "saml_wantassertionssigned": obj.get("saml_wantassertionssigned"),
            "saml_wantmessagessigned": obj.get("saml_wantmessagessigned"),
            "saml_wantnameid": obj.get("saml_wantnameid"),
            "saml_wantnameidencrypted": obj.get("saml_wantnameidencrypted"),
            "saml_wantxmlvalidation": obj.get("saml_wantxmlvalidation"),
            "saml_x509": obj.get("saml_x509"),
            "saml_x509_new": obj.get("saml_x509_new"),
            "schema": obj.get("schema"),
            "smtp_address": obj.get("smtp_address"),
            "smtp_encryption": obj.get("smtp_encryption"),
            "smtp_password": obj.get("smtp_password"),
            "smtp_port": obj.get("smtp_port"),
            "smtp_username": obj.get("smtp_username"),
            "support_url": obj.get("support_url"),
            "ts_authority": obj.get("ts_authority"),
            "ts_cert": obj.get("ts_cert"),
            "ts_hash": obj.get("ts_hash"),
            "ts_limit": obj.get("ts_limit"),
            "ts_login": obj.get("ts_login"),
            "ts_password": obj.get("ts_password"),
            "ts_url": obj.get("ts_url"),
            "uploads_storage": obj.get("uploads_storage")
        })
        return _obj


