# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from elabapi_python.models.metadata import Metadata
from typing import Optional, Set
from typing_extensions import Self

class EntityEditable(BaseModel):
    """
    For columns that can be modified by POST or PATCH
    """ # noqa: E501
    body: Optional[StrictStr] = Field(default=None, description="The main text content (HTML or Markdown)")
    canread: Optional[StrictStr] = Field(default='{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}', description="JSON permissions for reading the entry")
    canwrite: Optional[StrictStr] = Field(default='{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}', description="JSON permissions for writing the entry")
    category: Optional[StrictInt] = Field(default=None, description="The experiment category ID")
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    content_type: Optional[StrictInt] = Field(default=None, description="Set the content type for main text: 1 for HTML (default) and 2 for Markdown ")
    custom_id: Optional[StrictInt] = Field(default=None, description="Cannot be negative. Can be reset with \"0\", null or empty string.")
    metadata: Optional[Metadata] = None
    rating: Optional[StrictInt] = Field(default=0, description="Rating value from 0 to 5")
    state: Optional[StrictInt] = None
    status: Optional[StrictInt] = Field(default=None, description="Cannot be negative nor empty string. Can be reset with \"0\" and null.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="An array of tags to assign to the created entry. ")
    title: Optional[StrictStr] = Field(default='Untitled', description="The title of the entry")
    template: Optional[StrictInt] = Field(default=-1, description="The template id to use, or 0 to use the common team template, or -1 to have an empty body. ")
    userid: Optional[StrictInt] = Field(default=None, description="Userid of entity's owner")
    __properties: ClassVar[List[str]] = ["body", "canread", "canwrite", "category", "date", "content_type", "custom_id", "metadata", "rating", "state", "status", "tags", "title", "template", "userid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntityEditable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if canread (nullable) is None
        # and model_fields_set contains the field
        if self.canread is None and "canread" in self.model_fields_set:
            _dict['canread'] = None

        # set to None if canwrite (nullable) is None
        # and model_fields_set contains the field
        if self.canwrite is None and "canwrite" in self.model_fields_set:
            _dict['canwrite'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if custom_id (nullable) is None
        # and model_fields_set contains the field
        if self.custom_id is None and "custom_id" in self.model_fields_set:
            _dict['custom_id'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntityEditable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body": obj.get("body"),
            "canread": obj.get("canread") if obj.get("canread") is not None else '{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}',
            "canwrite": obj.get("canwrite") if obj.get("canwrite") is not None else '{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}',
            "category": obj.get("category"),
            "date": obj.get("date"),
            "content_type": obj.get("content_type"),
            "custom_id": obj.get("custom_id"),
            "metadata": Metadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "rating": obj.get("rating") if obj.get("rating") is not None else 0,
            "state": obj.get("state"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "title": obj.get("title") if obj.get("title") is not None else 'Untitled',
            "template": obj.get("template") if obj.get("template") is not None else -1,
            "userid": obj.get("userid")
        })
        return _obj


