# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Event(BaseModel):
    """
    Event
    """ # noqa: E501
    title: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    start: Optional[StrictStr] = None
    end: Optional[StrictStr] = None
    userid: Optional[StrictInt] = None
    item_title: Optional[StrictStr] = None
    color: Optional[StrictStr] = None
    fullname: Optional[StrictStr] = None
    item_link: Optional[StrictInt] = None
    item_link_title: Optional[StrictStr] = None
    experiment: Optional[StrictInt] = None
    experiment_title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["title", "id", "start", "end", "userid", "item_title", "color", "fullname", "item_link", "item_link_title", "experiment", "experiment_title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Event from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Event from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "id": obj.get("id"),
            "start": obj.get("start"),
            "end": obj.get("end"),
            "userid": obj.get("userid"),
            "item_title": obj.get("item_title"),
            "color": obj.get("color"),
            "fullname": obj.get("fullname"),
            "item_link": obj.get("item_link"),
            "item_link_title": obj.get("item_link_title"),
            "experiment": obj.get("experiment"),
            "experiment_title": obj.get("experiment_title")
        })
        return _obj


