# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Export(BaseModel):
    """
    Export
    """ # noqa: E501
    id: Optional[StrictInt] = None
    created_at: Optional[StrictStr] = None
    requester_userid: Optional[StrictInt] = None
    state: Optional[StrictInt] = None
    long_name: Optional[StrictStr] = None
    filesize: Optional[StrictInt] = None
    modified_at: Optional[StrictStr] = None
    real_name: Optional[StrictStr] = None
    team: Optional[StrictInt] = None
    changelog: Optional[StrictInt] = None
    pdfa: Optional[StrictInt] = None
    var_json: Optional[StrictInt] = Field(default=None, alias="json")
    hash: Optional[StrictStr] = None
    hash_algo: Optional[StrictStr] = None
    experiments: Optional[StrictInt] = None
    items: Optional[StrictInt] = None
    experiments_templates: Optional[StrictInt] = None
    items_types: Optional[StrictInt] = None
    format: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "created_at", "requester_userid", "state", "long_name", "filesize", "modified_at", "real_name", "team", "changelog", "pdfa", "json", "hash", "hash_algo", "experiments", "items", "experiments_templates", "items_types", "format"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Export from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Export from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "requester_userid": obj.get("requester_userid"),
            "state": obj.get("state"),
            "long_name": obj.get("long_name"),
            "filesize": obj.get("filesize"),
            "modified_at": obj.get("modified_at"),
            "real_name": obj.get("real_name"),
            "team": obj.get("team"),
            "changelog": obj.get("changelog"),
            "pdfa": obj.get("pdfa"),
            "json": obj.get("json"),
            "hash": obj.get("hash"),
            "hash_algo": obj.get("hash_algo"),
            "experiments": obj.get("experiments"),
            "items": obj.get("items"),
            "experiments_templates": obj.get("experiments_templates"),
            "items_types": obj.get("items_types"),
            "format": obj.get("format")
        })
        return _obj


