# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from elabapi_python.models.patch_event_request_one_of import PatchEventRequestOneOf
from elabapi_python.models.patch_event_request_one_of1 import PatchEventRequestOneOf1
from elabapi_python.models.patch_event_request_one_of2 import PatchEventRequestOneOf2
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

PATCHEVENTREQUEST_ONE_OF_SCHEMAS = ["PatchEventRequestOneOf", "PatchEventRequestOneOf1", "PatchEventRequestOneOf2"]

class PatchEventRequest(BaseModel):
    """
    PatchEventRequest
    """
    # data type: PatchEventRequestOneOf
    oneof_schema_1_validator: Optional[PatchEventRequestOneOf] = None
    # data type: PatchEventRequestOneOf1
    oneof_schema_2_validator: Optional[PatchEventRequestOneOf1] = None
    # data type: PatchEventRequestOneOf2
    oneof_schema_3_validator: Optional[PatchEventRequestOneOf2] = None
    actual_instance: Optional[Union[PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2]] = None
    one_of_schemas: Set[str] = { "PatchEventRequestOneOf", "PatchEventRequestOneOf1", "PatchEventRequestOneOf2" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = PatchEventRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: PatchEventRequestOneOf
        if not isinstance(v, PatchEventRequestOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchEventRequestOneOf`")
        else:
            match += 1
        # validate data type: PatchEventRequestOneOf1
        if not isinstance(v, PatchEventRequestOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchEventRequestOneOf1`")
        else:
            match += 1
        # validate data type: PatchEventRequestOneOf2
        if not isinstance(v, PatchEventRequestOneOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchEventRequestOneOf2`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in PatchEventRequest with oneOf schemas: PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in PatchEventRequest with oneOf schemas: PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into PatchEventRequestOneOf
        try:
            instance.actual_instance = PatchEventRequestOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PatchEventRequestOneOf1
        try:
            instance.actual_instance = PatchEventRequestOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PatchEventRequestOneOf2
        try:
            instance.actual_instance = PatchEventRequestOneOf2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PatchEventRequest with oneOf schemas: PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PatchEventRequest with oneOf schemas: PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PatchEventRequestOneOf, PatchEventRequestOneOf1, PatchEventRequestOneOf2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


