# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PatchExperimentRequestAnyOf(BaseModel):
    """
    PatchExperimentRequestAnyOf
    """ # noqa: E501
    action: Optional[StrictStr] = None
    passphrase: Optional[StrictStr] = Field(default=None, description="The passphrase corresponding to your signature key. This parameter is required when Action is \"sign\"")
    meaning: Optional[StrictInt] = Field(default=None, description="Meaning of the signature. This parameter is required when Action is \"sign\" - 10: Approval - 20: Authorship - 30: Responsibility - 40: Review - 50: Safety ")
    __properties: ClassVar[List[str]] = ["action", "passphrase", "meaning"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['bloxberg', 'exclusiveeditmode', 'lock', 'pin', 'sign', 'timestamp', 'updatemetadatafield', 'update']):
            raise ValueError("must be one of enum values ('bloxberg', 'exclusiveeditmode', 'lock', 'pin', 'sign', 'timestamp', 'updatemetadatafield', 'update')")
        return value

    @field_validator('meaning')
    def meaning_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([10, 20, 30, 40, 50]):
            raise ValueError("must be one of enum values (10, 20, 30, 40, 50)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchExperimentRequestAnyOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchExperimentRequestAnyOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "passphrase": obj.get("passphrase"),
            "meaning": obj.get("meaning")
        })
        return _obj


