# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PostExperimentByIdRequest(BaseModel):
    """
    PostExperimentByIdRequest
    """ # noqa: E501
    action: Optional[StrictStr] = Field(default='duplicate', description="The \"duplicate\" action creates a new entity based from the given entity id. ")
    copy_files: Optional[StrictBool] = Field(default=False, description="If \"true\", the action will import the files of the original entity. ", alias="copyFiles")
    link_to_original: Optional[StrictBool] = Field(default=True, description="If \"true\", the action will create a link to the original entity. ", alias="linkToOriginal")
    __properties: ClassVar[List[str]] = ["action", "copyFiles", "linkToOriginal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostExperimentByIdRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostExperimentByIdRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action") if obj.get("action") is not None else 'duplicate',
            "copyFiles": obj.get("copyFiles") if obj.get("copyFiles") is not None else False,
            "linkToOriginal": obj.get("linkToOriginal") if obj.get("linkToOriginal") is not None else True
        })
        return _obj


