# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from elabapi_python.models.users_teams_inner import UsersTeamsInner
from typing import Optional, Set
from typing_extensions import Self

class Users(BaseModel):
    """
    Users
    """ # noqa: E501
    userid: Optional[StrictInt] = None
    firstname: Optional[StrictStr] = None
    lastname: Optional[StrictStr] = None
    initials: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    validated: Optional[StrictInt] = None
    valid_until: Optional[StrictStr] = None
    archived: Optional[StrictInt] = None
    last_login: Optional[StrictStr] = None
    fullname: Optional[StrictStr] = None
    orcid: Optional[StrictStr] = None
    orgid: Optional[StrictStr] = None
    auth_service: Optional[StrictInt] = None
    is_sysadmin: Optional[StrictInt] = None
    entrypoint: Optional[StrictInt] = None
    sig_pubkey: Optional[StrictStr] = Field(default=None, description="Public signature key (minisign format)")
    teams: Optional[List[UsersTeamsInner]] = None
    __properties: ClassVar[List[str]] = ["userid", "firstname", "lastname", "initials", "email", "validated", "valid_until", "archived", "last_login", "fullname", "orcid", "orgid", "auth_service", "is_sysadmin", "entrypoint", "sig_pubkey", "teams"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Users from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in teams (list)
        _items = []
        if self.teams:
            for _item_teams in self.teams:
                if _item_teams:
                    _items.append(_item_teams.to_dict())
            _dict['teams'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Users from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userid": obj.get("userid"),
            "firstname": obj.get("firstname"),
            "lastname": obj.get("lastname"),
            "initials": obj.get("initials"),
            "email": obj.get("email"),
            "validated": obj.get("validated"),
            "valid_until": obj.get("valid_until"),
            "archived": obj.get("archived"),
            "last_login": obj.get("last_login"),
            "fullname": obj.get("fullname"),
            "orcid": obj.get("orcid"),
            "orgid": obj.get("orgid"),
            "auth_service": obj.get("auth_service"),
            "is_sysadmin": obj.get("is_sysadmin"),
            "entrypoint": obj.get("entrypoint"),
            "sig_pubkey": obj.get("sig_pubkey"),
            "teams": [UsersTeamsInner.from_dict(_item) for _item in obj["teams"]] if obj.get("teams") is not None else None
        })
        return _obj


