# elabapi-python
This document describes all available endpoints and methods for eLabFTW's API version 2.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 5.2.2
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/elabftw/elabapi-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/elabftw/elabapi-python.git`)

Then import the package:
```python
import elabapi_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import elabapi_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import elabapi_python
from elabapi_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://elab.local:3148/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = elabapi_python.Configuration(
    host = "https://elab.local:3148/api/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'


# Enter a context with an instance of the API client
with elabapi_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = elabapi_python.ApiKeysApi(api_client)
    id = 56 # int | ID of the API key

    try:
        # Delete an API key.
        api_instance.delete_apikey(id)
    except ApiException as e:
        print("Exception when calling ApiKeysApi->delete_apikey: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://elab.local:3148/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeysApi* | [**delete_apikey**](docs/ApiKeysApi.md#delete_apikey) | **DELETE** /apikeys/{id} | Delete an API key.
*ApiKeysApi* | [**get_apikeys**](docs/ApiKeysApi.md#get_apikeys) | **GET** /apikeys | Read API keys
*ApiKeysApi* | [**post_apikeys**](docs/ApiKeysApi.md#post_apikeys) | **POST** /apikeys | Create an API key
*CommentsApi* | [**delete_entity_comment**](docs/CommentsApi.md#delete_entity_comment) | **DELETE** /{entity_type}/{id}/comments/{subid} | Delete an entity comment.
*CommentsApi* | [**patch_entity_comment**](docs/CommentsApi.md#patch_entity_comment) | **PATCH** /{entity_type}/{id}/comments/{subid} | Modify an entity comment.
*CommentsApi* | [**post_entity_comments**](docs/CommentsApi.md#post_entity_comments) | **POST** /{entity_type}/{id}/comments | Create a comment.
*CommentsApi* | [**read_entity_comment**](docs/CommentsApi.md#read_entity_comment) | **GET** /{entity_type}/{id}/comments/{subid} | Read a comment of that entity.
*CommentsApi* | [**read_entity_comments**](docs/CommentsApi.md#read_entity_comments) | **GET** /{entity_type}/{id}/comments | Read all comments of that entity.
*CompoundsApi* | [**delete_compound**](docs/CompoundsApi.md#delete_compound) | **DELETE** /compounds/{id} | Soft-delete a compound
*CompoundsApi* | [**get_compound**](docs/CompoundsApi.md#get_compound) | **GET** /compounds/{id} | Get a single compound
*CompoundsApi* | [**get_compounds**](docs/CompoundsApi.md#get_compounds) | **GET** /compounds | Read compounds
*CompoundsApi* | [**post_compounds**](docs/CompoundsApi.md#post_compounds) | **POST** /compounds | Create or import a compound
*ConfigApi* | [**delete_config**](docs/ConfigApi.md#delete_config) | **DELETE** /config | Reset the config to default values
*ConfigApi* | [**get_config**](docs/ConfigApi.md#get_config) | **GET** /config | Read the config
*ConfigApi* | [**patch_config**](docs/ConfigApi.md#patch_config) | **PATCH** /config | Modify the config
*EventsApi* | [**delete_event**](docs/EventsApi.md#delete_event) | **DELETE** /event/{id} | Delete a booking slot.
*EventsApi* | [**patch_event**](docs/EventsApi.md#patch_event) | **PATCH** /event/{id} | Modify a booking slot. Warning: only one value (target) can be edited at a time. 
*EventsApi* | [**post_events**](docs/EventsApi.md#post_events) | **POST** /events/{id} | Create an event for the item specified as id.
*EventsApi* | [**read_event**](docs/EventsApi.md#read_event) | **GET** /event/{id} | Read a booking slot.
*EventsApi* | [**read_events**](docs/EventsApi.md#read_events) | **GET** /events | Read all events in the team.
*ExperimentsApi* | [**delete_experiment**](docs/ExperimentsApi.md#delete_experiment) | **DELETE** /experiments/{id} | Delete an experiment.
*ExperimentsApi* | [**get_experiment**](docs/ExperimentsApi.md#get_experiment) | **GET** /experiments/{id} | Read an experiment
*ExperimentsApi* | [**patch_experiment**](docs/ExperimentsApi.md#patch_experiment) | **PATCH** /experiments/{id} | Modify an experiment
*ExperimentsApi* | [**post_experiment**](docs/ExperimentsApi.md#post_experiment) | **POST** /experiments | Create an experiment
*ExperimentsApi* | [**post_experiment_by_id**](docs/ExperimentsApi.md#post_experiment_by_id) | **POST** /experiments/{id} | Duplicate an experiment with its ID
*ExperimentsApi* | [**read_experiments**](docs/ExperimentsApi.md#read_experiments) | **GET** /experiments | Read all experiments that are accessible
*ExperimentsCategoriesApi* | [**delete_expcat**](docs/ExperimentsCategoriesApi.md#delete_expcat) | **DELETE** /teams/{id}/experiments_categories/{subid} | Delete a category.
*ExperimentsCategoriesApi* | [**patch_expcat**](docs/ExperimentsCategoriesApi.md#patch_expcat) | **PATCH** /teams/{id}/experiments_categories/{subid} | Modify a category.
*ExperimentsCategoriesApi* | [**post_team_one_expcat**](docs/ExperimentsCategoriesApi.md#post_team_one_expcat) | **POST** /teams/{id}/experiments_categories | Create a new category for experiments.
*ExperimentsCategoriesApi* | [**read_team_experiments_categories**](docs/ExperimentsCategoriesApi.md#read_team_experiments_categories) | **GET** /teams/{id}/experiments_categories | Read experiments categories of a team.
*ExperimentsCategoriesApi* | [**read_team_one_expcat**](docs/ExperimentsCategoriesApi.md#read_team_one_expcat) | **GET** /teams/{id}/experiments_categories/{subid} | Read a category.
*ExperimentsStatusApi* | [**delete_expstatus**](docs/ExperimentsStatusApi.md#delete_expstatus) | **DELETE** /teams/{id}/experiments_status/{subid} | Delete a status.
*ExperimentsStatusApi* | [**patch_expstatus**](docs/ExperimentsStatusApi.md#patch_expstatus) | **PATCH** /teams/{id}/experiments_status/{subid} | Modify a status.
*ExperimentsStatusApi* | [**post_team_one_expstatus**](docs/ExperimentsStatusApi.md#post_team_one_expstatus) | **POST** /teams/{id}/experiments_status | Create a new experiments status.
*ExperimentsStatusApi* | [**read_team_experiments_status**](docs/ExperimentsStatusApi.md#read_team_experiments_status) | **GET** /teams/{id}/experiments_status | Read experiments status of a team.
*ExperimentsStatusApi* | [**read_team_one_expstatus**](docs/ExperimentsStatusApi.md#read_team_one_expstatus) | **GET** /teams/{id}/experiments_status/{subid} | Read a status.
*ExperimentsTemplatesApi* | [**delete_experiment_template**](docs/ExperimentsTemplatesApi.md#delete_experiment_template) | **DELETE** /experiments_templates/{id} | Delete an experiment template.
*ExperimentsTemplatesApi* | [**get_experiment_template**](docs/ExperimentsTemplatesApi.md#get_experiment_template) | **GET** /experiments_templates/{id} | Read an experiment template
*ExperimentsTemplatesApi* | [**patch_experiment_template**](docs/ExperimentsTemplatesApi.md#patch_experiment_template) | **PATCH** /experiments_templates/{id} | Modify an experiment template
*ExperimentsTemplatesApi* | [**post_experiment_template**](docs/ExperimentsTemplatesApi.md#post_experiment_template) | **POST** /experiments_templates | Create an experiment template
*ExperimentsTemplatesApi* | [**post_experiment_template_by_id**](docs/ExperimentsTemplatesApi.md#post_experiment_template_by_id) | **POST** /experiments_templates/{id} | Duplicate an experiment template with its ID
*ExperimentsTemplatesApi* | [**read_experiments_templates**](docs/ExperimentsTemplatesApi.md#read_experiments_templates) | **GET** /experiments_templates | Read all experiments_templates that are accessible
*ExportsApi* | [**delete_export**](docs/ExportsApi.md#delete_export) | **DELETE** /exports/{id} | Remove an export request and its associated file
*ExportsApi* | [**post_export**](docs/ExportsApi.md#post_export) | **POST** /exports | Register an export request
*ExportsApi* | [**read_export**](docs/ExportsApi.md#read_export) | **GET** /exports/{id} | Get export
*ExportsApi* | [**readall_exports**](docs/ExportsApi.md#readall_exports) | **GET** /exports | List exports
*ExtraFieldsKeysApi* | [**extra_fields_keys**](docs/ExtraFieldsKeysApi.md#extra_fields_keys) | **GET** /extra_fields_keys | Read extra fields keys.
*FavoriteTagsApi* | [**delete_favtag**](docs/FavoriteTagsApi.md#delete_favtag) | **DELETE** /favtags/{id} | Unfavorite a tag.
*FavoriteTagsApi* | [**post_favtags**](docs/FavoriteTagsApi.md#post_favtags) | **POST** /favtags | Add a tag as favorite.
*FavoriteTagsApi* | [**read_favtags**](docs/FavoriteTagsApi.md#read_favtags) | **GET** /favtags | Read all favorite tags for the user.
*IdpsApi* | [**delete_idp**](docs/IdpsApi.md#delete_idp) | **DELETE** /idps/{id} | Delete an idp.
*IdpsApi* | [**patch_idp**](docs/IdpsApi.md#patch_idp) | **PATCH** /idps/{id} | Actions on an idp.
*IdpsApi* | [**post_idp**](docs/IdpsApi.md#post_idp) | **POST** /idps | Create an idp.
*IdpsApi* | [**read_idp**](docs/IdpsApi.md#read_idp) | **GET** /idps/{id} | Read an idp.
*IdpsApi* | [**read_idps**](docs/IdpsApi.md#read_idps) | **GET** /idps | Read all IDPs.
*ImportApi* | [**post_import**](docs/ImportApi.md#post_import) | **POST** /import | Send a file to import
*ImportApi* | [**read_import**](docs/ImportApi.md#read_import) | **GET** /import | Get information about this endpoint
*InfoApi* | [**get_info**](docs/InfoApi.md#get_info) | **GET** /info | Get information about the instance.
*ItemsApi* | [**delete_item**](docs/ItemsApi.md#delete_item) | **DELETE** /items/{id} | Delete an item.
*ItemsApi* | [**get_item**](docs/ItemsApi.md#get_item) | **GET** /items/{id} | Read an item
*ItemsApi* | [**patch_item**](docs/ItemsApi.md#patch_item) | **PATCH** /items/{id} | Modify an item
*ItemsApi* | [**post_item**](docs/ItemsApi.md#post_item) | **POST** /items | Create an item
*ItemsApi* | [**post_item_by_id**](docs/ItemsApi.md#post_item_by_id) | **POST** /items/{id} | Duplicate an item with its ID
*ItemsApi* | [**read_items**](docs/ItemsApi.md#read_items) | **GET** /items | Read all items that are accessible
*ItemsTypesApi* | [**delete_items_type**](docs/ItemsTypesApi.md#delete_items_type) | **DELETE** /items_types/{id} | Delete a resource category.
*ItemsTypesApi* | [**get_items_type**](docs/ItemsTypesApi.md#get_items_type) | **GET** /items_types/{id} | Read a resource category.
*ItemsTypesApi* | [**patch_items_type**](docs/ItemsTypesApi.md#patch_items_type) | **PATCH** /items_types/{id} | Modify a resource category.
*ItemsTypesApi* | [**post_items_types**](docs/ItemsTypesApi.md#post_items_types) | **POST** /items_types | Create a resource category
*ItemsTypesApi* | [**read_items_types**](docs/ItemsTypesApi.md#read_items_types) | **GET** /items_types | Read all resources categories that are accessible.
*LinksToExperimentsApi* | [**delete_entity_experiments_link**](docs/LinksToExperimentsApi.md#delete_entity_experiments_link) | **DELETE** /{entity_type}/{id}/experiments_links/{subid} | Delete an experiment link.
*LinksToExperimentsApi* | [**post_entity_experiments_links**](docs/LinksToExperimentsApi.md#post_entity_experiments_links) | **POST** /{entity_type}/{id}/experiments_links/{subid} | Create or import a link.
*LinksToExperimentsApi* | [**read_entity_experiments_links**](docs/LinksToExperimentsApi.md#read_entity_experiments_links) | **GET** /{entity_type}/{id}/experiments_links | Read all experiments links of that entity.
*LinksToItemsApi* | [**delete_entitiy_items_link**](docs/LinksToItemsApi.md#delete_entitiy_items_link) | **DELETE** /{entity_type}/{id}/items_links/{subid} | Delete an item link.
*LinksToItemsApi* | [**post_entity_items_links**](docs/LinksToItemsApi.md#post_entity_items_links) | **POST** /{entity_type}/{id}/items_links/{subid} | Create or import a link.
*LinksToItemsApi* | [**read_entity_items_links**](docs/LinksToItemsApi.md#read_entity_items_links) | **GET** /{entity_type}/{id}/items_links | Read all items links of that entity.
*NotificationsApi* | [**delete_notifications**](docs/NotificationsApi.md#delete_notifications) | **DELETE** /users/{id}/notifications | Delete all notifications of the user.
*NotificationsApi* | [**patch_notification**](docs/NotificationsApi.md#patch_notification) | **PATCH** /users/{id}/notifications/{subid} | Actions on a notification. Only changing &#x60;is_ack&#x60; column is possible. 
*NotificationsApi* | [**read_notification**](docs/NotificationsApi.md#read_notification) | **GET** /users/{id}/notifications/{subid} | Read a notification.
*NotificationsApi* | [**read_notifications**](docs/NotificationsApi.md#read_notifications) | **GET** /users/{id}/notifications | Read notifications of a user.
*ReportsApi* | [**get_reports**](docs/ReportsApi.md#get_reports) | **GET** /reports | Get usage reports
*ResourcesStatusApi* | [**delete_resstatus**](docs/ResourcesStatusApi.md#delete_resstatus) | **DELETE** /teams/{id}/items_status/{subid} | Delete a status.
*ResourcesStatusApi* | [**patch_resstatus**](docs/ResourcesStatusApi.md#patch_resstatus) | **PATCH** /teams/{id}/items_status/{subid} | Modify a status.
*ResourcesStatusApi* | [**post_team_one_resstat**](docs/ResourcesStatusApi.md#post_team_one_resstat) | **POST** /teams/{id}/items_status | Create a new status for resources.
*ResourcesStatusApi* | [**read_team_items_status**](docs/ResourcesStatusApi.md#read_team_items_status) | **GET** /teams/{id}/items_status | Read resources status of a team.
*ResourcesStatusApi* | [**read_team_one_resstatus**](docs/ResourcesStatusApi.md#read_team_one_resstatus) | **GET** /teams/{id}/items_status/{subid} | Read a status.
*RevisionsApi* | [**patch_entity_revision**](docs/RevisionsApi.md#patch_entity_revision) | **PATCH** /{entity_type}/{id}/revisions/{subid} | Restore a revision.
*RevisionsApi* | [**read_entity_revision**](docs/RevisionsApi.md#read_entity_revision) | **GET** /{entity_type}/{id}/revisions/{subid} | Read a revision of that entity.
*RevisionsApi* | [**read_entity_revisions**](docs/RevisionsApi.md#read_entity_revisions) | **GET** /{entity_type}/{id}/revisions | Read all revisions of that entity.
*StepsApi* | [**delete_step**](docs/StepsApi.md#delete_step) | **DELETE** /{entity_type}/{id}/steps/{subid} | Delete a step.
*StepsApi* | [**patch_step**](docs/StepsApi.md#patch_step) | **PATCH** /{entity_type}/{id}/steps/{subid} | Actions on a step. 
*StepsApi* | [**post_step**](docs/StepsApi.md#post_step) | **POST** /{entity_type}/{id}/steps | Create a step.
*StepsApi* | [**read_steps**](docs/StepsApi.md#read_steps) | **GET** /{entity_type}/{id}/steps | Read all steps of that entity.
*TagsApi* | [**delete_tag**](docs/TagsApi.md#delete_tag) | **DELETE** /{entity_type}/{id}/tags | Delete all tags.
*TagsApi* | [**patch_tag**](docs/TagsApi.md#patch_tag) | **PATCH** /{entity_type}/{id}/tags/{subid} | Actions on a tag (like removing it from the entity). 
*TagsApi* | [**post_tag**](docs/TagsApi.md#post_tag) | **POST** /{entity_type}/{id}/tags | Create a tag.
*TagsApi* | [**read_tag**](docs/TagsApi.md#read_tag) | **GET** /{entity_type}/{id}/tags/{subid} | Read a tag.
*TagsApi* | [**read_tags**](docs/TagsApi.md#read_tags) | **GET** /{entity_type}/{id}/tags | Read all tags of that entity.
*TeamTagsApi* | [**delete_team_tag**](docs/TeamTagsApi.md#delete_team_tag) | **DELETE** /teams/{id}/tags/{subid} | Delete a tag.
*TeamTagsApi* | [**patch_team_tag**](docs/TeamTagsApi.md#patch_team_tag) | **PATCH** /teams/{id}/tags/{subid} | Actions on a tag. 
*TeamTagsApi* | [**post_team_tag**](docs/TeamTagsApi.md#post_team_tag) | **POST** /teams/{id}/tags | Create a tag in the team.
*TeamTagsApi* | [**read_team_tag**](docs/TeamTagsApi.md#read_team_tag) | **GET** /teams/{id}/tags/{subid} | Read a tag.
*TeamTagsApi* | [**read_team_tags**](docs/TeamTagsApi.md#read_team_tags) | **GET** /teams/{id}/tags | Read all tags for the team.
*TeamgroupsApi* | [**delete_teamgroup**](docs/TeamgroupsApi.md#delete_teamgroup) | **DELETE** /teams/{id}/teamgroups/{subid} | Delete a teamgroup.
*TeamgroupsApi* | [**patch_teamgroup**](docs/TeamgroupsApi.md#patch_teamgroup) | **PATCH** /teams/{id}/teamgroups/{subid} | Modify a teamgroup.
*TeamgroupsApi* | [**post_teamgroups**](docs/TeamgroupsApi.md#post_teamgroups) | **POST** /teams/{id}/teamgroups | Create a new teamgroup.
*TeamgroupsApi* | [**read_team_teamgroups**](docs/TeamgroupsApi.md#read_team_teamgroups) | **GET** /teams/{id}/teamgroups | Read teamgroups of a team.
*TeamgroupsApi* | [**read_teamgroup**](docs/TeamgroupsApi.md#read_teamgroup) | **GET** /teams/{id}/teamgroups/{subid} | Read a teamgroup.
*TeamsApi* | [**patch_team**](docs/TeamsApi.md#patch_team) | **PATCH** /teams/{id} | Actions on a team. 
*TeamsApi* | [**post_teams**](docs/TeamsApi.md#post_teams) | **POST** /teams | Create a new team.
*TeamsApi* | [**read_team**](docs/TeamsApi.md#read_team) | **GET** /teams/{id} | Read a team. Requires Admin permissions.
*TeamsApi* | [**read_teams**](docs/TeamsApi.md#read_teams) | **GET** /teams | Read all teams. Requires Sysadmin permissions.
*TodolistApi* | [**delete_todoitem**](docs/TodolistApi.md#delete_todoitem) | **DELETE** /todolist/{id} | Delete a todoitem.
*TodolistApi* | [**patch_todoitem**](docs/TodolistApi.md#patch_todoitem) | **PATCH** /todolist/{id} | Actions on a todoitem. 
*TodolistApi* | [**post_todolist**](docs/TodolistApi.md#post_todolist) | **POST** /todolist | Create a todo item
*TodolistApi* | [**read_todoitem**](docs/TodolistApi.md#read_todoitem) | **GET** /todolist/{id} | Read a todo entry.
*TodolistApi* | [**read_todolist**](docs/TodolistApi.md#read_todolist) | **GET** /todolist | Read all todoitems.
*UnfinishedStepsApi* | [**read_unfinished_steps**](docs/UnfinishedStepsApi.md#read_unfinished_steps) | **GET** /unfinished_steps | Read all unfinished steps.
*UploadsApi* | [**delete_upload**](docs/UploadsApi.md#delete_upload) | **DELETE** /{entity_type}/{id}/uploads/{subid} | Delete an upload.
*UploadsApi* | [**patch_upload**](docs/UploadsApi.md#patch_upload) | **PATCH** /{entity_type}/{id}/uploads/{subid} | Modify attributes such as \&quot;real_name\&quot;, \&quot;comment\&quot; or \&quot;state\&quot; of an upload. 
*UploadsApi* | [**post_upload**](docs/UploadsApi.md#post_upload) | **POST** /{entity_type}/{id}/uploads | Create an upload.
*UploadsApi* | [**post_upload_replace**](docs/UploadsApi.md#post_upload_replace) | **POST** /{entity_type}/{id}/uploads/{subid} | Replace an existing uploaded file. The existing file will be archived and the new one will be added.
*UploadsApi* | [**read_upload**](docs/UploadsApi.md#read_upload) | **GET** /{entity_type}/{id}/uploads/{subid} | Read an upload.
*UploadsApi* | [**read_uploads**](docs/UploadsApi.md#read_uploads) | **GET** /{entity_type}/{id}/uploads | Read attached files of that entity.
*UserUploadsApi* | [**read_user_uploads**](docs/UserUploadsApi.md#read_user_uploads) | **GET** /users/{id}/uploads | Read attached files from a user
*UsersApi* | [**patch_user**](docs/UsersApi.md#patch_user) | **PATCH** /users/{id} | Modify a user.
*UsersApi* | [**post_user**](docs/UsersApi.md#post_user) | **POST** /users | Create a new user.
*UsersApi* | [**read_user**](docs/UsersApi.md#read_user) | **GET** /users/{id} | Read information of a user.
*UsersApi* | [**read_users**](docs/UsersApi.md#read_users) | **GET** /users | Read users from instance.


## Documentation For Models

 - [Apikey](docs/Apikey.md)
 - [Comment](docs/Comment.md)
 - [Compound](docs/Compound.md)
 - [CompoundCreateRequest](docs/CompoundCreateRequest.md)
 - [CompoundDuplicateRequest](docs/CompoundDuplicateRequest.md)
 - [Config](docs/Config.md)
 - [Entity](docs/Entity.md)
 - [EntityEditable](docs/EntityEditable.md)
 - [EntityTemplate](docs/EntityTemplate.md)
 - [EntityTemplateEditable](docs/EntityTemplateEditable.md)
 - [Event](docs/Event.md)
 - [ExclusiveEditMode](docs/ExclusiveEditMode.md)
 - [Experiment](docs/Experiment.md)
 - [Export](docs/Export.md)
 - [ExtraFieldsKeys](docs/ExtraFieldsKeys.md)
 - [GetInfo200Response](docs/GetInfo200Response.md)
 - [GetReports200Response](docs/GetReports200Response.md)
 - [GetReports200ResponseQueryParameters](docs/GetReports200ResponseQueryParameters.md)
 - [Idp](docs/Idp.md)
 - [Item](docs/Item.md)
 - [ItemsType](docs/ItemsType.md)
 - [Link](docs/Link.md)
 - [Metadata](docs/Metadata.md)
 - [MetadataElabftw](docs/MetadataElabftw.md)
 - [MetadataElabftwExtraFieldsGroupsInner](docs/MetadataElabftwExtraFieldsGroupsInner.md)
 - [MetadataExtraFieldsValue](docs/MetadataExtraFieldsValue.md)
 - [Notification](docs/Notification.md)
 - [PatchEntityRevisionRequest](docs/PatchEntityRevisionRequest.md)
 - [PatchEventRequest](docs/PatchEventRequest.md)
 - [PatchEventRequestOneOf](docs/PatchEventRequestOneOf.md)
 - [PatchEventRequestOneOf1](docs/PatchEventRequestOneOf1.md)
 - [PatchEventRequestOneOf2](docs/PatchEventRequestOneOf2.md)
 - [PatchEventRequestOneOf2Delta](docs/PatchEventRequestOneOf2Delta.md)
 - [PatchExperimentRequest](docs/PatchExperimentRequest.md)
 - [PatchExperimentRequestAnyOf](docs/PatchExperimentRequestAnyOf.md)
 - [PatchExperimentTemplateRequest](docs/PatchExperimentTemplateRequest.md)
 - [PatchExperimentTemplateRequestAnyOf](docs/PatchExperimentTemplateRequestAnyOf.md)
 - [PatchIdpRequest](docs/PatchIdpRequest.md)
 - [PatchItemRequest](docs/PatchItemRequest.md)
 - [PatchItemRequestAnyOf](docs/PatchItemRequestAnyOf.md)
 - [PatchStepRequest](docs/PatchStepRequest.md)
 - [PatchTagRequest](docs/PatchTagRequest.md)
 - [PatchTeamRequest](docs/PatchTeamRequest.md)
 - [PatchTeamRequestOneOf](docs/PatchTeamRequestOneOf.md)
 - [PatchTeamTagRequest](docs/PatchTeamTagRequest.md)
 - [PatchTeamgroupRequest](docs/PatchTeamgroupRequest.md)
 - [PatchTeamgroupRequestOneOf](docs/PatchTeamgroupRequestOneOf.md)
 - [PatchTeamgroupRequestOneOf1](docs/PatchTeamgroupRequestOneOf1.md)
 - [PatchTodoitemRequest](docs/PatchTodoitemRequest.md)
 - [PatchUploadRequest](docs/PatchUploadRequest.md)
 - [PatchUserRequest](docs/PatchUserRequest.md)
 - [PatchUserRequestOneOf](docs/PatchUserRequestOneOf.md)
 - [PatchUserRequestOneOf1](docs/PatchUserRequestOneOf1.md)
 - [PatchUserRequestOneOf2](docs/PatchUserRequestOneOf2.md)
 - [PatchUserRequestOneOf3](docs/PatchUserRequestOneOf3.md)
 - [PatchUserRequestOneOf4](docs/PatchUserRequestOneOf4.md)
 - [PostApikeysRequest](docs/PostApikeysRequest.md)
 - [PostCompoundsRequest](docs/PostCompoundsRequest.md)
 - [PostEntityCommentsRequest](docs/PostEntityCommentsRequest.md)
 - [PostEntityItemsLinksRequest](docs/PostEntityItemsLinksRequest.md)
 - [PostEventsRequest](docs/PostEventsRequest.md)
 - [PostExperimentByIdRequest](docs/PostExperimentByIdRequest.md)
 - [PostExperimentRequest](docs/PostExperimentRequest.md)
 - [PostExperimentTemplateByIdRequest](docs/PostExperimentTemplateByIdRequest.md)
 - [PostExportRequest](docs/PostExportRequest.md)
 - [PostFavtagsRequest](docs/PostFavtagsRequest.md)
 - [PostIdpRequest](docs/PostIdpRequest.md)
 - [PostItemByIdRequest](docs/PostItemByIdRequest.md)
 - [PostItemsTypesRequest](docs/PostItemsTypesRequest.md)
 - [PostStepRequest](docs/PostStepRequest.md)
 - [PostTagRequest](docs/PostTagRequest.md)
 - [PostTeamOneExpcatRequest](docs/PostTeamOneExpcatRequest.md)
 - [PostTeamOneExpstatusRequest](docs/PostTeamOneExpstatusRequest.md)
 - [PostTeamTagRequest](docs/PostTeamTagRequest.md)
 - [PostTeamgroupsRequest](docs/PostTeamgroupsRequest.md)
 - [PostTeamsRequest](docs/PostTeamsRequest.md)
 - [PostTodolistRequest](docs/PostTodolistRequest.md)
 - [PostUserRequest](docs/PostUserRequest.md)
 - [ReadEntityRevisions200ResponseInner](docs/ReadEntityRevisions200ResponseInner.md)
 - [ReadFavtags200Response](docs/ReadFavtags200Response.md)
 - [ReadImport200Response](docs/ReadImport200Response.md)
 - [ReadNotifications200Response](docs/ReadNotifications200Response.md)
 - [ReadTeamIdParameter](docs/ReadTeamIdParameter.md)
 - [ReadTeamgroup200Response](docs/ReadTeamgroup200Response.md)
 - [ReadUserIdParameter](docs/ReadUserIdParameter.md)
 - [ReadUserUploads200ResponseInner](docs/ReadUserUploads200ResponseInner.md)
 - [ReadUsers200ResponseInner](docs/ReadUsers200ResponseInner.md)
 - [Revision](docs/Revision.md)
 - [Statuslike](docs/Statuslike.md)
 - [Step](docs/Step.md)
 - [Tag](docs/Tag.md)
 - [Team](docs/Team.md)
 - [Teamgroup](docs/Teamgroup.md)
 - [TeamgroupUsersInner](docs/TeamgroupUsersInner.md)
 - [Todoitem](docs/Todoitem.md)
 - [UnfinishedStep](docs/UnfinishedStep.md)
 - [UnfinishedSteps](docs/UnfinishedSteps.md)
 - [Upload](docs/Upload.md)
 - [Users](docs/Users.md)
 - [UsersTeamsInner](docs/UsersTeamsInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="token"></a>
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




