# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Compound(BaseModel):
    """
    Compound
    """ # noqa: E501
    id: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    created_by: Optional[StrictInt] = None
    modified_at: Optional[datetime] = None
    modified_by: Optional[StrictInt] = None
    userid: Optional[StrictInt] = None
    team: Optional[StrictInt] = None
    state: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    molecular_formula: Optional[StrictStr] = None
    cas_number: Optional[StrictStr] = None
    ec_number: Optional[StrictStr] = None
    chebi_id: Optional[StrictStr] = None
    chembl_id: Optional[StrictStr] = None
    dea_number: Optional[StrictStr] = None
    drugbank_id: Optional[StrictStr] = None
    dsstox_id: Optional[StrictStr] = None
    hmdb_id: Optional[StrictStr] = None
    inchi: Optional[StrictStr] = None
    inchi_key: Optional[StrictStr] = None
    iupac_name: Optional[StrictStr] = None
    kegg_id: Optional[StrictStr] = None
    metabolomics_wb_id: Optional[StrictStr] = None
    molecular_weight: Optional[Union[StrictFloat, StrictInt]] = None
    nci_code: Optional[StrictStr] = None
    nikkaji_number: Optional[StrictStr] = None
    pharmgkb_id: Optional[StrictStr] = None
    pharos_ligand_id: Optional[StrictStr] = None
    pubchem_cid: Optional[StrictInt] = None
    rxcui: Optional[StrictStr] = None
    smiles: Optional[StrictStr] = None
    unii: Optional[StrictStr] = None
    wikidata: Optional[StrictStr] = None
    wikipedia: Optional[StrictStr] = None
    is_corrosive: Optional[StrictBool] = None
    is_explosive: Optional[StrictBool] = None
    is_flammable: Optional[StrictBool] = None
    is_gas_under_pressure: Optional[StrictBool] = None
    is_hazardous2env: Optional[StrictBool] = None
    is_hazardous2health: Optional[StrictBool] = None
    is_serious_health_hazard: Optional[StrictBool] = None
    is_oxidising: Optional[StrictBool] = None
    is_toxic: Optional[StrictBool] = None
    is_radioactive: Optional[StrictBool] = None
    is_antibiotic: Optional[StrictBool] = None
    is_antibiotic_precursor: Optional[StrictBool] = None
    is_drug: Optional[StrictBool] = None
    is_drug_precursor: Optional[StrictBool] = None
    is_explosive_precursor: Optional[StrictBool] = None
    is_cmr: Optional[StrictBool] = None
    is_nano: Optional[StrictBool] = None
    is_controlled: Optional[StrictBool] = None
    is_ed2health: Optional[StrictBool] = None
    is_ed2env: Optional[StrictBool] = None
    is_pbt: Optional[StrictBool] = None
    is_pmt: Optional[StrictBool] = None
    is_vpvb: Optional[StrictBool] = None
    is_vpvm: Optional[StrictBool] = None
    fp2_base64: Optional[StrictStr] = Field(default=None, description="Base64-encoded fingerprint")
    userid_human: Optional[StrictStr] = None
    team_name: Optional[StrictStr] = None
    has_fingerprint: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "created_at", "created_by", "modified_at", "modified_by", "userid", "team", "state", "name", "molecular_formula", "cas_number", "ec_number", "chebi_id", "chembl_id", "dea_number", "drugbank_id", "dsstox_id", "hmdb_id", "inchi", "inchi_key", "iupac_name", "kegg_id", "metabolomics_wb_id", "molecular_weight", "nci_code", "nikkaji_number", "pharmgkb_id", "pharos_ligand_id", "pubchem_cid", "rxcui", "smiles", "unii", "wikidata", "wikipedia", "is_corrosive", "is_explosive", "is_flammable", "is_gas_under_pressure", "is_hazardous2env", "is_hazardous2health", "is_serious_health_hazard", "is_oxidising", "is_toxic", "is_radioactive", "is_antibiotic", "is_antibiotic_precursor", "is_drug", "is_drug_precursor", "is_explosive_precursor", "is_cmr", "is_nano", "is_controlled", "is_ed2health", "is_ed2env", "is_pbt", "is_pmt", "is_vpvb", "is_vpvm", "fp2_base64", "userid_human", "team_name", "has_fingerprint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Compound from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if ec_number (nullable) is None
        # and model_fields_set contains the field
        if self.ec_number is None and "ec_number" in self.model_fields_set:
            _dict['ec_number'] = None

        # set to None if chebi_id (nullable) is None
        # and model_fields_set contains the field
        if self.chebi_id is None and "chebi_id" in self.model_fields_set:
            _dict['chebi_id'] = None

        # set to None if chembl_id (nullable) is None
        # and model_fields_set contains the field
        if self.chembl_id is None and "chembl_id" in self.model_fields_set:
            _dict['chembl_id'] = None

        # set to None if dea_number (nullable) is None
        # and model_fields_set contains the field
        if self.dea_number is None and "dea_number" in self.model_fields_set:
            _dict['dea_number'] = None

        # set to None if drugbank_id (nullable) is None
        # and model_fields_set contains the field
        if self.drugbank_id is None and "drugbank_id" in self.model_fields_set:
            _dict['drugbank_id'] = None

        # set to None if dsstox_id (nullable) is None
        # and model_fields_set contains the field
        if self.dsstox_id is None and "dsstox_id" in self.model_fields_set:
            _dict['dsstox_id'] = None

        # set to None if hmdb_id (nullable) is None
        # and model_fields_set contains the field
        if self.hmdb_id is None and "hmdb_id" in self.model_fields_set:
            _dict['hmdb_id'] = None

        # set to None if kegg_id (nullable) is None
        # and model_fields_set contains the field
        if self.kegg_id is None and "kegg_id" in self.model_fields_set:
            _dict['kegg_id'] = None

        # set to None if metabolomics_wb_id (nullable) is None
        # and model_fields_set contains the field
        if self.metabolomics_wb_id is None and "metabolomics_wb_id" in self.model_fields_set:
            _dict['metabolomics_wb_id'] = None

        # set to None if nci_code (nullable) is None
        # and model_fields_set contains the field
        if self.nci_code is None and "nci_code" in self.model_fields_set:
            _dict['nci_code'] = None

        # set to None if nikkaji_number (nullable) is None
        # and model_fields_set contains the field
        if self.nikkaji_number is None and "nikkaji_number" in self.model_fields_set:
            _dict['nikkaji_number'] = None

        # set to None if pharmgkb_id (nullable) is None
        # and model_fields_set contains the field
        if self.pharmgkb_id is None and "pharmgkb_id" in self.model_fields_set:
            _dict['pharmgkb_id'] = None

        # set to None if pharos_ligand_id (nullable) is None
        # and model_fields_set contains the field
        if self.pharos_ligand_id is None and "pharos_ligand_id" in self.model_fields_set:
            _dict['pharos_ligand_id'] = None

        # set to None if rxcui (nullable) is None
        # and model_fields_set contains the field
        if self.rxcui is None and "rxcui" in self.model_fields_set:
            _dict['rxcui'] = None

        # set to None if unii (nullable) is None
        # and model_fields_set contains the field
        if self.unii is None and "unii" in self.model_fields_set:
            _dict['unii'] = None

        # set to None if wikidata (nullable) is None
        # and model_fields_set contains the field
        if self.wikidata is None and "wikidata" in self.model_fields_set:
            _dict['wikidata'] = None

        # set to None if wikipedia (nullable) is None
        # and model_fields_set contains the field
        if self.wikipedia is None and "wikipedia" in self.model_fields_set:
            _dict['wikipedia'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Compound from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "modified_at": obj.get("modified_at"),
            "modified_by": obj.get("modified_by"),
            "userid": obj.get("userid"),
            "team": obj.get("team"),
            "state": obj.get("state"),
            "name": obj.get("name"),
            "molecular_formula": obj.get("molecular_formula"),
            "cas_number": obj.get("cas_number"),
            "ec_number": obj.get("ec_number"),
            "chebi_id": obj.get("chebi_id"),
            "chembl_id": obj.get("chembl_id"),
            "dea_number": obj.get("dea_number"),
            "drugbank_id": obj.get("drugbank_id"),
            "dsstox_id": obj.get("dsstox_id"),
            "hmdb_id": obj.get("hmdb_id"),
            "inchi": obj.get("inchi"),
            "inchi_key": obj.get("inchi_key"),
            "iupac_name": obj.get("iupac_name"),
            "kegg_id": obj.get("kegg_id"),
            "metabolomics_wb_id": obj.get("metabolomics_wb_id"),
            "molecular_weight": obj.get("molecular_weight"),
            "nci_code": obj.get("nci_code"),
            "nikkaji_number": obj.get("nikkaji_number"),
            "pharmgkb_id": obj.get("pharmgkb_id"),
            "pharos_ligand_id": obj.get("pharos_ligand_id"),
            "pubchem_cid": obj.get("pubchem_cid"),
            "rxcui": obj.get("rxcui"),
            "smiles": obj.get("smiles"),
            "unii": obj.get("unii"),
            "wikidata": obj.get("wikidata"),
            "wikipedia": obj.get("wikipedia"),
            "is_corrosive": obj.get("is_corrosive"),
            "is_explosive": obj.get("is_explosive"),
            "is_flammable": obj.get("is_flammable"),
            "is_gas_under_pressure": obj.get("is_gas_under_pressure"),
            "is_hazardous2env": obj.get("is_hazardous2env"),
            "is_hazardous2health": obj.get("is_hazardous2health"),
            "is_serious_health_hazard": obj.get("is_serious_health_hazard"),
            "is_oxidising": obj.get("is_oxidising"),
            "is_toxic": obj.get("is_toxic"),
            "is_radioactive": obj.get("is_radioactive"),
            "is_antibiotic": obj.get("is_antibiotic"),
            "is_antibiotic_precursor": obj.get("is_antibiotic_precursor"),
            "is_drug": obj.get("is_drug"),
            "is_drug_precursor": obj.get("is_drug_precursor"),
            "is_explosive_precursor": obj.get("is_explosive_precursor"),
            "is_cmr": obj.get("is_cmr"),
            "is_nano": obj.get("is_nano"),
            "is_controlled": obj.get("is_controlled"),
            "is_ed2health": obj.get("is_ed2health"),
            "is_ed2env": obj.get("is_ed2env"),
            "is_pbt": obj.get("is_pbt"),
            "is_pmt": obj.get("is_pmt"),
            "is_vpvb": obj.get("is_vpvb"),
            "is_vpvm": obj.get("is_vpvm"),
            "fp2_base64": obj.get("fp2_base64"),
            "userid_human": obj.get("userid_human"),
            "team_name": obj.get("team_name"),
            "has_fingerprint": obj.get("has_fingerprint")
        })
        return _obj


