# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from elabapi_python.models.comment import Comment
from elabapi_python.models.compound import Compound
from elabapi_python.models.exclusive_edit_mode import ExclusiveEditMode
from elabapi_python.models.link import Link
from elabapi_python.models.metadata import Metadata
from elabapi_python.models.step import Step
from elabapi_python.models.upload import Upload
from typing import Optional, Set
from typing_extensions import Self

class Experiment(BaseModel):
    """
    Experiment
    """ # noqa: E501
    body: Optional[StrictStr] = Field(default=None, description="The main text content (HTML or Markdown)")
    canread: Optional[StrictStr] = Field(default='{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}', description="JSON permissions for reading the entry")
    canwrite: Optional[StrictStr] = Field(default='{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}', description="JSON permissions for writing the entry")
    category: Optional[StrictInt] = Field(default=None, description="The experiment category ID")
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    content_type: Optional[StrictInt] = Field(default=None, description="Set the content type for main text: 1 for HTML (default) and 2 for Markdown ")
    custom_id: Optional[StrictInt] = Field(default=None, description="Cannot be negative. Can be reset with \"0\", null or empty string.")
    metadata: Optional[Metadata] = None
    rating: Optional[StrictInt] = Field(default=0, description="Rating value from 0 to 5")
    state: Optional[StrictInt] = None
    status: Optional[StrictInt] = Field(default=None, description="Cannot be negative nor empty string. Can be reset with \"0\" and null.")
    tags: Optional[StrictStr] = None
    title: Optional[StrictStr] = Field(default='Untitled', description="The title of the entry")
    template: Optional[StrictInt] = Field(default=-1, description="The template id to use, or 0 to use the common team template, or -1 to have an empty body. ")
    userid: Optional[StrictInt] = Field(default=None, description="Userid of entity's owner")
    access_key: Optional[StrictStr] = None
    body_html: Optional[StrictStr] = None
    category_color: Optional[StrictStr] = None
    category_title: Optional[StrictStr] = None
    comments: Optional[List[Comment]] = None
    compounds: Optional[List[Compound]] = None
    created_at: Optional[StrictStr] = None
    elabid: Optional[StrictStr] = None
    exclusive_edit_mode: Optional[ExclusiveEditMode] = None
    experiments_links: Optional[List[Link]] = None
    firstname: Optional[StrictStr] = None
    fullname: Optional[StrictStr] = None
    has_attachement: Optional[StrictInt] = None
    id: Optional[StrictInt] = None
    items_links: Optional[List[Link]] = None
    lastchangeby: Optional[StrictInt] = None
    lastname: Optional[StrictStr] = None
    locked: Optional[StrictInt] = None
    lockedby: Optional[StrictInt] = None
    locked_at: Optional[StrictStr] = None
    modified_at: Optional[StrictStr] = None
    next_step: Optional[StrictStr] = None
    orcid: Optional[StrictStr] = None
    page: Optional[StrictStr] = None
    recent_comment: Optional[StrictStr] = None
    related_experiments_links: Optional[List[Link]] = None
    related_items_links: Optional[List[Link]] = None
    sharelink: Optional[StrictStr] = None
    status_color: Optional[StrictStr] = None
    status_title: Optional[StrictStr] = None
    steps: Optional[List[Step]] = None
    tags_id: Optional[StrictStr] = None
    team: Optional[StrictInt] = None
    timestamped: Optional[StrictInt] = None
    timestampedby: Optional[StrictInt] = None
    timestamped_at: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    up_item_id: Optional[StrictInt] = None
    uploads: Optional[List[Upload]] = None
    __properties: ClassVar[List[str]] = ["body", "canread", "canwrite", "category", "date", "content_type", "custom_id", "metadata", "rating", "state", "status", "tags", "title", "template", "userid", "access_key", "body_html", "category_color", "category_title", "comments", "compounds", "created_at", "elabid", "exclusive_edit_mode", "experiments_links", "firstname", "fullname", "has_attachement", "id", "items_links", "lastchangeby", "lastname", "locked", "lockedby", "locked_at", "modified_at", "next_step", "orcid", "page", "recent_comment", "related_experiments_links", "related_items_links", "sharelink", "status_color", "status_title", "steps", "tags_id", "team", "timestamped", "timestampedby", "timestamped_at", "type", "up_item_id", "uploads"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Experiment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item_comments in self.comments:
                if _item_comments:
                    _items.append(_item_comments.to_dict())
            _dict['comments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in compounds (list)
        _items = []
        if self.compounds:
            for _item_compounds in self.compounds:
                if _item_compounds:
                    _items.append(_item_compounds.to_dict())
            _dict['compounds'] = _items
        # override the default output from pydantic by calling `to_dict()` of exclusive_edit_mode
        if self.exclusive_edit_mode:
            _dict['exclusive_edit_mode'] = self.exclusive_edit_mode.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in experiments_links (list)
        _items = []
        if self.experiments_links:
            for _item_experiments_links in self.experiments_links:
                if _item_experiments_links:
                    _items.append(_item_experiments_links.to_dict())
            _dict['experiments_links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items_links (list)
        _items = []
        if self.items_links:
            for _item_items_links in self.items_links:
                if _item_items_links:
                    _items.append(_item_items_links.to_dict())
            _dict['items_links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in related_experiments_links (list)
        _items = []
        if self.related_experiments_links:
            for _item_related_experiments_links in self.related_experiments_links:
                if _item_related_experiments_links:
                    _items.append(_item_related_experiments_links.to_dict())
            _dict['related_experiments_links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in related_items_links (list)
        _items = []
        if self.related_items_links:
            for _item_related_items_links in self.related_items_links:
                if _item_related_items_links:
                    _items.append(_item_related_items_links.to_dict())
            _dict['related_items_links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in uploads (list)
        _items = []
        if self.uploads:
            for _item_uploads in self.uploads:
                if _item_uploads:
                    _items.append(_item_uploads.to_dict())
            _dict['uploads'] = _items
        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if canread (nullable) is None
        # and model_fields_set contains the field
        if self.canread is None and "canread" in self.model_fields_set:
            _dict['canread'] = None

        # set to None if canwrite (nullable) is None
        # and model_fields_set contains the field
        if self.canwrite is None and "canwrite" in self.model_fields_set:
            _dict['canwrite'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if custom_id (nullable) is None
        # and model_fields_set contains the field
        if self.custom_id is None and "custom_id" in self.model_fields_set:
            _dict['custom_id'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if access_key (nullable) is None
        # and model_fields_set contains the field
        if self.access_key is None and "access_key" in self.model_fields_set:
            _dict['access_key'] = None

        # set to None if body_html (nullable) is None
        # and model_fields_set contains the field
        if self.body_html is None and "body_html" in self.model_fields_set:
            _dict['body_html'] = None

        # set to None if category_color (nullable) is None
        # and model_fields_set contains the field
        if self.category_color is None and "category_color" in self.model_fields_set:
            _dict['category_color'] = None

        # set to None if category_title (nullable) is None
        # and model_fields_set contains the field
        if self.category_title is None and "category_title" in self.model_fields_set:
            _dict['category_title'] = None

        # set to None if lastchangeby (nullable) is None
        # and model_fields_set contains the field
        if self.lastchangeby is None and "lastchangeby" in self.model_fields_set:
            _dict['lastchangeby'] = None

        # set to None if lockedby (nullable) is None
        # and model_fields_set contains the field
        if self.lockedby is None and "lockedby" in self.model_fields_set:
            _dict['lockedby'] = None

        # set to None if locked_at (nullable) is None
        # and model_fields_set contains the field
        if self.locked_at is None and "locked_at" in self.model_fields_set:
            _dict['locked_at'] = None

        # set to None if next_step (nullable) is None
        # and model_fields_set contains the field
        if self.next_step is None and "next_step" in self.model_fields_set:
            _dict['next_step'] = None

        # set to None if orcid (nullable) is None
        # and model_fields_set contains the field
        if self.orcid is None and "orcid" in self.model_fields_set:
            _dict['orcid'] = None

        # set to None if recent_comment (nullable) is None
        # and model_fields_set contains the field
        if self.recent_comment is None and "recent_comment" in self.model_fields_set:
            _dict['recent_comment'] = None

        # set to None if status_color (nullable) is None
        # and model_fields_set contains the field
        if self.status_color is None and "status_color" in self.model_fields_set:
            _dict['status_color'] = None

        # set to None if status_title (nullable) is None
        # and model_fields_set contains the field
        if self.status_title is None and "status_title" in self.model_fields_set:
            _dict['status_title'] = None

        # set to None if tags_id (nullable) is None
        # and model_fields_set contains the field
        if self.tags_id is None and "tags_id" in self.model_fields_set:
            _dict['tags_id'] = None

        # set to None if timestampedby (nullable) is None
        # and model_fields_set contains the field
        if self.timestampedby is None and "timestampedby" in self.model_fields_set:
            _dict['timestampedby'] = None

        # set to None if timestamped_at (nullable) is None
        # and model_fields_set contains the field
        if self.timestamped_at is None and "timestamped_at" in self.model_fields_set:
            _dict['timestamped_at'] = None

        # set to None if up_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.up_item_id is None and "up_item_id" in self.model_fields_set:
            _dict['up_item_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Experiment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "body": obj.get("body"),
            "canread": obj.get("canread") if obj.get("canread") is not None else '{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}',
            "canwrite": obj.get("canwrite") if obj.get("canwrite") is not None else '{"base": 20, "teams": [], "users": [1], "teamgroups": [1]}',
            "category": obj.get("category"),
            "date": obj.get("date"),
            "content_type": obj.get("content_type"),
            "custom_id": obj.get("custom_id"),
            "metadata": Metadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "rating": obj.get("rating") if obj.get("rating") is not None else 0,
            "state": obj.get("state"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "title": obj.get("title") if obj.get("title") is not None else 'Untitled',
            "template": obj.get("template") if obj.get("template") is not None else -1,
            "userid": obj.get("userid"),
            "access_key": obj.get("access_key"),
            "body_html": obj.get("body_html"),
            "category_color": obj.get("category_color"),
            "category_title": obj.get("category_title"),
            "comments": [Comment.from_dict(_item) for _item in obj["comments"]] if obj.get("comments") is not None else None,
            "compounds": [Compound.from_dict(_item) for _item in obj["compounds"]] if obj.get("compounds") is not None else None,
            "created_at": obj.get("created_at"),
            "elabid": obj.get("elabid"),
            "exclusive_edit_mode": ExclusiveEditMode.from_dict(obj["exclusive_edit_mode"]) if obj.get("exclusive_edit_mode") is not None else None,
            "experiments_links": [Link.from_dict(_item) for _item in obj["experiments_links"]] if obj.get("experiments_links") is not None else None,
            "firstname": obj.get("firstname"),
            "fullname": obj.get("fullname"),
            "has_attachement": obj.get("has_attachement"),
            "id": obj.get("id"),
            "items_links": [Link.from_dict(_item) for _item in obj["items_links"]] if obj.get("items_links") is not None else None,
            "lastchangeby": obj.get("lastchangeby"),
            "lastname": obj.get("lastname"),
            "locked": obj.get("locked"),
            "lockedby": obj.get("lockedby"),
            "locked_at": obj.get("locked_at"),
            "modified_at": obj.get("modified_at"),
            "next_step": obj.get("next_step"),
            "orcid": obj.get("orcid"),
            "page": obj.get("page"),
            "recent_comment": obj.get("recent_comment"),
            "related_experiments_links": [Link.from_dict(_item) for _item in obj["related_experiments_links"]] if obj.get("related_experiments_links") is not None else None,
            "related_items_links": [Link.from_dict(_item) for _item in obj["related_items_links"]] if obj.get("related_items_links") is not None else None,
            "sharelink": obj.get("sharelink"),
            "status_color": obj.get("status_color"),
            "status_title": obj.get("status_title"),
            "steps": [Step.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "tags_id": obj.get("tags_id"),
            "team": obj.get("team"),
            "timestamped": obj.get("timestamped"),
            "timestampedby": obj.get("timestampedby"),
            "timestamped_at": obj.get("timestamped_at"),
            "type": obj.get("type"),
            "up_item_id": obj.get("up_item_id"),
            "uploads": [Upload.from_dict(_item) for _item in obj["uploads"]] if obj.get("uploads") is not None else None
        })
        return _obj


