# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from elabapi_python.models.metadata_elabftw import MetadataElabftw
from elabapi_python.models.metadata_extra_fields_value import MetadataExtraFieldsValue
from typing import Optional, Set
from typing_extensions import Self

class Metadata(BaseModel):
    """
    The metadata is a JSON type attribute that is mainly used to hold the extra fields, but it can hold anything you want
    """ # noqa: E501
    elabftw: Optional[MetadataElabftw] = None
    extra_fields: Optional[Dict[str, Optional[MetadataExtraFieldsValue]]] = Field(default=None, description="See https://doc.elabftw.net/metadata.html#extra-fields-objects")
    __properties: ClassVar[List[str]] = ["elabftw", "extra_fields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Metadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of elabftw
        if self.elabftw:
            _dict['elabftw'] = self.elabftw.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in extra_fields (dict)
        _field_dict = {}
        if self.extra_fields:
            for _key_extra_fields in self.extra_fields:
                if self.extra_fields[_key_extra_fields]:
                    _field_dict[_key_extra_fields] = self.extra_fields[_key_extra_fields].to_dict()
            _dict['extra_fields'] = _field_dict
        # set to None if elabftw (nullable) is None
        # and model_fields_set contains the field
        if self.elabftw is None and "elabftw" in self.model_fields_set:
            _dict['elabftw'] = None

        # set to None if extra_fields (nullable) is None
        # and model_fields_set contains the field
        if self.extra_fields is None and "extra_fields" in self.model_fields_set:
            _dict['extra_fields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Metadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "elabftw": MetadataElabftw.from_dict(obj["elabftw"]) if obj.get("elabftw") is not None else None,
            "extra_fields": dict(
                (_k, MetadataExtraFieldsValue.from_dict(_v))
                for _k, _v in obj["extra_fields"].items()
            )
            if obj.get("extra_fields") is not None
            else None
        })
        return _obj


