# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from elabapi_python.models.metadata_elabftw_extra_fields_groups_inner import MetadataElabftwExtraFieldsGroupsInner
from typing import Optional, Set
from typing_extensions import Self

class MetadataElabftw(BaseModel):
    """
    MetadataElabftw
    """ # noqa: E501
    display_main_text: Optional[StrictBool] = Field(default=True, description="The main text will be hidden if set to false. Use it on templates to force the use of extra fields, and only them for the reports.")
    extra_fields_groups: Optional[List[MetadataElabftwExtraFieldsGroupsInner]] = Field(default=None, description="This array stores the extra fields groups")
    __properties: ClassVar[List[str]] = ["display_main_text", "extra_fields_groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetadataElabftw from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in extra_fields_groups (list)
        _items = []
        if self.extra_fields_groups:
            for _item_extra_fields_groups in self.extra_fields_groups:
                if _item_extra_fields_groups:
                    _items.append(_item_extra_fields_groups.to_dict())
            _dict['extra_fields_groups'] = _items
        # set to None if display_main_text (nullable) is None
        # and model_fields_set contains the field
        if self.display_main_text is None and "display_main_text" in self.model_fields_set:
            _dict['display_main_text'] = None

        # set to None if extra_fields_groups (nullable) is None
        # and model_fields_set contains the field
        if self.extra_fields_groups is None and "extra_fields_groups" in self.model_fields_set:
            _dict['extra_fields_groups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetadataElabftw from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "display_main_text": obj.get("display_main_text") if obj.get("display_main_text") is not None else True,
            "extra_fields_groups": [MetadataElabftwExtraFieldsGroupsInner.from_dict(_item) for _item in obj["extra_fields_groups"]] if obj.get("extra_fields_groups") is not None else None
        })
        return _obj


