# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PostExportRequest(BaseModel):
    """
    PostExportRequest
    """ # noqa: E501
    format: StrictStr = Field(description="File format for the export")
    experiments: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include experiments in the export")
    items: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include resources in the export")
    experiments_templates: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include experiments templates in the export")
    items_types: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include resources categories in the export")
    changelog: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include the changelog in PDF files")
    var_json: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to include a full JSON export in the ZIP archives", alias="json")
    pdfa: Optional[StrictStr] = Field(default=None, description="Set to \"on\" to create PDF files with the PDF/A specification")
    __properties: ClassVar[List[str]] = ["format", "experiments", "items", "experiments_templates", "items_types", "changelog", "json", "pdfa"]

    @field_validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['csv', 'eln', 'json', 'pdf', 'zip']):
            raise ValueError("must be one of enum values ('csv', 'eln', 'json', 'pdf', 'zip')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostExportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostExportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "format": obj.get("format"),
            "experiments": obj.get("experiments"),
            "items": obj.get("items"),
            "experiments_templates": obj.get("experiments_templates"),
            "items_types": obj.get("items_types"),
            "changelog": obj.get("changelog"),
            "json": obj.get("json"),
            "pdfa": obj.get("pdfa")
        })
        return _obj


