# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Team(BaseModel):
    """
    Team
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    common_template: Optional[StrictStr] = None
    common_template_md: Optional[StrictStr] = None
    user_create_tag: Optional[StrictInt] = None
    force_exp_tpl: Optional[StrictInt] = None
    created_at: Optional[StrictStr] = None
    orgid: Optional[StrictStr] = None
    visible: Optional[StrictInt] = None
    announcement: Optional[StrictStr] = Field(default=None, description="Text shown on top of every page for all users of this team.")
    onboarding_email_active: Optional[StrictInt] = Field(default=None, description="Do we send onboarding emails to new users?")
    onboarding_email_body: Optional[StrictStr] = None
    onboarding_email_subject: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "common_template", "common_template_md", "user_create_tag", "force_exp_tpl", "created_at", "orgid", "visible", "announcement", "onboarding_email_active", "onboarding_email_body", "onboarding_email_subject"]

    @field_validator('onboarding_email_active')
    def onboarding_email_active_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([0, 1]):
            raise ValueError("must be one of enum values (0, 1)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Team from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if announcement (nullable) is None
        # and model_fields_set contains the field
        if self.announcement is None and "announcement" in self.model_fields_set:
            _dict['announcement'] = None

        # set to None if onboarding_email_body (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_email_body is None and "onboarding_email_body" in self.model_fields_set:
            _dict['onboarding_email_body'] = None

        # set to None if onboarding_email_subject (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_email_subject is None and "onboarding_email_subject" in self.model_fields_set:
            _dict['onboarding_email_subject'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Team from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "common_template": obj.get("common_template"),
            "common_template_md": obj.get("common_template_md"),
            "user_create_tag": obj.get("user_create_tag"),
            "force_exp_tpl": obj.get("force_exp_tpl"),
            "created_at": obj.get("created_at"),
            "orgid": obj.get("orgid"),
            "visible": obj.get("visible"),
            "announcement": obj.get("announcement"),
            "onboarding_email_active": obj.get("onboarding_email_active"),
            "onboarding_email_body": obj.get("onboarding_email_body"),
            "onboarding_email_subject": obj.get("onboarding_email_subject")
        })
        return _obj


