# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2. 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Upload(BaseModel):
    """
    Upload
    """ # noqa: E501
    id: Optional[StrictInt] = None
    real_name: Optional[StrictStr] = None
    long_name: Optional[StrictStr] = None
    comment: Optional[StrictStr] = None
    item_id: Optional[StrictInt] = None
    userid: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    hash: Optional[StrictStr] = None
    hash_algorithm: Optional[StrictStr] = None
    storage: Optional[StrictInt] = None
    filesize: Optional[StrictInt] = None
    state: Optional[StrictInt] = None
    immutable: Optional[StrictInt] = None
    fullname: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "real_name", "long_name", "comment", "item_id", "userid", "type", "created_at", "hash", "hash_algorithm", "storage", "filesize", "state", "immutable", "fullname"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Upload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Upload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "real_name": obj.get("real_name"),
            "long_name": obj.get("long_name"),
            "comment": obj.get("comment"),
            "item_id": obj.get("item_id"),
            "userid": obj.get("userid"),
            "type": obj.get("type"),
            "created_at": obj.get("created_at"),
            "hash": obj.get("hash"),
            "hash_algorithm": obj.get("hash_algorithm"),
            "storage": obj.get("storage"),
            "filesize": obj.get("filesize"),
            "state": obj.get("state"),
            "immutable": obj.get("immutable"),
            "fullname": obj.get("fullname")
        })
        return _obj


