# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    This document describes all available endpoints and methods for eLabFTW's API version 2.   # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from elabapi_python.api_client import ApiClient


class ExperimentsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_experiment(self, id, **kwargs):  # noqa: E501
        """Delete an experiment.  # noqa: E501

        The experiment gets soft-deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_experiment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_experiment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_experiment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_experiment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an experiment.  # noqa: E501

        The experiment gets soft-deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_experiment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_experiment(self, id, **kwargs):  # noqa: E501
        """Read an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_experiment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :param str format: Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". 
        :param bool json: Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). 
        :param bool with_title: Include the title in the QR code. Only applicable if format is qrpng. 
        :param int size: Specify the size of the QR code in pixels. Only applicable if format is qrpng. 
        :param bool changelog: Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. 
        :return: Entity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_experiment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_experiment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_experiment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Read an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_experiment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :param str format: Get the entity in a different format like csv, pdf, eln or zip. \"pdfa\" means archive pdf (PDF/A), same with \"zipa\". 
        :param bool json: Include a full JSON export in the ZIP archive. Only applicable if format is zip(a). 
        :param bool with_title: Include the title in the QR code. Only applicable if format is qrpng. 
        :param int size: Specify the size of the QR code in pixels. Only applicable if format is qrpng. 
        :param bool changelog: Toggles if the changelog should be included in PDF exports (pdf, pdfa, zip, zipa). Changelog is by default included if the export provides PDF/A, otherwise not. 
        :return: Entity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'format', 'json', 'with_title', 'size', 'changelog']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'json' in params:
            query_params.append(('json', params['json']))  # noqa: E501
        if 'with_title' in params:
            query_params.append(('withTitle', params['with_title']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'changelog' in params:
            query_params.append(('changelog', params['changelog']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_experiment(self, id, **kwargs):  # noqa: E501
        """Modify an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_experiment(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :param ExperimentsIdBody1 body: Parameters for patching an experiment
        :return: Experiment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_experiment_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_experiment_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def patch_experiment_with_http_info(self, id, **kwargs):  # noqa: E501
        """Modify an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_experiment_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: ID of the experiment (required)
        :param ExperimentsIdBody1 body: Parameters for patching an experiment
        :return: Experiment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Experiment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_experiment(self, **kwargs):  # noqa: E501
        """Create an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_experiment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExperimentsBody body: Parameters for creating an experiment
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_experiment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_experiment_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_experiment_with_http_info(self, **kwargs):  # noqa: E501
        """Create an experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_experiment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExperimentsBody body: Parameters for creating an experiment
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_experiment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_experiment_by_id(self, id, **kwargs):  # noqa: E501
        """Duplicate an experiment with its ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_experiment_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The unique identifier of the experiment to duplicate. (required)
        :param ExperimentsIdBody body: Parameters for duplicating an experiment
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_experiment_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_experiment_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def post_experiment_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Duplicate an experiment with its ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_experiment_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The unique identifier of the experiment to duplicate. (required)
        :param ExperimentsIdBody body: Parameters for duplicating an experiment
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_experiment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_experiment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments/{id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_experiments(self, **kwargs):  # noqa: E501
        """Read all experiments that are accessible  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_experiments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: Search for a term in title, body or elabid. 
        :param str extended: Extended search (advanced query). 
        :param int related: Look only for entries linked to this entry id. 
        :param str related_origin: When using the \"related\" query parameter, select the type of the related ID (experiments or items) 
        :param str cat: Add a filter on the Category. Supports comma separated list of numbers, including \"null\". 
        :param str status: Add a filter on the Status. Supports comma separated list of numbers, including \"null\". 
        :param list[str] tags: An array of tags for filtering results containing all of these tags. 
        :param int limit: Limit the number of results. 
        :param int offset: Skip a number of results. Use with limit to work the pagination. 
        :param str owner: Filter results by author (user id) 
        :param int scope: Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. 
        :param str order: Change the ordering of the results. 
        :param str sort: Change the sorting of results: ascending or descending. 
        :param str state: Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. 
        :return: list[Experiment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_experiments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.read_experiments_with_http_info(**kwargs)  # noqa: E501
            return data

    def read_experiments_with_http_info(self, **kwargs):  # noqa: E501
        """Read all experiments that are accessible  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_experiments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: Search for a term in title, body or elabid. 
        :param str extended: Extended search (advanced query). 
        :param int related: Look only for entries linked to this entry id. 
        :param str related_origin: When using the \"related\" query parameter, select the type of the related ID (experiments or items) 
        :param str cat: Add a filter on the Category. Supports comma separated list of numbers, including \"null\". 
        :param str status: Add a filter on the Status. Supports comma separated list of numbers, including \"null\". 
        :param list[str] tags: An array of tags for filtering results containing all of these tags. 
        :param int limit: Limit the number of results. 
        :param int offset: Skip a number of results. Use with limit to work the pagination. 
        :param str owner: Filter results by author (user id) 
        :param int scope: Set the scope for the results. 1: self, 2: team, 3: everything. It defaults to the user value stored in preferences. 
        :param str order: Change the ordering of the results. 
        :param str sort: Change the sorting of results: ascending or descending. 
        :param str state: Filter results based on their state: 1 (Normal), 2 (Archived), 3 (Deleted). Supports comma separated values. 
        :return: list[Experiment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['q', 'extended', 'related', 'related_origin', 'cat', 'status', 'tags', 'limit', 'offset', 'owner', 'scope', 'order', 'sort', 'state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_experiments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501
        if 'related' in params:
            query_params.append(('related', params['related']))  # noqa: E501
        if 'related_origin' in params:
            query_params.append(('related_origin', params['related_origin']))  # noqa: E501
        if 'cat' in params:
            query_params.append(('cat', params['cat']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'tags' in params:
            query_params.append(('tags[]', params['tags']))  # noqa: E501
            collection_formats['tags[]'] = 'multi'  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'owner' in params:
            query_params.append(('owner', params['owner']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/experiments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Experiment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
