from __future__ import annotations

from typing import NamedTuple


class PublicKey(NamedTuple):
    m: int
    e: int


server_public_keys = {
    0xC3B42B026CE86B21 - (1 << 64): PublicKey(
        int(
            "C150023E2F70DB7985DED064759CFECF0AF328E69A41DAF4D6F01B538135A6F9"
            "1F8F8B2A0EC9BA9720CE352EFCF6C5680FFC424BD634864902DE0B4BD6D49F4E"
            "580230E3AE97D95C8B19442B3C0A10D8F5633FECEDD6926A7F6DAB0DDB7D457F"
            "9EA81B8465FCD6FFFEED114011DF91C059CAEDAF97625F6C96ECC74725556934"
            "EF781D866B34F011FCE4D835A090196E9A5F0E4449AF7EB697DDB9076494CA5F"
            "81104A305B6DD27665722C46B60E5DF680FB16B210607EF217652E60236C255F"
            "6A28315F4083A96791D7214BF64C1DF4FD0DB1944FB26A2A57031B32EEE64AD1"
            "5A8BA68885CDE74A5BFC920F6ABF59BA5C75506373E7130F9042DA922179251F",
            16,
        ),
        int("010001", 16),
    ),
    0x10BC35F3509F7B7A5 - (1 << 64): PublicKey(
        int(
            "AEEC36C8FFC109CB099624685B97815415657BD76D8C9C3E398103D7AD16C9BB"
            "A6F525ED0412D7AE2C2DE2B44E77D72CBF4B7438709A4E646A05C43427C7F184"
            "DEBF72947519680E651500890C6832796DD11F772C25FF8F576755AFE055B0A3"
            "752C696EB7D8DA0D8BE1FAF38C9BDD97CE0A77D3916230C4032167100EDD0F9E"
            "7A3A9B602D04367B689536AF0D64B613CCBA7962939D3B57682BEB6DAE5B6081"
            "30B2E52ACA78BA023CF6CE806B1DC49C72CF928A7199D22E3D7AC84E47BC9427"
            "D0236945D10DBD15177BAB413FBF0EDFDA09F014C7A7DA088DDE9759702CA760"
            "AF2B8E4E97CC055C617BD74C3D97008635B98DC4D621B4891DA9FB0473047927",
            16,
        ),
        int("010001", 16),
    ),
    0x115AE5FA8B5529542 - (1 << 64): PublicKey(
        int(
            "BDF2C77D81F6AFD47BD30F29AC76E55ADFE70E487E5E48297E5A9055C9C07D2B"
            "93B4ED3994D3ECA5098BF18D978D54F8B7C713EB10247607E69AF9EF44F38E28"
            "F8B439F257A11572945CC0406FE3F37BB92B79112DB69EEDF2DC71584A661638"
            "EA5BECB9E23585074B80D57D9F5710DD30D2DA940E0ADA2F1B878397DC1A72B5"
            "CE2531B6F7DD158E09C828D03450CA0FF8A174DEACEBCAA22DDE84EF66AD370F"
            "259D18AF806638012DA0CA4A70BAA83D9C158F3552BC9158E69BF332A45809E1"
            "C36905A5CAA12348DD57941A482131BE7B2355A5F4635374F3BD3DDF5FF925BF"
            "4809EE27C1E67D9120C5FE08A9DE458B1B4A3C5D0A428437F2BECA81F4E2D5FF",
            16,
        ),
        int("010001", 16),
    ),
    0xAEAE98E13CD7F94F - (1 << 64): PublicKey(
        int(
            "B3F762B739BE98F343EB1921CF0148CFA27FF7AF02B6471213FED9DAA0098976"
            "E667750324F1ABCEA4C31E43B7D11F1579133F2B3D9FE27474E462058884E5E1"
            "B123BE9CBBC6A443B2925C08520E7325E6F1A6D50E117EB61EA49D2534C8BB4D"
            "2AE4153FABE832B9EDF4C5755FDD8B19940B81D1D96CF433D19E6A22968A85DC"
            "80F0312F596BD2530C1CFB28B5FE019AC9BC25CD9C2A5D8A0F3A1C0C79BCCA52"
            "4D315B5E21B5C26B46BABE3D75D06D1CD33329EC782A0F22891ED1DB42A1D6C0"
            "DEA431428BC4D7AABDCF3E0EB6FDA4E23EB7733E7727E9A1915580796C55188D"
            "2596D2665AD1182BA7ABF15AAA5A8B779EA996317A20AE044B820BFF35B6E8A1",
            16,
        ),
        int("010001", 16),
    ),
    0x15A181B2235057D98 - (1 << 64): PublicKey(
        int(
            "BE6A71558EE577FF03023CFA17AAB4E6C86383CFF8A7AD38EDB9FAFE6F323F2D"
            "5106CBC8CAFB83B869CFFD1CCF121CD743D509E589E68765C96601E813DC5B9D"
            "FC4BE415C7A6526132D0035CA33D6D6075D4F535122A1CDFE017041F1088D141"
            "9F65C8E5490EE613E16DBF662698C0F54870F0475FA893FC41EB55B08FF1AC21"
            "1BC045DED31BE27D12C96D8D3CFC6A7AE8AA50BF2EE0F30ED507CC2581E3DEC5"
            "6DE94F5DC0A7ABEE0BE990B893F2887BD2C6310A1E0A9E3E38BD34FDED254150"
            "8DC102A9C9B4C95EFFD9DD2DFE96C29BE647D6C69D66CA500843CFAED6E44019"
            "6F1DBE0E2E22163C61CA48C79116FA77216726749A976A1C4B0944B5121E8C01",
            16,
        ),
        int("010001", 16),
    ),
    0x995EFFD323B5DB80 - (1 << 64): PublicKey(
        int(
            "E2D587706265125931BB129027016325ABA59951E0771340DF0808D84F176CD9"
            "C0F3CCB9D57A205799BC04462E4D23F89655D9638652256E559455E79AC253FE"
            "19A3C9E16AA936A3C805BA9DBF6FC195F6F7542FA83FF5642141CBB4CBBC2334"
            "95B34812170B31FDF7655F007AD2C077EB912C5E901E8B32B39C34889EF1F946"
            "C6C03C727DE89CF042499EC29A5EB50EC11C9C31137E57FCC3C926B4118975BB"
            "5101D4C0D7D7F8C857521011B2EF7411F8BEC55354475628797339C1734FDA97"
            "FE0F1789B08F8872C9BEA41BF215626EFB3D35A00DC8295C044B7798EB9C1B5F"
            "F8E8B8A591CFCA7789E509CA219348C81CDA7CB32994CCD5913D41A64ECDD23F",
            16,
        ),
        int("010001", 16),
    ),
    0x1254672538E935938 - (1 << 64): PublicKey(
        int(
            "CEE1D50BBB04E742A1A3FC83559B569E5980E417FF68CF0A658DD6CD2D7AC3AC"
            "35B01AA2A63F2880C186ED42DB181B5898A11A23B20824EE963369B531A5D59E"
            "CA92F1DECF6860198B2F2B48DDD2ED2D9AF30A7845765E86CD09017BD9788CF8"
            "E6207208C05FC9C6C92A64B079891EB11508EE150EF1E4219A6FD4614129258E"
            "D53ADD087A68AE5114A9AA5450D8595CC876A161435CBDB2026F8FBF00FEDCA0"
            "A067E9C079172CCCECC09C2B16C428EC776373149DB66AAB9A4DEBF7916B391E"
            "832AE5A7892E27DE0AB1B4451C55F90F1F2ECE3ACEF708BC2C5EE022066EE434"
            "4C7268D724AABAAC667667D727AC3F2956ED4BDAF7089DDE0AEB18A6652DA16F",
            16,
        ),
        int("010001", 16),
    ),
    0xC884B3E62D09E5C5 - (1 << 64): PublicKey(
        int(
            "BA0E9F11355BECD917618BB9B9E66E334A6AC3585EBAA52B64D628990374952D"
            "28EE2EA6016C1BD7F162B1C14AFB2E0B412484C7EA14CD70218E6965F5F99BE1"
            "EECF6D4897A3C32E5CED118F77B9E35E835DF4E23981965E5151574690CEEF1A"
            "832D5EA4AC2414389D9E6CBB839AC9255D2AD7EDDE47E264D8E11CFC1EA53003"
            "AFDDF054EB1844641C8DF60A9CE9FBE4368D773D0F096195121ADB732E5632EF"
            "AB859AF141851B0953E2CD436F9BB131F069F49F7D56256766E824E6E5BEA6D1"
            "59EE39DC2CECB1A496CB0197390996BD56C47BB17CAB5922FECED2F01C585AB8"
            "522C9E9BB2EF556569C81C3F6F077E1017C20004F444F779A108E1C1A89C5205",
            16,
        ),
        int("010001", 16),
    ),
    0xBB27580FD5B01626 - (1 << 64): PublicKey(
        int(
            "BFF2FAB5DFA68FB0E5F353477EEF977F528DB6F64F475B52E7116A92252CA27D"
            "6EEC3DAE94AD398CCF072AFA55D68FB51CF3EA85A5E16ACBEC5FDD2EDD320745"
            "0D33B89289C4A022668DC62BBA611E8CE3009F555056CEEE32806B905313DB57"
            "800E59C090224166F753ACA4C11CE4DDF1517B959A5BBC5F55489EA71C9619DA"
            "F579E7285827C169FD530977DC4BBBDCCA58CD4F4DE9C2DD98C92E625C4E4807"
            "9C01079CAA4929B8198B56591EBB52322C5C177BED34697E82C6A5F39D507C41"
            "CF86528FC0FBEA6D73969203E49DA917A6C7E3E642CF4494A6FDE3EDB13C5859"
            "6F80C7F010F870C4C62275119ACAAF5894B9587780FE628AB453A8D2DCC59345",
            16,
        ),
        int("010001", 16),
    ),
}


def encrypt(data: bytes, fingerprint: int) -> bytes:
    return pow(
        int.from_bytes(data, "big"),
        server_public_keys[fingerprint].e,
        server_public_keys[fingerprint].m,
    ).to_bytes(256, "big")
