# Elepay Python SDK
elepay APIはRESTをベースに構成された決済APIです。支払い処理、返金処理など、決済に関わる運用における様々なことができます。

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.2.0
- SDK version: 1.2.0

For more information, please visit [Elepay Homepage](https://elepay.io) and [API Reference][apiref]

## Installation
### pip install (Recommended)

```sh
pip install elepay-python-sdk==1.2.0
```

If it is failed by root permission, try `sudo pip install elepay-python-sdk==1.2.0`.

### pip install from GitHub

Install from this repository directly using:

```sh
pip install git+https://github.com/elestyle/elepay-python-sdk.git@v1.2.0
```
(you may need to run `pip` with root permission)

### Setuptools (Not recommended)

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

Clone this repository and installed by `setup.py`:

```sh
git clone https://github.com/elestyle/elepay-python-sdk.git
cd elepay-python-sdk
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Requirements.

Python &gt;&#x3D;3.7

## Rules of SDK Generation

1. The SDK Generator uses spec case for all (object) property names and parameter names.
    - If the spec has a property name like `paymentMethod`, it will keep to use `paymentMethod` instead of `payment_method`
    - It will be easy to serialize / deserialize between Elepay API &lt;-&gt; Your Server &lt;-&gt; Your Client
2. Endpoint request parameters should be assigned to different arguments
    - Query parameters should be assigned to `query_params`, like `charge_api.list_charges(query_params={"paymentMethod": someMethods})`
    - Path parameters should be assigned to `path_params`
    - Body should be assigned to `body`
    - etc. See also each schema of endpoint parameters and [Elepay API Reference][apiref].
3. Endpoint responses include the original `urllib3.HTTPResponse` and deserialized response body
    - Use `response.body` to access deserialized data
    - Use `response.response` to access original `urllib3.HTTPResponse`
4. All deserialized data is instantiated in an instance that subclasses all validated `Schema` classes and `Decimal` / `str` / `list` / `tuple` / `frozendict` / `NoneClass` / `BoolClass` / `bytes` / `io.FileIO`
    - This means that you can use `isinstance` to check if a payload validated against a schema class
    - This means that no data will be of type `None` / `True` / `False`
        - Ingested `None` will subclass `NoneClass`
        - Ingested `True` will subclass `BoolClass`
        - Ingested `False` will subclass `BoolClass`
        - Use `instance.is_true_oapg()` / `.is_false_oapg()` / `.is_none_oapg()` to check if `instance` is `None` / `True` / `False`
5. All validated class instances are immutable
    - Please do not change values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See `.as_date_oapg`, `.as_datetime_oapg`, `.as_decimal_oapg`, `.as_uuid_oapg`
    - type number + format: See `.as_float_oapg`, `.as_int_oapg`
    - this was done because openapi / json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - Use `as_date_oapg` / `as_datetime_oapg` / `as_decimal_oapg` / `as_uuid_oapg` to access a string format based type
    - Use `as_int_oapg` / `as_float_oapg` to access a number format based type
7. Property access on `AnyType(unset)` or `object(dict)` schemas
    - Only required keys with valid python names are properties like `.someProp` and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with `dict_instance['optionalProp']` and `KeyError` will be raised if it does not exist
    - Use `get_item_oapg` if you need a way to always get a value whether or not the key exists
        - If the key does not exist, `schemas.unset` is returned from calling `dict_instance.get_item_oapg('optionalProp')`
        - If the key exist but the value is `None`, `NoneClass` will be returned
        - All required and optional keys have type hints for this method, and `@typing.overload` is used
        - A type hint is also generated for additional properties accessed using this method
    - Use `some_instance['optionalProp']` to access optional property and additional property values like `extra`
8. The location of the api classes
    - Package `elepay.apis.tag_to_api` will contain all APIs classes which is split by tag (Recommended)
    - Package `elepay.apis.tags` will contain each tag class
        - Example: `elepay.apis.tags.charge_api` will contain `ChargeApi`, which have been tagged as `charge`
    - Package `elepay.apis.path_to_api` will contain all APIs classes which is split by path (Not recommended)
    - See also [Note](#note) for more help if import fails
9. What is the `Oapg` and `_oapg`?
    - It is just a method / class postfix which is providered by SDK Generator
    - The OAPG stands for OpenApi Python Generator

## Getting Started

Please follow the [installation procedure](#installation) and then run the following:

```python
from pprint import pprint
from uuid import uuid4
from elepay import ApiException
from elepay.models import ChargeReq, PaymentMethodType, ResourceType, RefundReq
from elepay.apis.tag_to_api import ChargeApi # Or elepay.apis.tags.charge_api
from elepay.api_client import JSONEncoder, ApiClient, Configuration

# Defining the host is optional and defaults to https://api.elepay.io

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Simple to configure Elepay HTTP authorization:
configuration = Configuration('sk_live_******')

# Generate your order number, please use a unique id in your system
order_number=str(uuid4())

# Enter a context with an instance of the API client
# Should close it before exit
api_client = ApiClient(configuration)

# Create an instance of the API class
charge_api = ChargeApi(api_client)
# Request to create a simple charge, see API document or __new__ for a list of all supported parameters
charge_req = ChargeReq(
    amount=1500, # 1500, currency default is JPY, or set currency to other allowed values
    orderNo=order_number,
    paymentMethod=PaymentMethodType.CREDITCARD,
    resource=ResourceType.WEB, # Please make sure the client is running on the correct resource type
)

try:
    response = charge_api.create_charge(body=charge_req)
    # elepay.models.ChargeDto is the type of response.body 
    # bytes is the type of response.response.data which is also original body

    # Use response original body bytes like:
    original_body = response.response.data.decode("utf-8")
    # Or re-serialize response body like:
    json_body = JSONEncoder().encode(response.body)

    # Then return the original_body or json_body to client.
    # Example for Django with original body bytes:
    #   django.http.HttpResponse(content=response.response.data, content_type='application/json')
    # Or re-serialize:
    #   django.http.JsonResponse(data=response.body, encoder=JSONEncoder)
except ApiException as e:
    pprint("Exception when calling ChargeApi->create_charge: %s\n" % e)
```

The Elepay client SDK can handle the `ChargeDto` to invoke the payment popup.

## API Endpoints

See [Elepay API Reference][apiref].

## Author

[ELESTYLE, Inc.](https://elestyle.jp)

## Note
If the OpenAPI document is large, imports in `elepay.apis` and `elepay.models` may fail with a
`RecursionError` indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from elepay.apis.charge_api import ChargeApi`
- `from elepay.model.charge_req import ChargeReq`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```python
import sys

# Or some value else, default value should be 1000, but it may be different in some environments.
sys.setrecursionlimit(2000)

import elepay
from elepay.apis import *
from elepay.models import *
```

[apiref]: https://developer.elepay.io/reference
