# coding: utf-8

"""
    EmbedOps API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@embedops.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F40

# python 2 and python 3 compatibility library
import six

from embedops_cli.api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def check_provision_limit(self, repo_id, **kwargs):  # noqa: E501
        """check_provision_limit  # noqa: E501

        Check if another device can be provisioned   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_provision_limit(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.check_provision_limit_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.check_provision_limit_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def check_provision_limit_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """check_provision_limit  # noqa: E501

        Check if another device can be provisioned and provide download url for latest gateway image   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_provision_limit_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_provision_limit" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `check_provision_limit`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/hil/fleet-devices/check-device-limit",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_ci_run_from_ci(self, body, **kwargs):  # noqa: E501
        """create_ci_run_from_ci  # noqa: E501

        Create a ci run, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ci_run_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunCreateProps body: Data to create the CIRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_ci_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_ci_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_ci_run_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_ci_run_from_ci  # noqa: E501

        Create a ci run, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ci_run_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunCreateProps body: Data to create the CIRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ci_run_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_ci_run_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRun",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_group_for_org(self, body, org_id, **kwargs):  # noqa: E501
        """create_group_for_org  # noqa: E501

        Create a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group_for_org(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateProps body: Data to create the Group (required)
        :param str org_id: UUID of org (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_group_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_group_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
            return data

    def create_group_for_org_with_http_info(self, body, org_id, **kwargs):  # noqa: E501
        """create_group_for_org  # noqa: E501

        Create a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group_for_org_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateProps body: Data to create the Group (required)
        :param str org_id: UUID of org (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_group_for_org`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_group_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/groups",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Group",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_job_def(self, body, **kwargs):  # noqa: E501
        """create_job_def  # noqa: E501

        Create a job definition   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_job_def(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobDefCreateProps body: Data to create the JobDef (required)
        :return: JobDef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_job_def_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_job_def_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_job_def_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_job_def  # noqa: E501

        Create a job definition   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_job_def_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobDefCreateProps body: Data to create the JobDef (required)
        :return: JobDef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_job_def" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_job_def`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/pipeline-config/jobdefs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="JobDef",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_metric_from_ci(self, body, **kwargs):  # noqa: E501
        """create_metric_from_ci  # noqa: E501

        Create a metric for a cirun, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metric_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetricCreateProps body: Data to create the CIRun (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_metric_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_metric_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_metric_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_metric_from_ci  # noqa: E501

        Create a metric for a cirun, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metric_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetricCreateProps body: Data to create the CIRun (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_metric_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_metric_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/metrics",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Metric",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_org(self, body, **kwargs):  # noqa: E501
        """create_org  # noqa: E501

        Creates an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_org(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrgCreateProps body: Data to create the Org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_org_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_org_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_org_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_org  # noqa: E501

        Creates an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_org_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrgCreateProps body: Data to create the Org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Org",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_project(self, body, group_id, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Add a project to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupCreateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_project_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_project_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
            return data

    def create_project_with_http_info(self, body, group_id, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Add a project to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_with_http_info(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupCreateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_project`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `create_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_project_for_org(self, body, org_id, **kwargs):  # noqa: E501
        """create_project_for_org  # noqa: E501

        Create a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_for_org(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProps body: Data to create the Project (required)
        :param str org_id: UUID of org (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_project_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_project_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
            return data

    def create_project_for_org_with_http_info(
        self, body, org_id, **kwargs
    ):  # noqa: E501
        """create_project_for_org  # noqa: E501

        Create a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_for_org_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProps body: Data to create the Project (required)
        :param str org_id: UUID of org (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_project_for_org`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_project_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Project",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_release_from_ci(self, body, **kwargs):  # noqa: E501
        """create_release_from_ci  # noqa: E501

        Create a release   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReleaseCreateProps body: Data to create the Release (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_release_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_release_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_release_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_release_from_ci  # noqa: E501

        Create a release   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReleaseCreateProps body: Data to create the Release (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_release_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/releases",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Release",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_repo_for_project(self, body, org_id, project_id, **kwargs):  # noqa: E501
        """create_repo_for_project  # noqa: E501

        Create a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo_for_project(body, org_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoCreateProps body: Data to create the Repo (required)
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_repo_for_project_with_http_info(
                body, org_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_repo_for_project_with_http_info(
                body, org_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def create_repo_for_project_with_http_info(
        self, body, org_id, project_id, **kwargs
    ):  # noqa: E501
        """create_repo_for_project  # noqa: E501

        Create a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo_for_project_with_http_info(body, org_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoCreateProps body: Data to create the Repo (required)
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_repo_for_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_repo_for_project`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_repo_for_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `create_repo_for_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects/{projectId}/repos",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Repo",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_job_def(self, job_def_id, **kwargs):  # noqa: E501
        """delete_job_def  # noqa: E501

        Delete a jobdef   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_def(job_def_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_def_id: UUID of jobDef (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_job_def_with_http_info(
                job_def_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_job_def_with_http_info(
                job_def_id, **kwargs
            )  # noqa: E501
            return data

    def delete_job_def_with_http_info(self, job_def_id, **kwargs):  # noqa: E501
        """delete_job_def  # noqa: E501

        Delete a jobdef   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_job_def_with_http_info(job_def_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_def_id: UUID of jobDef (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["job_def_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_def" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'job_def_id' is set
        if "job_def_id" not in params or params["job_def_id"] is None:
            raise ValueError(
                "Missing the required parameter `job_def_id` when calling `delete_job_def`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "job_def_id" in params:
            path_params["jobDefId"] = params["job_def_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/pipeline-config/jobdefs/{jobDefId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_project(self, group_id, project_id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        Remove a project from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project(group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_project_with_http_info(
                group_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_project_with_http_info(
                group_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def delete_project_with_http_info(
        self, group_id, project_id, **kwargs
    ):  # noqa: E501
        """delete_project  # noqa: E501

        Remove a project from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_with_http_info(group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["group_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `delete_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `delete_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects/{projectId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_user(self, group_id, user_id, **kwargs):  # noqa: E501
        """delete_user  # noqa: E501

        Remove a user from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user(group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_user_with_http_info(
                group_id, user_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_user_with_http_info(
                group_id, user_id, **kwargs
            )  # noqa: E501
            return data

    def delete_user_with_http_info(self, group_id, user_id, **kwargs):  # noqa: E501
        """delete_user  # noqa: E501

        Remove a user from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_with_http_info(group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["group_id", "user_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `delete_user`"
            )  # noqa: E501
        # verify the required parameter 'user_id' is set
        if "user_id" not in params or params["user_id"] is None:
            raise ValueError(
                "Missing the required parameter `user_id` when calling `delete_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "user_id" in params:
            path_params["userId"] = params["user_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/users/{userId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_ci_runs(self, org_id, project_id, repo_id, **kwargs):  # noqa: E501
        """find_ci_runs  # noqa: E501

        Returns all ci runs in the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ci_runs(org_id, project_id, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :param str repo_id: UUID of repo (required)
        :param str branch:
        :param float count:
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_ci_runs_with_http_info(
                org_id, project_id, repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_ci_runs_with_http_info(
                org_id, project_id, repo_id, **kwargs
            )  # noqa: E501
            return data

    def find_ci_runs_with_http_info(
        self, org_id, project_id, repo_id, **kwargs
    ):  # noqa: E501
        """find_ci_runs  # noqa: E501

        Returns all ci runs in the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ci_runs_with_http_info(org_id, project_id, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :param str repo_id: UUID of repo (required)
        :param str branch:
        :param float count:
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "org_id",
            "project_id",
            "repo_id",
            "branch",
            "count",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ci_runs" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `find_ci_runs`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `find_ci_runs`"
            )  # noqa: E501
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `find_ci_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []
        if "branch" in params:
            query_params.append(("branch", params["branch"]))  # noqa: E501
        if "count" in params:
            query_params.append(("count", params["count"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects/{projectId}/repos/{repoId}/ci-runs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CIRun]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_job_defs(self, **kwargs):  # noqa: E501
        """find_job_defs  # noqa: E501

        Retrieve all jobdefs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_job_defs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_templates:
        :return: list[JobDef]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_job_defs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_job_defs_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_job_defs_with_http_info(self, **kwargs):  # noqa: E501
        """find_job_defs  # noqa: E501

        Retrieve all jobdefs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_job_defs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_templates:
        :return: list[JobDef]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["include_templates"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_job_defs" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "include_templates" in params:
            query_params.append(
                ("includeTemplates", params["include_templates"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/pipeline-config/jobdefs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[JobDef]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_metrics(self, **kwargs):  # noqa: E501
        """find_metrics  # noqa: E501

        Get metrics matching query   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_metrics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str repo_id:
        :param CIRunType ci_run_type:
        :param str branch:
        :param datetime created_at_begin:
        :param datetime created_at_end:
        :return: list[MetricResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_metrics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_metrics_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_metrics_with_http_info(self, **kwargs):  # noqa: E501
        """find_metrics  # noqa: E501

        Get metrics matching query   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_metrics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str repo_id:
        :param CIRunType ci_run_type:
        :param str branch:
        :param datetime created_at_begin:
        :param datetime created_at_end:
        :return: list[MetricResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "org_id",
            "project_id",
            "repo_id",
            "ci_run_type",
            "branch",
            "created_at_begin",
            "created_at_end",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_metrics" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "org_id" in params:
            query_params.append(("orgId", params["org_id"]))  # noqa: E501
        if "project_id" in params:
            query_params.append(("projectId", params["project_id"]))  # noqa: E501
        if "repo_id" in params:
            query_params.append(("repoId", params["repo_id"]))  # noqa: E501
        if "ci_run_type" in params:
            query_params.append(("ciRunType", params["ci_run_type"]))  # noqa: E501
        if "branch" in params:
            query_params.append(("branch", params["branch"]))  # noqa: E501
        if "created_at_begin" in params:
            query_params.append(
                ("createdAt[begin]", params["created_at_begin"])
            )  # noqa: E501
        if "created_at_end" in params:
            query_params.append(
                ("createdAt[end]", params["created_at_end"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/metrics",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[MetricResult]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_orgs(self, **kwargs):  # noqa: E501
        """find_orgs  # noqa: E501

        Returns all orgs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_orgs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Org]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_orgs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_orgs_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_orgs_with_http_info(self, **kwargs):  # noqa: E501
        """find_orgs  # noqa: E501

        Returns all orgs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_orgs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Org]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_orgs" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Org]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_projects_in_org(self, org_id, **kwargs):  # noqa: E501
        """find_projects_in_org  # noqa: E501

        Returns all projects in an org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_projects_in_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_projects_in_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_projects_in_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def find_projects_in_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """find_projects_in_org  # noqa: E501

        Returns all projects in an org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_projects_in_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_projects_in_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `find_projects_in_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Project]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_repo_api_keys(self, repo_id, **kwargs):  # noqa: E501
        """find_repo_api_keys  # noqa: E501

        Returns all apikeys for the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_repo_api_keys(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[RepoApiKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_repo_api_keys_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_repo_api_keys_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def find_repo_api_keys_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """find_repo_api_keys  # noqa: E501

        Returns all apikeys for the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_repo_api_keys_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[RepoApiKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_repo_api_keys" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `find_repo_api_keys`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/api-keys",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[RepoApiKey]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def generate_repo_pipeline_yaml(self, repo_id, **kwargs):  # noqa: E501
        """generate_repo_pipeline_yaml  # noqa: E501

        Generates the yaml for the repo's pipeline configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_repo_pipeline_yaml(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.generate_repo_pipeline_yaml_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.generate_repo_pipeline_yaml_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def generate_repo_pipeline_yaml_with_http_info(
        self, repo_id, **kwargs
    ):  # noqa: E501
        """generate_repo_pipeline_yaml  # noqa: E501

        Generates the yaml for the repo's pipeline configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_repo_pipeline_yaml_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_repo_pipeline_yaml" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `generate_repo_pipeline_yaml`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/pipeline-config/generate",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_aws_access_key_for_org(self, org_id, **kwargs):  # noqa: E501
        """get_aws_access_key_for_org  # noqa: E501

        Returns the aws access key and secret for the org, to access eotools images   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aws_access_key_for_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: AwsAccessKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_aws_access_key_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_aws_access_key_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def get_aws_access_key_for_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """get_aws_access_key_for_org  # noqa: E501

        Returns the aws access key and secret for the org, to access eotools images   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aws_access_key_for_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: AwsAccessKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aws_access_key_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_aws_access_key_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/access-key",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AwsAccessKey",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_groups_for_org(self, org_id, **kwargs):  # noqa: E501
        """get_groups_for_org  # noqa: E501

        Returns all groups for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups_for_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_groups_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_groups_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def get_groups_for_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """get_groups_for_org  # noqa: E501

        Returns all groups for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups_for_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_groups_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_groups_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/groups",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Group]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_my_user(self, **kwargs):  # noqa: E501
        """get_my_user  # noqa: E501

        Return the user model for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_my_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_user_with_http_info(self, **kwargs):  # noqa: E501
        """get_my_user  # noqa: E501

        Return the user model for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_user" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_my_user_ci_o_auth_tokens(self, **kwargs):  # noqa: E501
        """get_my_user_ci_o_auth_tokens  # noqa: E501

        Returns the CiOAuthToken id's for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user_ci_o_auth_tokens(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CiOAuthTokens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_my_user_ci_o_auth_tokens_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_my_user_ci_o_auth_tokens_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_my_user_ci_o_auth_tokens_with_http_info(self, **kwargs):  # noqa: E501
        """get_my_user_ci_o_auth_tokens  # noqa: E501

        Returns the CiOAuthToken id's for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user_ci_o_auth_tokens_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CiOAuthTokens
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_user_ci_o_auth_tokens" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself/ci-oauth-tokens",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CiOAuthTokens",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_org(self, org_id, **kwargs):  # noqa: E501
        """get_org  # noqa: E501

        Returns an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_org_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_org_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """get_org  # noqa: E501

        Returns an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method get_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Org",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_project(self, project_id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Returns a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: UUID of project (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Returns a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: UUID of project (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `get_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/projects/{projectId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Project",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_pre_signed_url_for_upload(self, repo_id, **kwargs):  # noqa: E501
        """get_pre_signed_url_for_upload  # noqa: E501

        Get pre-signed URL for upload of HIL Package   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_signed_url_for_upload(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_pre_signed_url_for_upload_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_pre_signed_url_for_upload_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def get_pre_signed_url_for_upload_with_http_info(
        self, repo_id, **kwargs
    ):  # noqa: E501
        """get_pre_signed_url_for_upload  # noqa: E501

        Get pre-signed URL for upload of HIL Package   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_signed_url_for_upload_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pre_signed_url_for_upload" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `get_pre_signed_url_for_upload`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/hil/pre-signed-url-for-upload",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse2001",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_pre_signed_url_for_upload_0(self, ci_run_id, **kwargs):  # noqa: E501
        """get_pre_signed_url_for_upload_0  # noqa: E501

        Get pre-signed URL for upload of HIL Package   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_signed_url_for_upload_0(ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ci_run_id: UUID of ciRun (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_pre_signed_url_for_upload_0_with_http_info(
                ci_run_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_pre_signed_url_for_upload_0_with_http_info(
                ci_run_id, **kwargs
            )  # noqa: E501
            return data

    def get_pre_signed_url_for_upload_0_with_http_info(
        self, ci_run_id, **kwargs
    ):  # noqa: E501
        """get_pre_signed_url_for_upload_0  # noqa: E501

        Get pre-signed URL for upload of HIL Package   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pre_signed_url_for_upload_0_with_http_info(ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ci_run_id: UUID of ciRun (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ci_run_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pre_signed_url_for_upload_0" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ci_run_id' is set
        if "ci_run_id" not in params or params["ci_run_id"] is None:
            raise ValueError(
                "Missing the required parameter `ci_run_id` when calling `get_pre_signed_url_for_upload_0`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_run_id" in params:
            path_params["ciRunId"] = params["ci_run_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs/{ciRunId}/hil/pre-signed-url-for-upload",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse2001",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_repo_fleet_devices(self, repo_id, **kwargs):  # noqa: E501
        """get_repo_fleet_devices  # noqa: E501

        Retrieves the devices in a fleet and their status   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_fleet_devices(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[FleetDevice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_repo_fleet_devices_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_repo_fleet_devices_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def get_repo_fleet_devices_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """get_repo_fleet_devices  # noqa: E501

        Retrieves the devices in a fleet and their status   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_fleet_devices_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[FleetDevice]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repo_fleet_devices" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `get_repo_fleet_devices`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/hil/fleet-devices",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[FleetDevice]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def hil_provision_device(self, repo_id, **kwargs):  # noqa: E501
        """hil_provision_device  # noqa: E501

        Provision a new device for the repo's fleet and get a URL for the OS image download   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.hil_provision_device(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.hil_provision_device_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.hil_provision_device_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def hil_provision_device_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """hil_provision_device  # noqa: E501

        Provision a new device for the repo's fleet and get a URL for the OS image download   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.hil_provision_device_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hil_provision_device" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `hil_provision_device`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/hil/provision-device",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse2002",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_latest_gateway_image_url(self, **kwargs):  # noqa: E501
        """get_latest_gateway_image_url  # noqa: E501

        Get a download URL for the latest gateway image   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_gateway_image_url(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_latest_gateway_image_url_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_latest_gateway_image_url_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_latest_gateway_image_url_with_http_info(self, **kwargs):  # noqa: E501
        """get_latest_gateway_image_url  # noqa: E501

        Get a download URL for the latest gateway image   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_gateway_image_url_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_gateway_image_url" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/fleets/get-latest-gateway-image-url",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse2001",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_repo(self, repo_id, **kwargs):  # noqa: E501
        """get_repo  # noqa: E501

        Returns a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_repo_with_http_info(repo_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repo_with_http_info(repo_id, **kwargs)  # noqa: E501
            return data

    def get_repo_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """get_repo  # noqa: E501

        Returns a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repo" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `get_repo`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Repo",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_repo_branches_from_ci_provider(
        self, ci_provider, repo, **kwargs
    ):  # noqa: E501
        """get_repo_branches_from_ci_provider  # noqa: E501

        Get branches for repo from CI Provider   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_branches_from_ci_provider(ci_provider, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIProvider ci_provider: CI Provider we want to perform action against (required)
        :param str repo: (required)
        :return: BranchNames
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_repo_branches_from_ci_provider_with_http_info(
                ci_provider, repo, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_repo_branches_from_ci_provider_with_http_info(
                ci_provider, repo, **kwargs
            )  # noqa: E501
            return data

    def get_repo_branches_from_ci_provider_with_http_info(
        self, ci_provider, repo, **kwargs
    ):  # noqa: E501
        """get_repo_branches_from_ci_provider  # noqa: E501

        Get branches for repo from CI Provider   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_branches_from_ci_provider_with_http_info(ci_provider, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIProvider ci_provider: CI Provider we want to perform action against (required)
        :param str repo: (required)
        :return: BranchNames
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ci_provider", "repo"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repo_branches_from_ci_provider" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ci_provider' is set
        if "ci_provider" not in params or params["ci_provider"] is None:
            raise ValueError(
                "Missing the required parameter `ci_provider` when calling `get_repo_branches_from_ci_provider`"
            )  # noqa: E501
        # verify the required parameter 'repo' is set
        if "repo" not in params or params["repo"] is None:
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_repo_branches_from_ci_provider`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_provider" in params:
            path_params["ciProvider"] = params["ci_provider"]  # noqa: E501

        query_params = []
        if "repo" in params:
            query_params.append(("repo", params["repo"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself/ci-providers/{ciProvider}/branches",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BranchNames",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_repo_pipeline_config(self, repo_id, **kwargs):  # noqa: E501
        """get_repo_pipeline_config  # noqa: E501

        Returns the pipeline configuration for a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_pipeline_config(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: RepoPipelineConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_repo_pipeline_config_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_repo_pipeline_config_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def get_repo_pipeline_config_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """get_repo_pipeline_config  # noqa: E501

        Returns the pipeline configuration for a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_pipeline_config_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: RepoPipelineConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repo_pipeline_config" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `get_repo_pipeline_config`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/pipeline-config",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="RepoPipelineConfig",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def init_hil_run_from_ci(self, body, **kwargs):  # noqa: E501
        """init_hil_run_from_ci  # noqa: E501

        Initialize a local HIL run for the given repository.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.init_hil_run_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HilRunCreateProps body: Data to create the HilRun (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.init_hil_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.init_hil_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def init_hil_run_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """init_hil_run_from_ci  # noqa: E501

        Initialize a local HIL run for the given repository.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.init_hil_run_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HilRunCreateProps body: Data to create the HilRun (required)
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method init_hil_run_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `init_hil_run_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/hil/hil-run",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse2001",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def invite_user(self, body, group_id, **kwargs):  # noqa: E501
        """invite_user  # noqa: E501

        Invite a user to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_user(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupInviteProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.invite_user_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.invite_user_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
            return data

    def invite_user_with_http_info(self, body, group_id, **kwargs):  # noqa: E501
        """invite_user  # noqa: E501

        Invite a user to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_user_with_http_info(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupInviteProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `invite_user`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `invite_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/invite-user",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def push_pipeline_config_to_provider(self, repo_id, **kwargs):  # noqa: E501
        """push_pipeline_config_to_provider  # noqa: E501

        Pushes Pipeline Configuration to Provider   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_pipeline_config_to_provider(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.push_pipeline_config_to_provider_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.push_pipeline_config_to_provider_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def push_pipeline_config_to_provider_with_http_info(
        self, repo_id, **kwargs
    ):  # noqa: E501
        """push_pipeline_config_to_provider  # noqa: E501

        Pushes Pipeline Configuration to Provider   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.push_pipeline_config_to_provider_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method push_pipeline_config_to_provider" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `push_pipeline_config_to_provider`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/pipeline-config/push",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def report_cli_telemetry(self, body, **kwargs):  # noqa: E501
        """report_cli_telemetry  # noqa: E501

        Capture user's CLI telemetry   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_cli_telemetry(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MyselfClitelemetryBody body: Data to report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.report_cli_telemetry_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.report_cli_telemetry_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def report_cli_telemetry_with_http_info(self, body, **kwargs):  # noqa: E501
        """report_cli_telemetry  # noqa: E501

        Capture user's CLI telemetry   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_cli_telemetry_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MyselfClitelemetryBody body: Data to report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method report_cli_telemetry" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `report_cli_telemetry`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself/cli-telemetry",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def save_repo_pipeline_config(self, body, repo_id, **kwargs):  # noqa: E501
        """save_repo_pipeline_config  # noqa: E501

        Create / Update the pipeline configuration for a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_repo_pipeline_config(body, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoPipelineConfigCreateProps body: Data to create the PipelineConfig (required)
        :param str repo_id: UUID of repo (required)
        :return: RepoPipelineConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.save_repo_pipeline_config_with_http_info(
                body, repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.save_repo_pipeline_config_with_http_info(
                body, repo_id, **kwargs
            )  # noqa: E501
            return data

    def save_repo_pipeline_config_with_http_info(
        self, body, repo_id, **kwargs
    ):  # noqa: E501
        """save_repo_pipeline_config  # noqa: E501

        Create / Update the pipeline configuration for a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_repo_pipeline_config_with_http_info(body, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoPipelineConfigCreateProps body: Data to create the PipelineConfig (required)
        :param str repo_id: UUID of repo (required)
        :return: RepoPipelineConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_repo_pipeline_config" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `save_repo_pipeline_config`"
            )  # noqa: E501
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `save_repo_pipeline_config`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/pipeline-config",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="RepoPipelineConfig",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_ci_run_from_ci(self, body, ci_run_id, **kwargs):  # noqa: E501
        """update_ci_run_from_ci  # noqa: E501

        Update a CIRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ci_run_from_ci(body, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunUpdateProps body: Data to update the CIRun (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_ci_run_from_ci_with_http_info(
                body, ci_run_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_ci_run_from_ci_with_http_info(
                body, ci_run_id, **kwargs
            )  # noqa: E501
            return data

    def update_ci_run_from_ci_with_http_info(
        self, body, ci_run_id, **kwargs
    ):  # noqa: E501
        """update_ci_run_from_ci  # noqa: E501

        Update a CIRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ci_run_from_ci_with_http_info(body, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunUpdateProps body: Data to update the CIRun (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "ci_run_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ci_run_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_ci_run_from_ci`"
            )  # noqa: E501
        # verify the required parameter 'ci_run_id' is set
        if "ci_run_id" not in params or params["ci_run_id"] is None:
            raise ValueError(
                "Missing the required parameter `ci_run_id` when calling `update_ci_run_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_run_id" in params:
            path_params["ciRunId"] = params["ci_run_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs/{ciRunId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRun",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_job_def(self, body, job_def_id, **kwargs):  # noqa: E501
        """update_job_def  # noqa: E501

        Update a job definition   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_def(body, job_def_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobDefCreateProps body: Data to update the JobDef (required)
        :param str job_def_id: UUID of jobDef (required)
        :return: JobDef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_job_def_with_http_info(
                body, job_def_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_job_def_with_http_info(
                body, job_def_id, **kwargs
            )  # noqa: E501
            return data

    def update_job_def_with_http_info(self, body, job_def_id, **kwargs):  # noqa: E501
        """update_job_def  # noqa: E501

        Update a job definition   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_def_with_http_info(body, job_def_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobDefCreateProps body: Data to update the JobDef (required)
        :param str job_def_id: UUID of jobDef (required)
        :return: JobDef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "job_def_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_def" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_job_def`"
            )  # noqa: E501
        # verify the required parameter 'job_def_id' is set
        if "job_def_id" not in params or params["job_def_id"] is None:
            raise ValueError(
                "Missing the required parameter `job_def_id` when calling `update_job_def`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "job_def_id" in params:
            path_params["jobDefId"] = params["job_def_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/pipeline-config/jobdefs/{jobDefId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="JobDef",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_job_template(self, body, job_def_id, provider, **kwargs):  # noqa: E501
        """update_job_template  # noqa: E501

        Update a job template   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_template(body, job_def_id, provider, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobTemplateUpdateProps body: Data to update the JobDef (required)
        :param str job_def_id: UUID of jobDef (required)
        :param CIProvider provider: CI provider name (required)
        :return: JobTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_job_template_with_http_info(
                body, job_def_id, provider, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_job_template_with_http_info(
                body, job_def_id, provider, **kwargs
            )  # noqa: E501
            return data

    def update_job_template_with_http_info(
        self, body, job_def_id, provider, **kwargs
    ):  # noqa: E501
        """update_job_template  # noqa: E501

        Update a job template   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_job_template_with_http_info(body, job_def_id, provider, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JobTemplateUpdateProps body: Data to update the JobDef (required)
        :param str job_def_id: UUID of jobDef (required)
        :param CIProvider provider: CI provider name (required)
        :return: JobTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "job_def_id", "provider"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_job_template" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_job_template`"
            )  # noqa: E501
        # verify the required parameter 'job_def_id' is set
        if "job_def_id" not in params or params["job_def_id"] is None:
            raise ValueError(
                "Missing the required parameter `job_def_id` when calling `update_job_template`"
            )  # noqa: E501
        # verify the required parameter 'provider' is set
        if "provider" not in params or params["provider"] is None:
            raise ValueError(
                "Missing the required parameter `provider` when calling `update_job_template`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "job_def_id" in params:
            path_params["jobDefId"] = params["job_def_id"]  # noqa: E501
        if "provider" in params:
            path_params["provider"] = params["provider"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/pipeline-config/jobdefs/{jobDefId}/templates/{provider}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="JobTemplate",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_my_user(self, **kwargs):  # noqa: E501
        """update_my_user  # noqa: E501

        Update the currently-authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_my_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.update_my_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def update_my_user_with_http_info(self, **kwargs):  # noqa: E501
        """update_my_user  # noqa: E501

        Update the currently-authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_my_user" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_my_user_ci_o_auth_token(self, body, **kwargs):  # noqa: E501
        """update_my_user_ci_o_auth_token  # noqa: E501

        Update the currently-authenticated user's CiOAuthToken   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_user_ci_o_auth_token(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CiOAuthTokenUpdateProps body: Data to integrate provider (required)
        :return: CiOAuthTokens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_my_user_ci_o_auth_token_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_my_user_ci_o_auth_token_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def update_my_user_ci_o_auth_token_with_http_info(
        self, body, **kwargs
    ):  # noqa: E501
        """update_my_user_ci_o_auth_token  # noqa: E501

        Update the currently-authenticated user's CiOAuthToken   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_user_ci_o_auth_token_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CiOAuthTokenUpdateProps body: Data to integrate provider (required)
        :return: CiOAuthTokens
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_my_user_ci_o_auth_token" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_my_user_ci_o_auth_token`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself/ci-oauth-tokens",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CiOAuthTokens",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_project(self, body, group_id, project_id, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        Edit a projects's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(body, group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupUpdateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_project_with_http_info(
                body, group_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(
                body, group_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def update_project_with_http_info(
        self, body, group_id, project_id, **kwargs
    ):  # noqa: E501
        """update_project  # noqa: E501

        Edit a projects's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(body, group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupUpdateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_project`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `update_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `update_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects/{projectId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_repo(self, body, repo_id, **kwargs):  # noqa: E501
        """update_repo  # noqa: E501

        Edit repository properties   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_repo(body, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoUpdateProps body: Data for the repo (required)
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_repo_with_http_info(
                body, repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_repo_with_http_info(
                body, repo_id, **kwargs
            )  # noqa: E501
            return data

    def update_repo_with_http_info(self, body, repo_id, **kwargs):  # noqa: E501
        """update_repo  # noqa: E501

        Edit repository properties   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_repo_with_http_info(body, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoUpdateProps body: Data for the repo (required)
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_repo" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_repo`"
            )  # noqa: E501
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `update_repo`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Repo",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_user(self, body, group_id, user_id, **kwargs):  # noqa: E501
        """update_user  # noqa: E501

        Edit a user's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user(body, group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupUpdateProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_user_with_http_info(
                body, group_id, user_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_user_with_http_info(
                body, group_id, user_id, **kwargs
            )  # noqa: E501
            return data

    def update_user_with_http_info(
        self, body, group_id, user_id, **kwargs
    ):  # noqa: E501
        """update_user  # noqa: E501

        Edit a user's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_with_http_info(body, group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupUpdateProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id", "user_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_user`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `update_user`"
            )  # noqa: E501
        # verify the required parameter 'user_id' is set
        if "user_id" not in params or params["user_id"] is None:
            raise ValueError(
                "Missing the required parameter `user_id` when calling `update_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "user_id" in params:
            path_params["userId"] = params["user_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/users/{userId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload_ci_run_artifact(self, type, data, ci_run_id, **kwargs):  # noqa: E501
        """upload_ci_run_artifact  # noqa: E501

        Upload a file to a ciRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ci_run_artifact(type, data, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str data: (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRunArtifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.upload_ci_run_artifact_with_http_info(
                type, data, ci_run_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.upload_ci_run_artifact_with_http_info(
                type, data, ci_run_id, **kwargs
            )  # noqa: E501
            return data

    def upload_ci_run_artifact_with_http_info(
        self, type, data, ci_run_id, **kwargs
    ):  # noqa: E501
        """upload_ci_run_artifact  # noqa: E501

        Upload a file to a ciRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ci_run_artifact_with_http_info(type, data, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str data: (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRunArtifact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "data", "ci_run_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_ci_run_artifact" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'type' is set
        if "type" not in params or params["type"] is None:
            raise ValueError(
                "Missing the required parameter `type` when calling `upload_ci_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'data' is set
        if "data" not in params or params["data"] is None:
            raise ValueError(
                "Missing the required parameter `data` when calling `upload_ci_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'ci_run_id' is set
        if "ci_run_id" not in params or params["ci_run_id"] is None:
            raise ValueError(
                "Missing the required parameter `ci_run_id` when calling `upload_ci_run_artifact`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_run_id" in params:
            path_params["ciRunId"] = params["ci_run_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "type" in params:
            form_params.append(("type", params["type"]))  # noqa: E501
        if "data" in params:
            local_var_files["data"] = params["data"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs/{ciRunId}/artifacts",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRunArtifact",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
