<div align="center">

# Engine CLI

### Stop Debugging AI Code. Ship Verified Features.

[![PyPI version](https://badge.fury.io/py/enginecli-dev.svg)](https://pypi.org/project/enginecli-dev/)
[![Python 3.9+](https://img.shields.io/badge/python-3.9+-blue.svg)](https://www.python.org/downloads/)
[![License](https://img.shields.io/badge/license-Proprietary-red.svg)](https://enginecli.dev/terms)

**Engine is a context-aware code generation CLI that generates complete, verified features—not just autocomplete suggestions.**

[Website](https://enginecli.dev) • [Documentation](https://enginecli.dev/docs) • [Pricing](https://enginecli.dev/#pricing)

</div>

---

## The Problem with AI Coding Tools

GitHub Copilot and Cursor are great for autocomplete, but they:
- ❌ Generate code that doesn't fit your codebase
- ❌ Require you to manually verify everything
- ❌ Can't be rolled back when things break
- ❌ Don't understand your project structure

**Engine is different.** It indexes your codebase, verifies its own output, and lets you instantly rollback if needed.

---

## 🎬 See It In Action

### Guided Task Selection
> Run `engine generate` without arguments for smart suggestions based on your project type.

![Guided Onboarding](https://enginecli.dev/assets/demo-onboarding.gif)

### Self-Verifying Code Generation
> Engine uses tools to check existing files, validate signatures, and lint code before applying.

![Tool Verification](https://enginecli.dev/assets/demo-verification.gif)

### Instant Rollback
> Every generation creates a snapshot. One command to undo.

![Rollback Demo](https://enginecli.dev/assets/demo-rollback.gif)

---

## ⚡ Quick Start

```bash
# Install
pip install enginecli-dev

# Start free trial (5 generations)
engine license trial your@email.com

# Index your project
cd your-project
engine index

# Generate your first feature
engine generate "Add JWT authentication with login and register endpoints"
```

**That's it.** Engine will:
1. Analyze your codebase structure
2. Generate files that match your patterns
3. Verify the code compiles and fits
4. Create a rollback snapshot
5. Apply the changes

---

## 🔥 Features

### 🎯 Context-Aware Generation
Engine indexes your codebase and understands your:
- File structure and naming conventions
- Existing models, services, and routes
- Import patterns and dependencies
- Code style and formatting

```bash
engine index              # Index your project
engine generate "..."     # Generations follow your patterns
```

### 🛡️ Self-Verifying Code
Before applying changes, Engine:
- ✅ Checks if referenced files exist
- ✅ Validates function signatures
- ✅ Lints generated code
- ✅ Ensures imports resolve

```
[🔧 check_file_exists] → ✓ File EXISTS: models/user.py
[🔧 get_function_signature] → Found: def create_user(...)
[🔧 lint_code] → ✓ Python syntax is valid
```

### ⏪ Instant Rollback
Every generation creates a snapshot. If something breaks:

```bash
engine rollback last      # Undo last generation
engine rollback list      # See all snapshots
engine rollback <id>      # Rollback to specific point
```

### 📊 Usage Tracking
See your generation usage after every command:

```
✓ Generated 8 file(s) (verified with 3 tool calls)
📊 Trial: 3/5 generations (2 remaining)
```

### 🚀 Guided Onboarding
Not sure what to build? Run without arguments:

```bash
engine generate

🚀 What would you like to build?

  1  🔐  Add JWT authentication with login/register endpoints
  2  📦  Create a new model with full CRUD API endpoints
  3  💳  Add Stripe payment webhook handler
  4  🛡️  Add rate limiting middleware
  5  🧪  Create comprehensive tests for existing endpoints

  c     ✏️   Enter custom task
```

---

## 📋 Commands

| Command | Description |
|---------|-------------|
| `engine index` | Index your codebase |
| `engine generate "task"` | Generate code for a task |
| `engine generate` | Interactive task selection |
| `engine rollback last` | Undo last generation |
| `engine rollback list` | List all snapshots |
| `engine status` | Show project and license status |
| `engine upgrade` | Upgrade your subscription |

---

## 🆚 Engine vs Other Tools

| Feature | Engine | GitHub Copilot | Cursor |
|---------|--------|----------------|--------|
| Multi-file generation | ✅ Complete features | ❌ Line-by-line | ⚠️ Limited |
| Context awareness | ✅ Full codebase index | ⚠️ Open files only | ⚠️ Open files only |
| Self-verification | ✅ Checks files, lints code | ❌ None | ❌ None |
| Instant rollback | ✅ One command | ❌ Manual git | ❌ Manual git |
| Predictable pricing | ✅ $39/mo flat | ✅ $19/mo | ❌ Usage-based |
| Works in terminal | ✅ Native CLI | ❌ IDE only | ❌ IDE only |

---

## 💰 Pricing

| | Free Trial | Pro | Team |
|---|------------|-----|------|
| **Price** | $0 | $39/mo | $119/mo |
| **Generations** | 5 total | 200/month | 500/month |
| **Rollback** | ✅ | ✅ | ✅ |
| **Tool Verification** | ✅ | ✅ | ✅ |
| **Shared Patterns** | ❌ | ❌ | ✅ |
| **Team Analytics** | ❌ | ❌ | ✅ |

[Start Free Trial →](https://enginecli.dev)

---

## 🛠️ Supported Languages

- ✅ Python (FastAPI, Django, Flask)
- ✅ TypeScript/JavaScript (React, Node.js, Next.js)
- 🔜 Go, Rust, Java (coming soon)

---

## 📖 Examples

### Add Authentication
```bash
engine generate "Add JWT authentication with user registration, login, and protected routes"
```

### Create a New Model
```bash
engine generate "Add a Project model with name, description, owner_id fields and full CRUD API"
```

### Add Tests
```bash
engine generate "Create pytest tests for the user authentication endpoints"
```

### Add Payment Integration
```bash
engine generate "Add Stripe webhook handler for subscription events"
```

---

## 🤔 FAQ

**Q: How is this different from ChatGPT or other AI assistants?**
> Engine indexes your codebase first, so it generates code that actually fits your project. It also verifies its output and provides instant rollback.

**Q: Does it work with my existing project?**
> Yes! Run `engine index` in any Python or TypeScript project. Engine will learn your patterns.

**Q: What if it generates bad code?**
> Every generation creates a snapshot. Run `engine rollback last` to instantly undo.

**Q: Do I need an API key?**
> No. Engine uses our hosted API. You just need a license key (free trial available).

---

## 🔒 Security

- Your code is sent to our API for context, but **never stored**
- All API communication is encrypted (TLS 1.3)
- License keys are tied to your machine
- [Privacy Policy](https://enginecli.dev/privacy) • [Terms of Service](https://enginecli.dev/terms)

---

## 📫 Support

- 🐛 [Report Issues](https://github.com/enginecli/engine-cli/issues)
- 💬 [Discord Community](https://discord.gg/enginecli)
- 📧 Email: hello@enginecli.dev

---

<div align="center">

**Built for developers who ship.**

[Get Started →](https://enginecli.dev)

</div>
