//! Proof generated by the prover in Sigma protocol

use ergotree_interpreter::sigma_protocol::prover::ProofBytes;
use ergotree_ir::chain::context_extension::ContextExtension;
use ergotree_ir::serialization::sigma_byte_reader::SigmaByteRead;
use ergotree_ir::serialization::sigma_byte_writer::SigmaByteWrite;
use ergotree_ir::serialization::SigmaParsingError;
use ergotree_ir::serialization::SigmaSerializable;
use ergotree_ir::serialization::SigmaSerializeResult;

#[cfg(feature = "json")]
pub(crate) mod json;

/// Wrapped IR [`ProverResult`] for Serde
#[cfg_attr(feature = "json", derive(serde::Deserialize))]
#[derive(PartialEq, Eq, Debug, Clone)]
pub struct ProverResult {
    /// proof that satisfies final sigma proposition
    #[cfg_attr(
        feature = "json",
        serde(rename = "proofBytes"),
        serde(with = "crate::chain::json::ProofBytesSerde")
    )]
    pub proof: ProofBytes,
    /// user-defined variables to be put into context
    #[cfg_attr(feature = "json", serde(rename = "extension"))]
    pub extension: ContextExtension,
}

impl From<ergotree_interpreter::sigma_protocol::prover::ProverResult> for ProverResult {
    fn from(ir: ergotree_interpreter::sigma_protocol::prover::ProverResult) -> Self {
        ProverResult {
            proof: ir.proof,
            extension: ir.extension,
        }
    }
}

impl SigmaSerializable for ProverResult {
    fn sigma_serialize<W: SigmaByteWrite>(&self, w: &mut W) -> SigmaSerializeResult {
        self.proof.sigma_serialize(w)?;
        self.extension.sigma_serialize(w)?;
        Ok(())
    }
    fn sigma_parse<R: SigmaByteRead>(r: &mut R) -> Result<Self, SigmaParsingError> {
        let proof = ProofBytes::sigma_parse(r)?;
        let extension = ContextExtension::sigma_parse(r)?;
        Ok(ProverResult { proof, extension })
    }
}

/// Arbitrary impls
#[cfg(feature = "arbitrary")]
pub mod arbitrary {
    use super::*;
    use proptest::prelude::*;

    impl Arbitrary for ProverResult {
        type Parameters = ();
        type Strategy = BoxedStrategy<Self>;

        fn arbitrary_with(_args: Self::Parameters) -> Self::Strategy {
            (any::<ProofBytes>(), any::<ContextExtension>())
                .prop_map(|(proof, extension)| Self { proof, extension })
                .boxed()
        }
    }
}

#[cfg(test)]
#[allow(clippy::panic)]
mod tests {
    use super::*;
    use ergotree_ir::serialization::sigma_serialize_roundtrip;
    use proptest::prelude::*;

    proptest! {

        #[test]
        fn ser_roundtrip(v in any::<ProverResult>()) {
            prop_assert_eq![sigma_serialize_roundtrip(&v), v];
        }
    }
}
