
import ergo_lib_python
from ergo_lib_python.multi_sig import *
import base64
from ergo_lib_python.chain import ContextExtension
from ergo_lib_python.transaction import TxId, UnsignedTransaction, ReducedTransaction, TxBuilder
from ergo_lib_python.multi_sig import TransactionHintsBag
from ergo_lib_python.chain import ErgoBox, ErgoBoxCandidate, Header, PreHeader, ErgoStateContext, Parameters, Address
from ergo_lib_python.wallet import BoxSelection, ExtSecretKey, to_seed, Wallet, DerivationPath

import requests
import math

# c = Constant(5, elem_tpe = SType.SBoolean())
c = ContextExtension({5: ergo_lib_python.chain.Constant.from_i32(2)})



# ergo_lib_python.wallet.MnemonicGenerator("english", 128)
def get_boxes(box_ids):
    return [ErgoBox.from_json(requests.get(
        f"http://localhost:9052/blockchain/box/byId/{box_id}").json()) for box_id in box_ids]


ext_secret_key = ExtSecretKey.derive_master(to_seed(
    "person lemon happy net enemy antenna parent you apology divert enhance slow easy response cover", ""))

sec = ext_secret_key.derive(
    DerivationPath.from_str("m / 44' / 429' / 0' / 0 / 0"))
secrets = [ext_secret_key.secret_key(), sec.secret_key()]
public_keys = [secret.public_image() for secret in secrets]
print("public keys: ", [base64.b16encode(bytes(secret.public_image().h)).lower() for secret in secrets])
wallet_signer1 = Wallet(secrets[:1])
wallet_signer2 = Wallet(secrets[1:])


h: Header = Header.from_json("""{"id":"09687f2114f16b9ebbc56ead8464371cca7088490c28058bda124a6a174186fa","parentId":"605b10eb4c355d768fda7fd0d561a1eddac1716a79bbac6fc1e142df68d5be69","version":3,"timestamp":1738735694623,"height":1454699,"nBits":117796623,"votes":"000000","stateRoot":"fe210a52fbd7652831ad103d506b296283424485095c725abee52c00a1a6399619","adProofsRoot":"90c60f1882bf465b1237b6b50d93ccd41e6b5708cdb099f39b79f01abfcd0b20","transactionsRoot":"efaaf7a13846f040e69d9309d7e61afea1419b0778747bc1ece67b8c83ad9a00","extensionHash":"abd86af408f65bb30e7edda3805af607e016f537aead176ef27124b8882dac9f"
  ,"powSolutions":{"pk":"030ab3e89183caae079bc07685e0ac5b3adc6d40a3e9112fe56e22c655bd41d4da","w":"0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798","n":"f06d593e09be17a6","d":"0"}}""")
headers = [h] * 10
state_ctx = ErgoStateContext(PreHeader(h), headers, Parameters.default())
multi_sig = Address("2SsAXDX3saeoMdgsARqqAzaFtbRWJud76XWzjTFBEwoGPcnit3SinFxbYm6q5FWqAmJrwvTHqo33ugD9VkbfLfRXbXaoTMHaEoimpLuYBLRUv3NFzGbnFt1c")
candidate = ErgoBoxCandidate(value = 10 ** 9,
    script = multi_sig,
    creation_height=1000)
box = ErgoBox.from_box_candidate(candidate, TxId("0" * 64), 0)
box_selection = BoxSelection([box], [])
tx = TxBuilder(box_selection, [ErgoBoxCandidate(value = 10 **8, script = multi_sig, creation_height=1000)], 1000, 9 * 10 ** 8, multi_sig).build()
commitments_signer1 = wallet_signer1.generate_commitments(tx, [box], [], state_ctx)
commitments_signer2 = wallet_signer2.generate_commitments(tx, [box], [], state_ctx)
commitments_signer2.add_hints_for_input(0, commitments_signer1.all_hints_for_input(0))
hints = extract_hints(wallet_signer1.sign_transaction(tx, [box], [], state_ctx, hints_bag=commitments_signer2), [box], [], state_ctx, public_keys, [])
commitments_signer1.add_hints_for_input(0, hints.all_hints_for_input(0))
print(wallet_signer1.sign_transaction(tx, [box], [], state_ctx, hints_bag=commitments_signer1).json())


# tx = UnsignedTransaction.from_json("""{"id": "28a9290bb8d0f60403908919cc65962645c5f5785739e78063c9a8946f0a2296","inputs": [{"boxId": "00ccd41059086f4f2589cc7a1e062a4f919cda4a196e3a7468ec45a23e47a093","extension": {}},{"boxId": "014221a2482a60b77599b01f989792735119a9d1a5bf4dc9030092a495713326","extension": {}},{"boxId": "0148bef5501b3b0d9c1af4dd5a44ae758f8401366d2ef6e7ec47e2cef0fd5035","extension": {}},{"boxId": "01520b7a385e8767678bfa7b1bedd81e3ae7ab0fe262653953462a1cccefde23","extension": {}},{"boxId": "01545f413068f6f1cb2176fc7f968a6eb8da3755dd4ee841d8ad108e3081d9ca","extension": {}},{"boxId": "015b1f00feca56d4b5069d2b2350827456941fb6165683decc4996e9b05bd9dd","extension": {}},{"boxId": "015e85e5e5afe0b669846cabe267490633be4781773f9a9082a157206a8bb67e","extension": {}},{"boxId": "0164a4e3b8a933f8664cdbe57e2610538efee90b7cf25e9da4fcaca0ece102cb","extension": {}},{"boxId": "0168e7c9469368eed5eeedf7801d813b21974bbd8b5f7a48e5116b9e521f56a3","extension": {}},{"boxId": "016fb4f3b9c927e9c3dc98bfc0b02800bdd76d49a9f0813f7e10c1769c769014","extension": {}},{"boxId": "0170526784623a8cc6e415b5819b6b2f750c248bf8d5680574b97c61317c0ff3","extension": {}},{"boxId": "017410f8125405dcdb61376b00f99571048cbefff0d26dd16996f7b3870b93d0","extension": {}},{"boxId": "0179c29acf290d27e7970fdb5cee0064fac8a3aea9aa06fcf8df096d68504b14","extension": {}},{"boxId": "01828cda803fc0a4677c58d2df8a747ba48d232aea78b4002a54608ae160d151","extension": {}},{"boxId": "018ac8587dbbc32dad27e96ada1313fa7a771bbb5614ce5faf770c34cbb772c4","extension": {}},{"boxId": "018d7706e83eb1316cfc45b2d5463bff1ca6c948e813f7f78089607d238f1c7c","extension": {}},{"boxId": "018dd206352765695150e59b7995a180bf6484caf0eb7e1989ffc9458ef9e5ca","extension": {}},{"boxId": "01904153b9b45c971e0bde26ed17abf458af05b741be9278efac9264a11725aa","extension": {}},{"boxId": "0196255571712c6b76b064724ab2b67252a4a67b142494b09c5a58b15a9d53fb","extension": {}},{"boxId": "019c46b71b3c619f2e7ba2a8bbe903833441bf0c1fb05a7903d1197a5f8655d2","extension": {}},{"boxId": "01adf57a5ec42a529174199abfc4d4920f7993346aa996ddadd42dac0257d56c","extension": {}},{"boxId": "01aff1e7d67519e7d84666041742cd9105e33ad32a7ff450db1abf099bd81993","extension": {}},{"boxId": "01b317c62cee69abab10b019c87a01f133451b8bd095ebc50ef08038ae7cb241","extension": {}},{"boxId": "01bbe7f563d59a45efb110d00433e1ed192e396dda377febe5d8ee0df6d35a1c","extension": {}},{"boxId": "01c68811c512c01d94f75508b0ab7adec521bc65ff60bb59b4983217559402dc","extension": {}},{"boxId": "01d32a906532b7eefb3507d87e23ae6a44e4a30b5384db2dcbde500d72ea2ab7","extension": {}},{"boxId": "01d5293d389129cd92b2eae2ac4dc4e4607b42758990c46628e2e8370f2959ef","extension": {}},{"boxId": "01daa84a2594f9917d1dc7b30b18c0d69d7e0bf2536fe5998d62a5cb2c54ea48","extension": {}},{"boxId": "01e634e173ad5071a582b74cc17a954b2bf91fee45feb292b662be4b4fee978a","extension": {}},{"boxId": "01e7bf9f9b9b39ec598a1ad0d4622c983711a60e0c855ad5dea330e9d1517dc6","extension": {}},{"boxId": "01e830850e87cc4004421b4e91b51ad0180e40fe097ccaa7fb2570066f17d2d6","extension": {}},{"boxId": "01eacf01148d2af9b0e5401fec73f26937d4b17d9dc3406b99c13b175d578ce9","extension": {}},{"boxId": "01ebb8970153a8fc29421a724a1ac264cee86408ca7dcc191bdecc02be274a19","extension": {}},{"boxId": "01ee0b5f3977466e8b51b4eef8d18949a87bf2152196a3d3eec7f79bfd6a08da","extension": {}},{"boxId": "01ee6f3474b2a5bd93666fa2e475a6ec31f6b780cce3c308950af7dde975eee2","extension": {}},{"boxId": "01eed0487f175eadc66da25e92605468603b9fd300001f34c0869e8fb6f6983f","extension": {}},{"boxId": "01f0654549585026dc46cd7767f3bab90b028ad45984f987eb8c6ecbd8504bd8","extension": {}},{"boxId": "01f15c6bde40060d5299d1fc42c01f1b904bf2e77f48fc6115cd9b67dbfc67b4","extension": {}},{"boxId": "01f307c78b5a3bfadc6c0cc20993c0f5743adf589fc0d7eb952a655f01833706","extension": {}},{"boxId": "01f467a9d3b0fb39ff55d10555643be76f47243fe848fb68bc03a98930a5aee1","extension": {}},{"boxId": "01f94fd3f5602a8fb613b58e0985347f9da7610da24e0574519d42ad09d9cdba","extension": {}},{"boxId": "02014998ebd558fb0b613ea2b4f9009eeeb355c7af5e7384c11cc0681d82d8ee","extension": {}},{"boxId": "0202d78a3e76b6cd7afa1a854ff4cf931e4c0684310db233967dffc3acb56c4c","extension": {}},{"boxId": "021af7cffd1c60a046899eb9a0cb70d4bfa0863b6fbea578c676f45e37728cd8","extension": {}},{"boxId": "022807564cc013d6836c844d1dfd69d2db1995e43aaffda5786e2d151af69b3f","extension": {}},{"boxId": "0232fb0766f550017d7bae183398478277de9764a9084cf3f3210e6f6cfeca67","extension": {}},{"boxId": "0234974938693ed98a5fa023e3472c0d7ee1607c7b9480c77d0ebe1b4c39af3b","extension": {}},{"boxId": "0236f31869cb5dd07db112d9c970ded8a24632949327caef3237e546ea021770","extension": {}},{"boxId": "0238a511042d90d595888fd91b0a92cedd1d5a0ce1330cba25f38a1a98681997","extension": {}},{"boxId": "0240b20e85a4181a2f6fde2227447872bba799a38ae232ce0012775c5c767b59","extension": {}},{"boxId": "0243d2a9d61ec4c401c8529e6395a63da8c852a72a01730b5480db228276c0e5","extension": {}},{"boxId": "0244300702790f84c7122d9487624033dec6e4aafdd7bac6985f60cd327d18d4","extension": {}},{"boxId": "024a158d99ddc80429929b1849afe37679e6e77e4ee03bc814730bc15d9ae326","extension": {}},{"boxId": "024af299af575396ed19597d5b5775d28261c6a1518a4a698bd0f7214a8abda4","extension": {}},{"boxId": "025e1188719b0cc21232e34645634ad2a6c39999d0c6f05156d38a7cc1457e21","extension": {}},{"boxId": "025e725ea02bade5e020df30174b00ba71741ee119203425d88848f25611144d","extension": {}},{"boxId": "0264af3926b6b1ae631de161716071d2ba8ed582607b9e5664ddf7f5b2bf9094","extension": {}},{"boxId": "026906817ea7dda12b3c3daeb9919994ec3ded7c16eb2447024cba3c85165e75","extension": {}},{"boxId": "0269a489aa5e55370724dd74b82f8e67edd7336316e443446340582226b5f51a","extension": {}},{"boxId": "026e5dd284fcd9d24ef0096d6023f02c8d18a9445480307f5b0798c07b633bd8","extension": {}},{"boxId": "02755ac60c0763d9245c3fd11e97873c78c084a1e932a46a5a2b1bd2ebbf3d53","extension": {}},{"boxId": "027624f79c9b2b18544d8cf8168e81c1c6523acfab6baa837bdcee3d0ffd94fb","extension": {}},{"boxId": "0278dc0de1be7c222f8159bcca7c038060ab586c156306cfe08c4ab548968ec0","extension": {}},{"boxId": "027e7f4238fa933cd1e36f474bbadf08c0266832a24d1fce2698518363c8abaa","extension": {}},{"boxId": "028a4f02a8df5c340a67baacc54da3228d1a01e94b48be97082539b9aff0a2ac","extension": {}},{"boxId": "028d9d32b20cd516b9cf9c4252dc057896c7bf25040da6b955d31170cc8b69d8","extension": {}},{"boxId": "0297b14d4ec138aa7a5124579edbacecfa6d265ec5cab8e91d2b3e877e5f7a53","extension": {}},{"boxId": "0298d258cf78f276c3ad675621780033b9919b6ecaf2b2b6a7c07d1b9aca6d72","extension": {}},{"boxId": "02a01d2ee35a18bd849242a2a6a9920ad58562dcb5e38b9e03a69aea751d6e20","extension": {}},{"boxId": "02a4e19484c695ebe56db1b906b4ab83f07049a1410b48e34c98c8405fcf9526","extension": {}},{"boxId": "02a50e8bed56b62b5eae9b05947d641e420b8db467fb6d45eb27a1c0e40c15d6","extension": {}},{"boxId": "02b2cabe57c55f507326bb78d0f2a0a3d22816d0ced35514b058d9b718fcf565","extension": {}},{"boxId": "02c1d889888e165e673fcc3d30a8bbfb8684f350c6ed94cf89d8b8c4ace2e314","extension": {}},{"boxId": "02c73815eb3e5ec28a474c85e685bcac04d22adf58f66d8f0b564e222116b843","extension": {}},{"boxId": "02ca186c90970b2fd2c855d9b1bb0db1220d63fbcb643f1cb292392bd3134834","extension": {}},{"boxId": "02cd20af81d22b21afc05eb54810f59ee5f184603f59aee02d2a4e36ff28ea68","extension": {}},{"boxId": "02d34ed558c2f49a18c906eeafbcb5875bbd05931fb6a1b8bc41d96a9bf0b536","extension": {}},{"boxId": "02d5f0e77e1329e46c264787d57871ef72d581a61e76ee4a1d4444a02054dbcd","extension": {}},{"boxId": "02d7cdcf635aa23d8fddf0a7e7efbf366937c3f150e3a6f8ab41b77c2667ead0","extension": {}},{"boxId": "02dceb39e0dfedef382c220f95ba427dbeca574a5811aa6367e008c36ab96865","extension": {}},{"boxId": "02e830ff1d246076ccf729bda8027aa4acd6aa5936c5bae058cd8dbe4d291341","extension": {}},{"boxId": "02ea8a950afcbcbadb0ab022941ae6cdfcd6025d6994ebe32a7d8a45114a8019","extension": {}},{"boxId": "03056d9e55829c9aac79dbf6b13a9a177e8679d473333aba6b270707cde4743a","extension": {}},{"boxId": "030b7ad19aa84f3827dbd1b78b14993c5aa15cefc4bd04877cf8630fbec80953","extension": {}},{"boxId": "031ff2be9fbd7b77f4948cf273707dad12b750d7070b03c767a8e99883f91abd","extension": {}},{"boxId": "032bbf4bef86cc42dd6998a0628d705b69148a941405d5177e75738004413632","extension": {}},{"boxId": "032de59ee907270b65b429d5be5a48ab133a4d9c8409b5d6affe9fdc089e8cec","extension": {}},{"boxId": "0334448bc7a44b6a966536bbb75bc1d643e06bfe94b7d84648e4ab77fa628e79","extension": {}},{"boxId": "03371281081e5d31227bafcd21444f91ad2fb29bdce63d30407a86611bb3fe1b","extension": {}},{"boxId": "0337831620201b7fd7590a693125684a0e60b78377c02d72b9d541281e04b88f","extension": {}},{"boxId": "0339c4cb169c8771f0e0d5771d61c127945cc330749dc26c8fbc3d96716a0b75","extension": {}},{"boxId": "03406692c882018b8aadf0f63df4286861fed8a0c6e8635f04392eea4f1191d1","extension": {}},{"boxId": "0342ed972194e2a7f452c7047e1aaaecab782ebce9de2c1d7d769812ead55482","extension": {}},{"boxId": "0343aef1269afc662bbc2cd49ee149c847f511578829ceb14b817e55e2b89365","extension": {}},{"boxId": "03498182dedac38babf05570e1caef2da83f6a432047d5c37fbccc4a334edb1b","extension": {}},{"boxId": "0355def59c6c2c1f62f68027e372a028edafe481cb3218f77a33843aae921bb5","extension": {}},{"boxId": "0358d70a68cd3767275ce08c857505eb363f6bbbc91b4151cde77e25d0f0dc04","extension": {}},{"boxId": "035de6ae71f4b8fa4f2f4476e9903c694aa218831760a9be066a5916955ed000","extension": {}},{"boxId": "036244da33c51ccc6903b247d3c0fb099c36e194b85e8e174ff7238b569cfdde","extension": {}},{"boxId": "036dbb8193f9c511b3429092808635535579473065d0c776a7788b43fda3105a","extension": {}}],"dataInputs": [],"outputs": [{"boxId": "4be06a838d57cc490bb20e7fb6d5b34d9c714007dab3d742418b567d881c8065","value": 10000000,"ergoTree": "0008cd028333f9f7454f8d5ff73dbac9833767ed6fc3a86cf0a73df946b32ea9927d9197","assets": [],"creationHeight": 13651,"additionalRegisters": {"R4": "100204a00b"},"transactionId": "28a9290bb8d0f60403908919cc65962645c5f5785739e78063c9a8946f0a2296","index": 0},{"boxId": "9f8611586d23c1ee82cd5645eaef4785cf7dc29b5e46be7f559fd25a497a57f7","value": 6749990000000,"ergoTree": "0008cd02978f626f3d84d9b7245fb10082c8ef47a60b10178b1626a34232217bf85a26db","assets": [],"creationHeight": 13651,"additionalRegisters": {},"transactionId": "28a9290bb8d0f60403908919cc65962645c5f5785739e78063c9a8946f0a2296","index": 1}]}""")
# print(tx.inputs)
# boxes = get_boxes([input.box_id for input in tx.inputs])
# hints_bag = wallet.generate_commitments(tx, boxes, [], state_ctx)
# print(hints_bag.json())
# reduced = ReducedTransaction.from_unsigned_tx(tx, boxes, [], state_ctx)
# addr = sec.public_key().address()
# signed = wallet.sign_transaction(
#     reduced, hints_bag=hints_bag)
# sig = wallet.sign_message_using_p2pk(addr, bytes("hello", encoding="utf-8"))
# print(len(sig))
# print(verify_signature(addr, bytes("hello", encoding="utf-8"), sig))
# print(verify_signature(addr, bytes("hello", encoding="utf-8"), sig))
# # print(extract_hints(signed, boxes, [], state_ctx,
# #       [ProveDlog(sec.public_key().public_key())], []).json())
