/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoAddressEncoder;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.Pay2SAddress;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.impl.ErgoTreeContract;
import org.ergoplatform.wallet.secrets.DerivationPath;
import org.ergoplatform.wallet.secrets.ExtendedPublicKey;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import scala.util.Try;
import scorex.util.encode.Base58;
import sigmastate.Values;
import sigmastate.basics.DLogProtocol;
import sigmastate.eval.CostingSigmaDslBuilder$;
import sigmastate.utils.Helpers;
import special.sigma.GroupElement;

public class Address {
    private final String _base58String;
    private final byte[] _addrBytes;
    ErgoAddress _address;

    public Address(ErgoAddress ergoAddress) {
        this._address = ergoAddress;
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply(ergoAddress.networkPrefix());
        this._base58String = ergoAddressEncoder.toString(this._address);
        this._addrBytes = Base58.decode(this._base58String).get();
    }

    private byte headByte() {
        return this._addrBytes[0];
    }

    private Address(String string) {
        this._base58String = string;
        Try<byte[]> try_ = Base58.decode(string);
        if (try_.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, new Helpers.TryOps<byte[]>(try_).toEither().left().get());
        }
        this._addrBytes = try_.get();
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply(this.getNetworkType().networkPrefix);
        Try<ErgoAddress> try_2 = ergoAddressEncoder.fromString(string);
        if (try_2.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, new Helpers.TryOps<ErgoAddress>(try_2).toEither().left().get());
        }
        this._address = try_2.get();
    }

    public NetworkType getNetworkType() {
        return this.isMainnet() ? NetworkType.MAINNET : NetworkType.TESTNET;
    }

    public boolean isMainnet() {
        return this.headByte() < NetworkType.TESTNET.networkPrefix;
    }

    public boolean isP2PK() {
        return this._address instanceof P2PKAddress;
    }

    public P2PKAddress asP2PK() {
        Preconditions.checkArgument(this.isP2PK(), "This instance %s is not P2PKAddress", (Object)this);
        return (P2PKAddress)this._address;
    }

    public boolean isP2S() {
        return this._address instanceof Pay2SAddress;
    }

    public Pay2SAddress asP2S() {
        Preconditions.checkArgument(this.isP2S(), "This instance %s is not Pay2SAddress", (Object)this);
        return (Pay2SAddress)this._address;
    }

    public ErgoAddress getErgoAddress() {
        return this._address;
    }

    public DLogProtocol.ProveDlog getPublicKey() {
        return this.asP2PK().pubkey();
    }

    public GroupElement getPublicKeyGE() {
        SecP256K1Point secP256K1Point = this.getPublicKey().value();
        return CostingSigmaDslBuilder$.MODULE$.GroupElement(secP256K1Point);
    }

    public ErgoContract toErgoContract() {
        return new ErgoTreeContract(this.getErgoAddress().script(), this.getNetworkType());
    }

    public static Address create(String string) {
        return new Address(string);
    }

    public static Address fromMnemonic(NetworkType networkType, Mnemonic mnemonic) {
        return Address.fromMnemonic(networkType, mnemonic.getPhrase(), mnemonic.getPassword());
    }

    public static Address fromMnemonic(NetworkType networkType, SecretString secretString, SecretString secretString2) {
        ExtendedSecretKey extendedSecretKey = JavaHelpers.seedToMasterKey(secretString, secretString2);
        DLogProtocol.ProveDlog proveDlog = extendedSecretKey.publicImage();
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress(proveDlog, networkType.networkPrefix);
        return new Address(p2PKAddress);
    }

    public static Address createEip3Address(int n, NetworkType networkType, SecretString secretString, SecretString secretString2) {
        ExtendedSecretKey extendedSecretKey = JavaHelpers.seedToMasterKey(secretString, secretString2);
        DerivationPath derivationPath = JavaHelpers.eip3DerivationParent();
        ExtendedSecretKey extendedSecretKey2 = (ExtendedSecretKey)extendedSecretKey.derive(derivationPath);
        ExtendedPublicKey extendedPublicKey = extendedSecretKey2.publicKey();
        return Address.createEip3Address(n, networkType, extendedPublicKey);
    }

    public static Address createEip3Address(int n, NetworkType networkType, ExtendedPublicKey extendedPublicKey) {
        DerivationPath derivationPath = JavaHelpers.eip3DerivationWithLastIndex(n).toPublicBranch();
        ExtendedPublicKey extendedPublicKey2 = (ExtendedPublicKey)extendedPublicKey.derive(derivationPath);
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress(extendedPublicKey2.key(), networkType.networkPrefix);
        return new Address(p2PKAddress);
    }

    public static Address fromErgoTree(Values.ErgoTree ergoTree, NetworkType networkType) {
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply(networkType.networkPrefix);
        ErgoAddress ergoAddress = ergoAddressEncoder.fromProposition(ergoTree).get();
        return new Address(ergoAddress);
    }

    public String toString() {
        return this._address.toString();
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Address) {
            return this._address.equals(((Address)object)._address);
        }
        return false;
    }
}

