/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BlockchainContextBuilder;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoNodeFacade;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.NodeInfo;
import retrofit2.Retrofit;

public class BlockchainContextBuilderImpl
implements BlockchainContextBuilder {
    private final ApiClient _client;
    private ExplorerApiClient _explorer;
    private final NetworkType _networkType;
    private OkHttpClient _ok;
    private Retrofit _retrofit;
    private NodeInfo _nodeInfo;
    private List<BlockHeader> _headers;
    private Retrofit _retrofitExplorer;

    public BlockchainContextBuilderImpl(ApiClient apiClient, ExplorerApiClient explorerApiClient, NetworkType networkType) {
        this._client = apiClient;
        this._explorer = explorerApiClient;
        this._networkType = networkType;
    }

    @Override
    public BlockchainContext build() throws ErgoClientException {
        this._ok = this._client.getOkBuilder().build();
        this._retrofit = this._client.getAdapterBuilder().client(this._ok).build();
        if (this._explorer != null) {
            OkHttpClient okHttpClient = this._explorer.getOkBuilder().build();
            this._retrofitExplorer = this._explorer.getAdapterBuilder().client(okHttpClient).build();
        }
        this._nodeInfo = ErgoNodeFacade.getNodeInfo(this._retrofit);
        this._headers = ErgoNodeFacade.getLastHeaders(this._retrofit, BigDecimal.valueOf(10L));
        Collections.reverse(this._headers);
        return new BlockchainContextImpl(this._client, this._retrofit, this._explorer, this._retrofitExplorer, this._networkType, this._nodeInfo, this._headers);
    }
}

