/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.impl.ApiFacade;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.BlocksApi;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.InfoApi;
import org.ergoplatform.restapi.client.NodeInfo;
import org.ergoplatform.restapi.client.Transactions;
import org.ergoplatform.restapi.client.TransactionsApi;
import org.ergoplatform.restapi.client.UtxoApi;
import org.ergoplatform.restapi.client.WalletApi;
import org.ergoplatform.restapi.client.WalletBox;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.RetrofitUtil;

public class ErgoNodeFacade
extends ApiFacade {
    public static NodeInfo getNodeInfo(Retrofit retrofit) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = InfoApi.class.getMethod("getNodeInfo", new Class[0]);
            NodeInfo nodeInfo = (NodeInfo)RetrofitUtil.invokeServiceMethod(retrofit, method, null).execute().body();
            return nodeInfo;
        });
    }

    public static List<BlockHeader> getLastHeaders(Retrofit retrofit, BigDecimal bigDecimal) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = BlocksApi.class.getMethod("getLastHeaders", BigDecimal.class);
            List list = (List)RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{bigDecimal}).execute().body();
            return list;
        });
    }

    public static ErgoTransactionOutput getBoxById(Retrofit retrofit, String string) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = UtxoApi.class.getMethod("getBoxById", String.class);
            ErgoTransactionOutput ergoTransactionOutput = (ErgoTransactionOutput)RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{string}).execute().body();
            return ergoTransactionOutput;
        });
    }

    public static ErgoTransactionOutput getBoxWithPoolById(Retrofit retrofit, String string) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = UtxoApi.class.getMethod("getBoxWithPoolById", String.class);
            ErgoTransactionOutput ergoTransactionOutput = (ErgoTransactionOutput)RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{string}).execute().body();
            return ergoTransactionOutput;
        });
    }

    public static List<WalletBox> getWalletUnspentBoxes(Retrofit retrofit, Integer n, Integer n2) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = WalletApi.class.getMethod("walletUnspentBoxes", Integer.class, Integer.class);
            List list = (List)RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{n, n2}).execute().body();
            return list;
        });
    }

    public static String sendTransaction(Retrofit retrofit, ErgoTransaction ergoTransaction) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = TransactionsApi.class.getMethod("sendTransaction", ErgoTransaction.class);
            Response response = RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{ergoTransaction}).execute();
            if (!response.isSuccessful()) {
                throw new ErgoClientException(response.code() + ": " + (response.errorBody() != null ? response.errorBody().string() : "Server returned error"), null);
            }
            return (String)response.body();
        });
    }

    public static Transactions getUnconfirmedTransactions(Retrofit retrofit, int n, int n2) throws ErgoClientException {
        return ErgoNodeFacade.execute(retrofit, () -> {
            Method method = TransactionsApi.class.getMethod("getUnconfirmedTransactions", Integer.class, Integer.class);
            Response response = RetrofitUtil.invokeServiceMethod(retrofit, method, new Object[]{n, n2}).execute();
            if (!response.isSuccessful()) {
                throw new ErgoClientException(response.code() + ": " + (response.errorBody() != null ? response.errorBody().string() : "Server returned error"), null);
            }
            return (Transactions)response.body();
        });
    }
}

