/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.ReducedErgoLikeTransaction;
import org.ergoplatform.appkit.ReducedErgoLikeTransactionSerializer$;
import org.ergoplatform.appkit.ReducedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import scala.collection.JavaConversions;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.utils.SigmaByteWriter;

public class ReducedTransactionImpl
implements ReducedTransaction {
    private final BlockchainContextBase _ctx;
    private final ReducedErgoLikeTransaction _tx;
    private final int _txCost;

    public ReducedTransactionImpl(BlockchainContextBase blockchainContextBase, ReducedErgoLikeTransaction reducedErgoLikeTransaction, int n) {
        this._ctx = blockchainContextBase;
        this._tx = reducedErgoLikeTransaction;
        this._txCost = n;
    }

    @Override
    public String getId() {
        return this.getTx().unsignedTx().id();
    }

    @Override
    public List<String> getInputBoxesIds() {
        List<UnsignedInput> list = JavaConversions.seqAsJavaList(this.getTx().unsignedTx().inputs());
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (UnsignedInput unsignedInput : list) {
            arrayList.add(new ErgoId(unsignedInput.boxId()).toString());
        }
        return arrayList;
    }

    @Override
    public List<OutBox> getOutputs() {
        List<ErgoBox> list = JavaConversions.seqAsJavaList(this._tx.unsignedTx().outputs());
        ArrayList<OutBox> arrayList = new ArrayList<OutBox>(list.size());
        for (ErgoBoxCandidate ergoBoxCandidate : list) {
            arrayList.add(new OutBoxImpl(this._ctx, ergoBoxCandidate));
        }
        return arrayList;
    }

    @Override
    public ReducedErgoLikeTransaction getTx() {
        return this._tx;
    }

    @Override
    public int getCost() {
        return this._txCost;
    }

    @Override
    public byte[] toBytes() {
        SigmaByteWriter sigmaByteWriter = SigmaSerializer$.MODULE$.startWriter();
        ReducedErgoLikeTransactionSerializer$.MODULE$.serialize(this._tx, sigmaByteWriter);
        sigmaByteWriter.putUInt(this._txCost);
        return sigmaByteWriter.toBytes();
    }

    public int hashCode() {
        return 31 * this._tx.hashCode() + this._txCost;
    }

    public boolean equals(Object object) {
        if (object instanceof ReducedTransactionImpl) {
            ReducedTransactionImpl reducedTransactionImpl = (ReducedTransactionImpl)object;
            return Objects.equals(reducedTransactionImpl._tx, this._tx) && reducedTransactionImpl._txCost == this._txCost;
        }
        return false;
    }
}

